/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.semiblock;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.ItemSearcherScreen;
import me.desht.pneumaticcraft.client.gui.semiblock.LogisticsLiquidFilterScreen;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.gui.widget.WidgetCheckBox;
import me.desht.pneumaticcraft.client.gui.widget.WidgetFluidStack;
import me.desht.pneumaticcraft.client.gui.widget.WidgetLabel;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTextFieldNumber;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.core.ModMenuTypes;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractLogisticsFrameEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.entity.semiblock.LogisticsRequesterEntity;
import me.desht.pneumaticcraft.common.inventory.LogisticsMenu;
import me.desht.pneumaticcraft.common.inventory.slot.PhantomSlot;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSyncSemiblock;
import me.desht.pneumaticcraft.common.semiblock.ISpecificRequester;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

public class AbstractLogisticsScreen<L extends AbstractLogisticsFrameEntity>
extends AbstractPneumaticCraftContainerScreen<LogisticsMenu, AbstractPneumaticCraftBlockEntity> {
    protected final L logistics;
    private ItemSearcherScreen itemSearchGui;
    private LogisticsLiquidFilterScreen fluidSearchGui;
    private int editingSlot;
    private WidgetLabel itemLabel;
    private WidgetLabel fluidLabel;
    private WidgetButtonExtended itemWhitelist;
    private WidgetButtonExtended fluidWhitelist;
    private final List<WidgetFluidStack> fluidWidgets = new ArrayList<WidgetFluidStack>();
    private WidgetTextFieldNumber minItemsField;
    private WidgetTextFieldNumber minFluidField;

    public AbstractLogisticsScreen(LogisticsMenu menu, Inventory inv, Component displayString) {
        super(menu, inv, displayString);
        this.logistics = menu.logistics;
        this.f_97727_ = 216;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        if (this.itemSearchGui != null) {
            this.updateItemFilter(this.editingSlot, this.itemSearchGui.getSearchStack());
            this.itemSearchGui = null;
        }
        if (this.fluidSearchGui != null && this.fluidSearchGui.getFilter() != null) {
            this.updateFluidFilter(this.editingSlot, new FluidStack(this.fluidSearchGui.getFilter(), 1000));
            this.fluidSearchGui = null;
        }
        MutableComponent invisibleText = PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.invisible", new Object[0]);
        WidgetCheckBox invisible = new WidgetCheckBox(this.f_97735_ + this.f_97726_ - 20 - this.f_96547_.m_92852_((FormattedText)invisibleText), this.f_97736_ + 17, -12566464, (Component)invisibleText, b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setSemiblockInvisible(b.checked);
            this.syncToServer();
        }).setChecked(((AbstractLogisticsFrameEntity)this.logistics).isSemiblockInvisible());
        this.m_142416_((GuiEventListener)invisible);
        invisible.setTooltipKey("pneumaticcraft.gui.logistics_frame.invisible.tooltip");
        this.itemWhitelist = new WidgetButtonExtended(this.f_97735_ + 5, this.f_97736_ + 16, 12, 12, (Component)Component.m_237119_(), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setItemWhiteList(!((AbstractLogisticsFrameEntity)this.logistics).isItemWhiteList());
            this.updateLabels();
            this.syncToServer();
        }).setVisible(false).setInvisibleHoverColor(-2139062144);
        this.m_142416_((GuiEventListener)this.itemWhitelist);
        this.itemWhitelist.f_93624_ = ((AbstractLogisticsFrameEntity)this.logistics).supportsBlacklisting();
        this.fluidWhitelist = new WidgetButtonExtended(this.f_97735_ + 5, this.f_97736_ + 88, 12, 12, (Component)Component.m_237119_(), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setFluidWhiteList(!((AbstractLogisticsFrameEntity)this.logistics).isFluidWhiteList());
            this.updateLabels();
            this.syncToServer();
        }).setVisible(false).setInvisibleHoverColor(-2139062144);
        this.m_142416_((GuiEventListener)this.fluidWhitelist);
        this.fluidWhitelist.f_93624_ = ((AbstractLogisticsFrameEntity)this.logistics).supportsBlacklisting();
        int xOff = ((AbstractLogisticsFrameEntity)this.logistics).supportsBlacklisting() ? 13 : 0;
        this.itemLabel = new WidgetLabel(this.f_97735_ + 5 + xOff, this.f_97736_ + 18, (Component)Component.m_237119_()){

            public void m_5716_(double mouseX, double mouseY) {
                if (AbstractLogisticsScreen.this.itemWhitelist.f_93624_) {
                    AbstractLogisticsScreen.this.itemWhitelist.m_5716_(mouseX, mouseY);
                }
            }
        };
        this.m_142416_((GuiEventListener)this.itemLabel);
        this.fluidLabel = new WidgetLabel(this.f_97735_ + 5 + xOff, this.f_97736_ + 90, (Component)Component.m_237119_()){

            public void m_5716_(double mouseX, double mouseY) {
                if (AbstractLogisticsScreen.this.fluidWhitelist.f_93624_) {
                    AbstractLogisticsScreen.this.fluidWhitelist.m_5716_(mouseX, mouseY);
                }
            }
        };
        this.m_142416_((GuiEventListener)this.fluidLabel);
        this.updateLabels();
        this.fluidWidgets.clear();
        IntStream.range(0, 9).forEach(i -> {
            FluidStack stack = ((AbstractLogisticsFrameEntity)this.logistics).getFluidFilter(i);
            PointXY p = this.getFluidSlotPos(i);
            WidgetFluidStack widgetFluidStack = new WidgetFluidStack(p.x(), p.y(), stack.copy(), w -> this.fluidClicked((WidgetFluidStack)w, i));
            if (this.logistics instanceof LogisticsRequesterEntity) {
                widgetFluidStack.setAdjustable();
            }
            this.fluidWidgets.add(widgetFluidStack);
        });
        this.fluidWidgets.forEach(x$0 -> {
            WidgetFluidStack cfr_ignored_0 = (WidgetFluidStack)this.m_142416_((GuiEventListener)x$0);
        });
        this.addInfoTab(GuiUtils.xlateAndSplit("gui.tooltip.item.pneumaticcraft." + ((AbstractSemiblockEntity)this.logistics).getSemiblockId().m_135815_(), new Object[0]));
        this.addFilterTab();
        this.addJeiFilterInfoTab();
        if (this.logistics instanceof ISpecificRequester) {
            this.addMinOrderSizeTab();
        }
    }

    private void addMinOrderSizeTab() {
        WidgetAnimatedStat minAmountStat = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_amount", new Object[0]), new ItemStack((ItemLike)Blocks.f_50087_), -4145024, false);
        WidgetLabel minItemsLabel = new WidgetLabel(5, 20, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_items", new Object[0]));
        minItemsLabel.setTooltip((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_items.tooltip", new Object[0]));
        minAmountStat.addSubWidget(minItemsLabel);
        this.minItemsField = new WidgetTextFieldNumber(this.f_96547_, 5, 30, 30, 12).setRange(1, 64).setAdjustments(1.0, 10.0).setValue(((ISpecificRequester)this.logistics).getMinItemOrderSize());
        this.minItemsField.m_94151_(s -> this.sendDelayed(8));
        minAmountStat.addSubWidget((AbstractWidget)this.minItemsField);
        WidgetLabel minFluidLabel = new WidgetLabel(5, 47, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_fluid", new Object[0]));
        minFluidLabel.setTooltip((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.min_fluid.tooltip", new Object[0]));
        minAmountStat.addSubWidget(minFluidLabel);
        this.minFluidField = new WidgetTextFieldNumber(this.f_96547_, 5, 57, 50, 12).setRange(1, 16000).setAdjustments(100.0, 1000.0).setValue(((ISpecificRequester)this.logistics).getMinFluidOrderSize());
        this.minFluidField.m_94151_(s -> this.sendDelayed(8));
        minAmountStat.addSubWidget((AbstractWidget)this.minFluidField);
        int w = Math.max(minItemsLabel.m_5711_(), minFluidLabel.m_5711_());
        minAmountStat.setMinimumExpandedDimensions(w, 75);
    }

    @Override
    protected void doDelayedAction() {
        L l = this.logistics;
        if (l instanceof ISpecificRequester) {
            ISpecificRequester s = (ISpecificRequester)l;
            s.setMinItemOrderSize(this.minItemsField.getIntValue());
            s.setMinFluidOrderSize(this.minFluidField.getIntValue());
            this.syncToServer();
        }
    }

    public void updateItemFilter(int slot, ItemStack stack) {
        ((LogisticsMenu)this.f_97732_).m_38853_(slot).m_5852_(stack);
        ((AbstractLogisticsFrameEntity)this.logistics).setItemFilter(slot, stack);
        this.syncToServer();
    }

    public void updateFluidFilter(int slot, FluidStack stack) {
        ((AbstractLogisticsFrameEntity)this.logistics).setFluidFilter(slot, stack);
        if (!this.fluidWidgets.isEmpty()) {
            this.fluidWidgets.get(slot).setFluidStack(stack);
        }
        this.syncToServer();
    }

    public PointXY getFluidSlotPos(int slot) {
        return new PointXY(this.f_97735_ + slot * 18 + 8, this.f_97736_ + 101);
    }

    private void updateLabels() {
        ChatFormatting s1 = ((AbstractLogisticsFrameEntity)this.logistics).isItemWhiteList() ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH;
        ChatFormatting s2 = ((AbstractLogisticsFrameEntity)this.logistics).isFluidWhiteList() ? ChatFormatting.RESET : ChatFormatting.STRIKETHROUGH;
        this.itemLabel.m_93666_((Component)PneumaticCraftUtils.xlate(String.format("pneumaticcraft.gui.%s.itemFilters", ((AbstractSemiblockEntity)this.logistics).getSemiblockId().m_135815_()), new Object[0]).m_130940_(s1));
        this.fluidLabel.m_93666_((Component)PneumaticCraftUtils.xlate(String.format("pneumaticcraft.gui.%s.fluidFilters", ((AbstractSemiblockEntity)this.logistics).getSemiblockId().m_135815_()), new Object[0]).m_130940_(s2));
        this.itemWhitelist.setRenderedIcon(((AbstractLogisticsFrameEntity)this.logistics).isItemWhiteList() ? Textures.GUI_WHITELIST : Textures.GUI_BLACKLIST);
        this.fluidWhitelist.setRenderedIcon(((AbstractLogisticsFrameEntity)this.logistics).isFluidWhiteList() ? Textures.GUI_WHITELIST : Textures.GUI_BLACKLIST);
    }

    private void syncToServer() {
        NetworkHandler.sendToServer(new PacketSyncSemiblock((ISemiBlock)this.logistics, ((LogisticsMenu)this.f_97732_).isItemContainer()));
    }

    private void fluidClicked(WidgetFluidStack widget, int idx) {
        FluidStack stack = ((AbstractLogisticsFrameEntity)this.logistics).getFluidFilter(idx);
        if (!stack.isEmpty()) {
            ((AbstractLogisticsFrameEntity)this.logistics).setFluidFilter(idx, widget.getFluidStack().copy());
            this.syncToServer();
            return;
        }
        if (((LogisticsMenu)this.f_97732_).m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            FluidStack f = ((LogisticsMenu)this.f_97732_).m_142621_().getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
            ((AbstractLogisticsFrameEntity)this.logistics).setFluidFilter(idx, f.isEmpty() ? FluidStack.EMPTY : new FluidStack(f, 1000));
            widget.setFluid(f.getFluid());
            this.syncToServer();
            return;
        }
        this.fluidSearchGui = new LogisticsLiquidFilterScreen((Screen)this);
        this.editingSlot = idx;
        this.f_96541_.m_91152_((Screen)this.fluidSearchGui);
    }

    private void addFilterTab() {
        WidgetAnimatedStat filterTab = this.addAnimatedStat((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.filter_settings", new Object[0]), PneumaticRegistry.RL("textures/gui/icon/gui_filter.png"), -15704048, false);
        filterTab.setMinimumExpandedDimensions(80, 65);
        WidgetCheckBox matchDurability = new WidgetCheckBox(5, 20, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchDurability", new Object[0]), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setMatchDurability(b.checked);
            this.syncToServer();
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchDurability.tooltip").setChecked(((AbstractLogisticsFrameEntity)this.logistics).isMatchDurability());
        filterTab.addSubWidget(matchDurability);
        WidgetCheckBox matchNBT = new WidgetCheckBox(5, 36, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchNBT", new Object[0]), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setMatchNBT(b.checked);
            this.syncToServer();
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchNBT.tooltip").setChecked(((AbstractLogisticsFrameEntity)this.logistics).isMatchNBT());
        filterTab.addSubWidget(matchNBT);
        WidgetCheckBox matchModId = new WidgetCheckBox(5, 52, -1, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.logistics_frame.matchModId", new Object[0]), b -> {
            ((AbstractLogisticsFrameEntity)this.logistics).setMatchModId(b.checked);
            this.syncToServer();
        }).setTooltipKey("pneumaticcraft.gui.logistics_frame.matchModId.tooltip").setChecked(((AbstractLogisticsFrameEntity)this.logistics).isMatchModId());
        filterTab.addSubWidget(matchModId);
    }

    @Override
    protected int getBackgroundTint() {
        if (!((Boolean)ConfigHelper.client().general.logisticsGuiTint.get()).booleanValue()) {
            return super.getBackgroundTint();
        }
        int c = ((AbstractLogisticsFrameEntity)this.logistics).getColor();
        float[] hsb = TintColor.RGBtoHSB((c & 0xFF0000) >> 16, (c & 0xFF00) >> 8, c & 0xFF, null);
        TintColor color = TintColor.getHSBColor(hsb[0], hsb[1] * 0.2f, hsb[2]);
        if ((double)hsb[2] < 0.7) {
            color = color.brighter();
        }
        return color.getRGB();
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_LOGISTICS_REQUESTER;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    protected void m_6597_(Slot slot, int slotId, int clickedButton, ClickType clickType) {
        if (slot instanceof PhantomSlot && ((LogisticsMenu)this.f_97732_).m_142621_().m_41619_() && !slot.m_6657_() && (clickedButton == 0 || clickedButton == 1)) {
            this.editingSlot = slot.getSlotIndex();
            ClientUtils.openContainerGui((MenuType<? extends AbstractContainerMenu>)((MenuType)ModMenuTypes.ITEM_SEARCHER.get()), (Component)Component.m_237113_((String)"Searcher"));
            if (this.f_96541_.f_91080_ instanceof ItemSearcherScreen) {
                this.itemSearchGui = (ItemSearcherScreen)this.f_96541_.f_91080_;
            }
        } else {
            super.m_6597_(slot, slotId, clickedButton, clickType);
        }
    }
}

