/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.model;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.AbstractCamouflageBlock;
import me.desht.pneumaticcraft.common.block.entity.CamouflageableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class CamoModel
implements IDynamicBakedModel {
    private final BakedModel originalModel;

    public CamoModel(BakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, RenderType renderType) {
        if (state == null || !(state.m_60734_() instanceof AbstractCamouflageBlock)) {
            return this.originalModel.getQuads(state, side, rand, modelData, renderType);
        }
        BlockState camoState = (BlockState)modelData.get(AbstractCamouflageBlock.CAMO_STATE);
        if (renderType == null) {
            renderType = RenderType.m_110451_();
        }
        if (camoState == null && renderType == RenderType.m_110451_()) {
            return this.originalModel.getQuads(state, side, rand, modelData, renderType);
        }
        if (camoState != null && this.getRenderTypes(camoState, rand, modelData).contains(renderType)) {
            BakedModel model = Minecraft.m_91087_().m_91289_().m_110907_().m_110893_(camoState);
            return model.getQuads(camoState, side, rand, modelData, renderType);
        }
        return Collections.emptyList();
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState camoState = (BlockState)data.get(AbstractCamouflageBlock.CAMO_STATE);
        return super.getRenderTypes(camoState == null ? state : camoState, rand, data);
    }

    public boolean m_7541_() {
        return this.originalModel.m_7541_();
    }

    public boolean m_7539_() {
        return this.originalModel.m_7539_();
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return this.originalModel.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.originalModel.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.originalModel.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.originalModel.m_7343_();
    }

    private static class FakeBlockAccess
    implements BlockGetter {
        private final BlockGetter compose;

        private FakeBlockAccess(BlockGetter compose) {
            this.compose = compose;
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return this.compose.m_7702_(pos);
        }

        @Nonnull
        public BlockState m_8055_(@Nonnull BlockPos pos) {
            BlockEntity te;
            BlockState state = this.compose.m_8055_(pos);
            if (state.m_60734_() instanceof AbstractCamouflageBlock && (te = this.compose.m_7702_(pos)) instanceof CamouflageableBlockEntity) {
                state = ((CamouflageableBlockEntity)te).getCamouflage();
            }
            return state == null ? Blocks.f_50016_.m_49966_() : state;
        }

        @Nonnull
        public FluidState m_6425_(@Nonnull BlockPos blockPos) {
            return this.compose.m_6425_(blockPos);
        }

        public int m_141928_() {
            return this.compose.m_141928_();
        }

        public int m_141937_() {
            return this.compose.m_141937_();
        }
    }
}

