/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.StatPanelLayout;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.client.pneumatic_armor.upgrade_handler.CoreComponentsClientHandler;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;

public class ArmorMessage {
    private final IGuiAnimatedStat stat;
    private int lifeSpan;

    public ArmorMessage(Component title, int duration, int backColor) {
        this(title, Collections.emptyList(), duration, backColor);
    }

    public ArmorMessage(Component title, List<Component> message, int duration, int backColor) {
        this.lifeSpan = duration;
        StatPanelLayout layout = ArmorHUDLayout.INSTANCE.getLayoutFor(CoreComponentsHandler.getMessageID(), CoreComponentsClientHandler.getDefaultMessageLayout());
        this.stat = new WidgetAnimatedStat(null, title, WidgetAnimatedStat.StatIcon.NONE, backColor, null, layout);
        this.stat.setMinimumContractedDimensions(0, 0);
        this.stat.setText(message);
        Player player = ClientUtils.getClientPlayer();
        player.f_19853_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.SCI_FI.get(), SoundSource.PLAYERS, 0.1f, 1.0f, true);
    }

    void setDependingMessage(IGuiAnimatedStat dependingStat) {
        this.stat.setParentStat(dependingStat);
        this.stat.setBaseY(2);
    }

    public IGuiAnimatedStat getStat() {
        return this.stat;
    }

    void renderMessage(PoseStack matrixStack, float partialTicks) {
        if (this.lifeSpan > 10) {
            this.stat.openStat();
        } else {
            this.stat.closeStat();
        }
        this.stat.renderStat(matrixStack, -1, -1, partialTicks);
    }

    public void tick() {
        this.stat.tickWidget();
        --this.lifeSpan;
    }

    public boolean isExpired() {
        return this.lifeSpan <= 0;
    }
}

