/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.Optional;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.block.PneumaticCraftEntityBlock;
import me.desht.pneumaticcraft.common.block.entity.ElevatorBaseBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.ElevatorFrameBlockEntity;
import me.desht.pneumaticcraft.common.core.ModBlockEntities;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModUpgrades;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ElevatorFrameBlock
extends AbstractPneumaticCraftBlock
implements SimpleWaterloggedBlock,
PneumaticCraftEntityBlock {
    private static final VoxelShape[] SHAPE_CACHE = new VoxelShape[16];
    private static final VoxelShape MOSTLY_FULL = Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)15.5);
    private static final BooleanProperty NE = BooleanProperty.m_61465_((String)"ne");
    private static final BooleanProperty SE = BooleanProperty.m_61465_((String)"se");
    private static final BooleanProperty SW = BooleanProperty.m_61465_((String)"sw");
    private static final BooleanProperty NW = BooleanProperty.m_61465_((String)"nw");

    public ElevatorFrameBlock() {
        super(ModBlocks.defaultProps());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)NE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        super.m_6807_(pState, pLevel, pPos, pOldState, pIsMoving);
        ElevatorFrameBlock.getElevatorBase((BlockGetter)pLevel, pPos).ifPresent(ElevatorBaseBlockEntity::updateMaxElevatorHeight);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{NE, SW, SE, NW});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state != null) {
            boolean[] connected = this.getConnections((BlockGetter)ctx.m_43725_(), ctx.m_8083_());
            ((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NE, (Comparable)Boolean.valueOf(connected[0]))).m_61124_((Property)SE, (Comparable)Boolean.valueOf(connected[1]))).m_61124_((Property)SW, (Comparable)Boolean.valueOf(connected[2]))).m_61124_((Property)NW, (Comparable)Boolean.valueOf(connected[3]));
        }
        return state;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!this.m_7898_(stateIn, (LevelReader)worldIn, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        boolean[] connected = this.getConnections((BlockGetter)worldIn, currentPos);
        for (Corner corner : Corner.values()) {
            stateIn = (BlockState)stateIn.m_61124_((Property)corner.prop, (Comparable)Boolean.valueOf(connected[corner.ordinal()]));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return selectionContext.m_7142_(this.m_5456_()) ? MOSTLY_FULL : this.getCachedShape(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        double blockHeight = this.getElevatorBlockHeight(worldIn, pos);
        if (blockHeight > 1.0) {
            return Shapes.m_83144_();
        }
        if (blockHeight > 0.0) {
            double minY = Math.max(0.0, blockHeight - 0.06125) * 16.0;
            double maxY = blockHeight * 16.0;
            return Shapes.m_83110_((VoxelShape)this.getCachedShape(state), (VoxelShape)Block.m_49796_((double)0.001, (double)minY, (double)0.001, (double)15.999, (double)maxY, (double)15.999));
        }
        return this.getCachedShape(state);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return this.getCachedShape(state).m_83281_() ? RenderShape.INVISIBLE : super.m_7514_(state);
    }

    private VoxelShape getCachedShape(BlockState state) {
        int shapeIdx = ((Boolean)state.m_61143_((Property)NE) != false ? 1 : 0) | ((Boolean)state.m_61143_((Property)SE) != false ? 2 : 0) | ((Boolean)state.m_61143_((Property)SW) != false ? 4 : 0) | ((Boolean)state.m_61143_((Property)NW) != false ? 8 : 0);
        if (SHAPE_CACHE[shapeIdx] == null) {
            VoxelShape shape = Shapes.m_83040_();
            for (Corner corner : Corner.values()) {
                if (((Boolean)state.m_61143_((Property)corner.prop)).booleanValue()) continue;
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)corner.shape);
            }
            ElevatorFrameBlock.SHAPE_CACHE[shapeIdx] = shape;
        }
        return SHAPE_CACHE[shapeIdx];
    }

    private boolean[] getConnections(BlockGetter world, BlockPos pos) {
        boolean[] res = new boolean[4];
        boolean frameXPos = world.m_8055_(pos.m_122029_()).m_60734_() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameXNeg = world.m_8055_(pos.m_122024_()).m_60734_() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameZPos = world.m_8055_(pos.m_122019_()).m_60734_() == ModBlocks.ELEVATOR_FRAME.get();
        boolean frameZNeg = world.m_8055_(pos.m_122012_()).m_60734_() == ModBlocks.ELEVATOR_FRAME.get();
        res[Corner.SE.ordinal()] = frameXPos || frameZPos;
        res[Corner.NE.ordinal()] = frameXPos || frameZNeg;
        res[Corner.SW.ordinal()] = frameXNeg || frameZPos;
        res[Corner.NW.ordinal()] = frameXNeg || frameZNeg;
        return res;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        ElevatorFrameBlock.getElevatorBase((BlockGetter)world, pos).ifPresent(teBase -> {
            if (!teBase.isStopped()) {
                int baseY = teBase.m_58899_().m_123342_();
                if (entity.m_20186_() >= (double)baseY && entity.m_20186_() < (double)baseY + teBase.extension + 10.0) {
                    double eX = entity.m_20185_();
                    double eZ = entity.m_20189_();
                    if (teBase.ticksRunning < 10) {
                        int x = pos.m_123341_();
                        int z = pos.m_123343_();
                        AABB box = entity.m_20191_();
                        if (box.f_82288_ < (double)x && !(teBase.getCachedNeighbor(Direction.WEST) instanceof ElevatorBaseBlockEntity) || box.f_82291_ > (double)(x + 1) && !(teBase.getCachedNeighbor(Direction.EAST) instanceof ElevatorBaseBlockEntity)) {
                            eX = (double)x + 0.5;
                        }
                        if (box.f_82290_ < (double)z && !(teBase.getCachedNeighbor(Direction.NORTH) instanceof ElevatorBaseBlockEntity) || box.f_82293_ > (double)(z + 1) && !(teBase.getCachedNeighbor(Direction.SOUTH) instanceof ElevatorBaseBlockEntity)) {
                            eZ = (double)z + 0.5;
                        }
                    }
                    entity.m_6034_(eX, (double)baseY + teBase.extension + 1.2, eZ);
                    if (entity instanceof ServerPlayer && teBase.getUpgrades((PNCUpgrade)ModUpgrades.SPEED.get()) >= 6) {
                        ((ServerPlayer)entity).f_8906_.m_9953_();
                    }
                    entity.f_19789_ = 0.0f;
                }
            }
        });
    }

    static Optional<ElevatorBaseBlockEntity> getElevatorBase(BlockGetter world, BlockPos pos) {
        return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.ELEVATOR_FRAME.get()).map(ElevatorFrameBlockEntity::getElevatorBase);
    }

    private double getElevatorBlockHeight(BlockGetter world, BlockPos pos) {
        return ElevatorFrameBlock.getElevatorBase(world, pos).map(te -> Math.max(te.extension - (double)(pos.m_123342_() - te.m_58899_().m_123342_()) + 1.0, 0.0)).orElse(0.0);
    }

    @Override
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        ElevatorFrameBlock.getElevatorBase((BlockGetter)world, pos).ifPresent(ElevatorBaseBlockEntity::updateMaxElevatorHeight);
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockState below = worldIn.m_8055_(pos.m_7495_());
        return below.m_60734_() == this || below.m_60734_() == ModBlocks.ELEVATOR_BASE.get();
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return this.getElevatorBlockHeight(worldIn, pos) == 0.0;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult brtr) {
        if (!player.m_6047_() && player.m_21120_(hand).m_41720_() == this.m_5456_()) {
            if (!world.f_46443_) {
                BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                int worldHeight = world.m_6042_().f_63865_();
                while (mPos.m_123342_() < worldHeight && world.m_8055_((BlockPos)mPos).m_60734_() == this) {
                    mPos.m_122173_(Direction.UP);
                }
                if (mPos.m_123342_() < worldHeight && world.m_8055_((BlockPos)mPos).m_60795_()) {
                    world.m_46597_((BlockPos)mPos, this.m_49966_());
                    float pitch = Math.min(1.5f, (float)(mPos.m_123342_() - pos.m_123342_()) * 0.05f + 1.0f);
                    world.m_5594_(null, (BlockPos)mPos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, pitch);
                    if (!player.m_7500_()) {
                        player.m_21120_(hand).m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.FAIL;
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, brtr);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ElevatorFrameBlockEntity(pPos, pState);
    }

    private static enum Corner {
        NE(1, -1, NE, Block.m_49796_((double)14.5, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)1.5)),
        SE(1, 1, SE, Block.m_49796_((double)14.5, (double)0.0, (double)14.5, (double)15.5, (double)16.0, (double)15.5)),
        SW(-1, 1, SW, Block.m_49796_((double)0.5, (double)0.0, (double)14.5, (double)1.5, (double)16.0, (double)15.5)),
        NW(-1, -1, NW, Block.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)1.5, (double)16.0, (double)1.5));

        final int x;
        final int z;
        final BooleanProperty prop;
        final VoxelShape shape;

        private Corner(int x, int z, BooleanProperty prop, VoxelShape shape) {
            this.x = x;
            this.z = z;
            this.prop = prop;
            this.shape = shape;
        }
    }
}

