/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.ColorHandlers;
import me.desht.pneumaticcraft.client.util.TintColor;
import me.desht.pneumaticcraft.common.block.AbstractPneumaticCraftBlock;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ICustomTooltipName;
import me.desht.pneumaticcraft.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallLampBlock
extends AbstractPneumaticCraftBlock
implements ColorHandlers.ITintableBlock,
SimpleWaterloggedBlock {
    private static final VoxelShape SHAPE_UP = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), Block.m_49796_((double)6.15, (double)2.25, (double)4.75, (double)6.65, (double)3.5, (double)11.25), Block.m_49796_((double)5.0, (double)2.25, (double)5.0, (double)11.0, (double)3.25, (double)11.0), Block.m_49796_((double)4.75, (double)1.25, (double)4.75, (double)11.25, (double)2.5, (double)11.25), Block.m_49796_((double)9.35, (double)2.25, (double)4.75, (double)9.85, (double)3.5, (double)11.25), Block.m_49796_((double)4.75, (double)2.25, (double)9.35, (double)11.25, (double)3.5, (double)9.85), Block.m_49796_((double)4.75, (double)2.25, (double)6.15, (double)11.25, (double)3.5, (double)6.65)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape SHAPE_NORTH = VoxelShapeUtils.rotateX(SHAPE_UP, 270);
    private static final VoxelShape SHAPE_DOWN = VoxelShapeUtils.rotateX(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_SOUTH = VoxelShapeUtils.rotateX(SHAPE_UP, 90);
    private static final VoxelShape SHAPE_WEST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 270);
    private static final VoxelShape SHAPE_EAST = VoxelShapeUtils.rotateY(SHAPE_NORTH, 90);
    private static final VoxelShape[] SHAPES = new VoxelShape[]{SHAPE_DOWN, SHAPE_UP, SHAPE_NORTH, SHAPE_SOUTH, SHAPE_WEST, SHAPE_EAST};
    private static final int[] COLORS_ON = new int[DyeColor.values().length];
    private static final int[] COLORS_OFF = new int[DyeColor.values().length];
    private final DyeColor color;
    private final boolean inverted;

    public WallLampBlock(DyeColor color, boolean inverted) {
        super(ModBlocks.defaultProps().m_60953_(WallLampBlock.getLightValue()));
        this.color = color;
        this.inverted = inverted;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(inverted)));
    }

    @Override
    protected boolean isWaterloggable() {
        return true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61443_});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)this.directionProperty())).m_122411_()];
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue() && !this.shouldLight((Level)worldIn, pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61443_), 2);
        }
    }

    @Override
    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean isLit;
        if (!worldIn.f_46443_ && (isLit = ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) != this.shouldLight(worldIn, pos)) {
            if (isLit) {
                worldIn.m_186460_(pos, (Block)this, 4);
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)BlockStateProperties.f_61443_), 2);
            }
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        return (BlockState)((BlockState)state.m_61124_((Property)this.directionProperty(), (Comparable)context.m_43719_())).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(this.shouldLight(context.m_43725_(), context.m_8083_())));
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getRotation(stateIn).m_122424_() == facing && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return FaceAttachedHorizontalDirectionalBlock.m_53196_((LevelReader)worldIn, (BlockPos)pos, (Direction)this.getRotation(state).m_122424_());
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    protected boolean canRotateToTopOrBottom() {
        return true;
    }

    @Override
    public int getTintColor(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintIndex) {
        if (tintIndex == 1 && state != null) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? COLORS_ON[this.color.m_41060_()] : COLORS_OFF[this.color.m_41060_()];
        }
        return -1;
    }

    private boolean shouldLight(Level world, BlockPos pos) {
        return this.inverted != world.m_46753_(pos);
    }

    private static ToIntFunction<BlockState> getLightValue() {
        return state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0;
    }

    static {
        for (DyeColor c : DyeColor.values()) {
            float[] cols = c.m_41068_();
            TintColor tc = new TintColor(cols[0], cols[1], cols[2], 1.0f);
            WallLampBlock.COLORS_ON[c.m_41060_()] = tc.getRGB();
            WallLampBlock.COLORS_OFF[c.m_41060_()] = tc.darker().getRGB();
        }
    }

    public static class ItemWallLamp
    extends BlockItem
    implements ICustomTooltipName {
        public ItemWallLamp(WallLampBlock blockWallLamp) {
            super((Block)blockWallLamp, ModItems.defaultProps());
        }

        @Override
        public String getCustomTooltipTranslationKey() {
            Block block = this.m_40614_();
            if (block instanceof WallLampBlock) {
                WallLampBlock bwl = (WallLampBlock)block;
                return bwl.inverted ? "block.pneumaticcraft.wall_lamp_inverted" : "block.pneumaticcraft.wall_lamp";
            }
            return "block.pneumaticcraft.wall_lamp";
        }
    }
}

