/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.capabilities;

import java.util.EnumMap;
import java.util.Map;
import me.desht.pneumaticcraft.common.capabilities.CapabilityCache;
import me.desht.pneumaticcraft.common.util.CapabilityUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;

public class NeighbouringCapabilityCache<T> {
    private final Map<Direction, CapabilityCache<T>> neighbouringCapabilityCaches = new EnumMap<Direction, CapabilityCache<T>>(Direction.class);

    @NotNull
    public LazyOptional<T> get(@NotNull Direction direction) {
        CapabilityCache<T> cache = this.neighbouringCapabilityCaches.get(direction);
        if (cache == null) {
            return LazyOptional.empty();
        }
        return cache.get();
    }

    @NotNull
    public LazyOptional<T> set(@NotNull Capability<T> capability, @NotNull BlockEntity blockEntity, @NotNull Direction direction) {
        CapabilityCache<T> cache = this.neighbouringCapabilityCaches.get(direction);
        if (cache == null) {
            cache = new CapabilityCache();
            this.neighbouringCapabilityCaches.put(direction, cache);
        }
        return cache.set(CapabilityUtils.getNeighbourCap(capability, blockEntity, direction));
    }

    public void clear() {
        for (Direction dir : Direction.values()) {
            this.clear(dir);
        }
    }

    public void clear(@NotNull Direction dir) {
        CapabilityCache<T> cache = this.neighbouringCapabilityCaches.get(dir);
        if (cache == null) {
            return;
        }
        cache.clear();
    }
}

