/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.core;

import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.harvesting.HarvestHandler;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCactusLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCropLike;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerCrops;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerLeaves;
import me.desht.pneumaticcraft.common.harvesting.HarvestHandlerTree;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryObject;

public class ModHarvestHandlers {
    public static final DeferredRegister<HarvestHandler> HARVEST_HANDLERS_DEFERRED = DeferredRegister.create((ResourceLocation)PneumaticRegistry.RL("harvest_handlers"), (String)"pneumaticcraft");
    public static final Supplier<IForgeRegistry<HarvestHandler>> HARVEST_HANDLERS = HARVEST_HANDLERS_DEFERRED.makeRegistry(() -> new RegistryBuilder().disableSaving().disableSync());
    public static final RegistryObject<HarvestHandler> CROPS = ModHarvestHandlers.register("crops", HarvestHandlerCrops::new);
    public static final RegistryObject<HarvestHandler> NETHER_WART = ModHarvestHandlers.register("nether_wart", HarvestHandlerCropLike.NetherWart::new);
    public static final RegistryObject<HarvestHandler> SWEET_BERRIES = ModHarvestHandlers.register("sweet_berries", HarvestHandlerCropLike.SweetBerry::new);
    public static final RegistryObject<HarvestHandler> COCOA = ModHarvestHandlers.register("cocoa_beans", HarvestHandlerCropLike.Cocoa::new);
    public static final RegistryObject<HarvestHandler> CACTUS = ModHarvestHandlers.register("cactus_like", HarvestHandlerCactusLike.VanillaCrops::new);
    public static final RegistryObject<HarvestHandler> PUMPKIN = ModHarvestHandlers.register("pumpkin_like", () -> new HarvestHandler.SimpleHarvestHandler(Blocks.f_50133_, Blocks.f_50186_));
    public static final RegistryObject<HarvestHandler> LEAVES = ModHarvestHandlers.register("leaves", HarvestHandlerLeaves::new);
    public static final RegistryObject<HarvestHandler> TREES = ModHarvestHandlers.register("trees", HarvestHandlerTree::new);

    public static <T extends HarvestHandler> RegistryObject<T> register(String name, Supplier<T> sup) {
        return HARVEST_HANDLERS_DEFERRED.register(name, sup);
    }

    public static enum TreePart {
        LOG("_log"),
        LEAVES("_leaves"),
        SAPLING("_sapling");

        private final String suffix;
        private final Pattern pattern;

        private TreePart(String suffix) {
            this.suffix = suffix;
            this.pattern = Pattern.compile(suffix + "$");
        }

        public Block convert(Block in, TreePart to) {
            return PneumaticCraftUtils.getRegistryName(in).map(rlIn -> {
                ResourceLocation rlOut = new ResourceLocation(rlIn.m_135827_(), this.pattern.matcher(rlIn.m_135815_()).replaceAll(to.suffix));
                return (Block)ForgeRegistries.BLOCKS.getValue(rlOut);
            }).orElse(Blocks.f_50016_);
        }
    }
}

