/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.drone.ai;

import me.desht.pneumaticcraft.common.drone.IDroneBase;
import me.desht.pneumaticcraft.common.drone.ai.DroneAIImExBase;
import me.desht.pneumaticcraft.common.drone.progwidgets.ProgWidgetInventoryBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class DroneAIEnergyImport
extends DroneAIImExBase<ProgWidgetInventoryBase> {
    public DroneAIEnergyImport(IDroneBase drone, ProgWidgetInventoryBase widget) {
        super(drone, widget);
    }

    @Override
    protected boolean doBlockInteraction(BlockPos pos, double squareDistToBlock) {
        return this.importEnergy(pos, false) && super.doBlockInteraction(pos, squareDistToBlock);
    }

    @Override
    protected boolean isValidPosition(BlockPos pos) {
        return this.importEnergy(pos, true);
    }

    private boolean importEnergy(BlockPos pos, boolean simulate) {
        boolean didWork = false;
        if (this.droneIsFull()) {
            this.abort();
        } else {
            Direction face;
            BlockEntity te = this.drone.world().m_7702_(pos);
            if (te == null) {
                return false;
            }
            Direction[] directionArray = DirectionUtil.VALUES;
            int n = directionArray.length;
            for (int i = 0; !(i >= n || ((ProgWidgetInventoryBase)this.progWidget).isSideSelected(face = directionArray[i]) && (didWork = this.tryImportFromSide(te, face, simulate))); ++i) {
            }
        }
        return didWork;
    }

    private boolean tryImportFromSide(BlockEntity te, Direction face, boolean simulate) {
        return te.getCapability(ForgeCapabilities.ENERGY, face).map(tileHandler -> {
            int toExtract = tileHandler.extractEnergy(this.useCount() ? this.getRemainingCount() : Integer.MAX_VALUE, true);
            int toTransfer = this.insertToDrone(toExtract, true);
            if (toTransfer > 0) {
                if (!simulate) {
                    this.decreaseCount(toTransfer);
                    tileHandler.extractEnergy(toTransfer, false);
                    this.insertToDrone(toTransfer, false);
                }
                return true;
            }
            return false;
        }).orElse(false);
    }

    private int insertToDrone(int maxTransfer, boolean simulate) {
        return (Integer)this.drone.getCapability(ForgeCapabilities.ENERGY).map(h -> h.receiveEnergy(maxTransfer, simulate)).orElseThrow(RuntimeException::new);
    }

    private boolean droneIsFull() {
        return (Boolean)this.drone.getCapability(ForgeCapabilities.ENERGY).map(h -> h.getEnergyStored() == h.getMaxEnergyStored()).orElseThrow(RuntimeException::new);
    }
}

