/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.TropicraftSpecialRenderHelper;
import net.tropicraft.core.client.entity.model.TropicraftFishModel;
import net.tropicraft.core.common.entity.underdasea.IAtlasFish;

public class TropicraftFishRenderer<T extends AbstractFish>
extends MobRenderer<T, TropicraftFishModel<T>> {
    private static final ResourceLocation TEXTURE = TropicraftRenderUtils.getTextureEntity("tropical_fish");
    private final TropicraftSpecialRenderHelper renderHelper = new TropicraftSpecialRenderHelper();

    public TropicraftFishRenderer(EntityRendererProvider.Context context, TropicraftFishModel<T> modelbase, float f) {
        super(context, modelbase, f);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        boolean shouldRender;
        boolean isVisible = this.m_5933_((LivingEntity)entity);
        boolean bl = shouldRender = !isVisible && !entity.m_20177_((Player)Minecraft.m_91087_().f_91074_);
        if (isVisible || shouldRender) {
            boolean glowing = Minecraft.m_91087_().m_91314_(entity);
            this.renderFishy(entity, partialTicks, matrixStackIn, bufferIn.m_6299_(this.m_7225_((LivingEntity)entity, isVisible, shouldRender, glowing)), packedLightIn, TropicraftFishRenderer.m_115338_(entity, (float)this.m_6931_((LivingEntity)entity, partialTicks)));
        }
        super.m_7392_(entity, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void renderFishy(T entity, float partialTicks, PoseStack stack, VertexConsumer buffer, int light, int overlay) {
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-90.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(-Mth.m_14179_((float)partialTicks, (float)((AbstractFish)entity).f_20886_, (float)((AbstractFish)entity).f_20885_)));
        stack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
        stack.m_85841_(0.3f, 0.3f, 0.5f);
        stack.m_85837_((double)0.85f, (double)-0.3f, 0.0);
        int fishTex = 0;
        if (entity instanceof IAtlasFish) {
            fishTex = ((IAtlasFish)entity).getAtlasSlot() * 2;
        }
        this.renderHelper.renderFish(stack, buffer, fishTex, light, overlay);
        stack.m_85837_((double)-1.7f, 0.0, 0.0);
        stack.m_85837_((double)0.85f, 0.0, (double)0.025f);
        stack.m_85845_(Vector3f.f_122225_.m_122270_(((TropicraftFishModel)this.f_115290_).tail.f_104204_));
        stack.m_85837_((double)-0.85f, 0.0, (double)-0.025f);
        this.renderHelper.renderFish(stack, buffer, fishTex + 1, light, overlay);
        stack.m_85849_();
    }

    protected void scale(T entity, PoseStack stack, float partialTickTime) {
        stack.m_85841_(0.75f, 0.2f, 0.2f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

