/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.block.tileentity.BambooChestBlockEntity;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="tropicraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class BambooChestRenderer
extends ChestRenderer<BambooChestBlockEntity> {
    public static final Material BAMBOO_CHEST_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_chest/normal");
    public static final Material BAMBOO_CHEST_LEFT_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_chest/normal_left");
    public static final Material BAMBOO_CHEST_RIGHT_MATERIAL = BambooChestRenderer.getChestMaterial("bamboo_chest/normal_right");

    @SubscribeEvent
    public static void onTextureStitchPre(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)Sheets.f_110740_)) {
            event.addSprite(BAMBOO_CHEST_MATERIAL.m_119203_());
            event.addSprite(BAMBOO_CHEST_LEFT_MATERIAL.m_119203_());
            event.addSprite(BAMBOO_CHEST_RIGHT_MATERIAL.m_119203_());
        }
    }

    private static Material getChestMaterial(ChestType chestType, Material normalMaterial, Material leftMaterial, Material rightMaterial) {
        return switch (chestType) {
            case ChestType.LEFT -> leftMaterial;
            case ChestType.RIGHT -> rightMaterial;
            default -> normalMaterial;
        };
    }

    private static Material getChestMaterial(String chestName) {
        return new Material(Sheets.f_110740_, new ResourceLocation("tropicraft", "block/te/" + chestName));
    }

    public BambooChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected Material getMaterial(BambooChestBlockEntity tileEntity, ChestType chestType) {
        return BambooChestRenderer.getChestMaterial(chestType, BAMBOO_CHEST_MATERIAL, BAMBOO_CHEST_LEFT_MATERIAL, BAMBOO_CHEST_RIGHT_MATERIAL);
    }
}

