/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.client.tileentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.BambooMugModel;
import net.tropicraft.core.client.entity.model.EIHMachineModel;
import net.tropicraft.core.client.tileentity.MachineRenderer;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.block.tileentity.DrinkMixerBlockEntity;
import net.tropicraft.core.common.item.CocktailItem;

public class DrinkMixerRenderer
extends MachineRenderer<DrinkMixerBlockEntity> {
    private static final ResourceLocation TEXTURE = TropicraftRenderUtils.getTextureTE("bamboo_mug");
    private final BambooMugModel emptyMugModel;
    private final BambooMugModel filledMugModel;
    private final ItemRenderer renderItem;
    private ItemEntity dummyEntityItem;
    private static final float[][] INGREDIENT_OFFSETS = new float[][]{{0.3f, -0.5f, 0.05f}, {-0.3f, -0.5f, 0.05f}, {0.0f, 0.3f, -0.1f}};
    private static final float[][] INGREDIENT_SCALES = new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.8f, 0.8f, 0.8f}};

    public DrinkMixerRenderer(BlockEntityRendererProvider.Context context) {
        super(context, (Block)TropicraftBlocks.DRINK_MIXER.get(), new EIHMachineModel(context.m_173585_().m_171103_(TropicraftRenderLayers.EIHMACHINE_LAYER)));
        this.renderItem = context.m_234447_();
        ModelPart mugLayer = context.m_173585_().m_171103_(TropicraftRenderLayers.BAMBOO_MUG);
        this.emptyMugModel = new BambooMugModel(mugLayer, RenderType::m_110452_, false);
        this.filledMugModel = new BambooMugModel(mugLayer, RenderType::m_110452_, true);
    }

    @Override
    protected Material getMaterial() {
        return TropicraftRenderUtils.getTEMaterial("drink_mixer");
    }

    @Override
    public void renderIngredients(DrinkMixerBlockEntity te, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (this.dummyEntityItem == null) {
            this.dummyEntityItem = new ItemEntity((Level)Minecraft.m_91087_().f_91073_, 0.0, 0.0, 0.0, new ItemStack((ItemLike)Items.f_42501_));
        }
        NonNullList<ItemStack> ingredients = te.getIngredients();
        if (!te.isDoneMixing()) {
            for (int index = 0; index < ingredients.size(); ++index) {
                ItemStack ingredient = (ItemStack)ingredients.get(index);
                if (ingredient.m_41619_()) continue;
                this.renderIngredient(stack, buffer, combinedOverlayIn, combinedLightIn, ingredient, index);
            }
        }
        if (te.isMixing() || !te.result.m_41619_()) {
            stack.m_85836_();
            stack.m_85837_((double)-0.2f, -0.25, 0.0);
            if (te.isDoneMixing()) {
                int liquidColor = CocktailItem.getCocktailColor(te.result);
                float red = (float)FastColor.ARGB32.m_13665_((int)liquidColor) / 255.0f;
                float green = (float)FastColor.ARGB32.m_13667_((int)liquidColor) / 255.0f;
                float blue = (float)FastColor.ARGB32.m_13669_((int)liquidColor) / 255.0f;
                VertexConsumer consumer = buffer.m_6299_(this.filledMugModel.m_103119_(TEXTURE));
                this.filledMugModel.m_7695_(stack, consumer, combinedLightIn, combinedOverlayIn, red, green, blue, 1.0f);
            } else {
                VertexConsumer consumer = buffer.m_6299_(this.emptyMugModel.m_103119_(TEXTURE));
                this.emptyMugModel.m_7695_(stack, consumer, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            stack.m_85849_();
        }
    }

    private void renderIngredient(PoseStack stack, MultiBufferSource buffer, int combinedOverlayIn, int combinedLight, ItemStack ingredient, int ingredientIndex) {
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
        stack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
        stack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
        float[] offsets = INGREDIENT_OFFSETS[ingredientIndex];
        float[] scales = INGREDIENT_SCALES[ingredientIndex];
        stack.m_85837_((double)offsets[0], (double)offsets[1], (double)offsets[2]);
        stack.m_85841_(scales[0], scales[1], scales[2]);
        this.dummyEntityItem.m_32045_(ingredient);
        BakedModel bakedModel = TropicraftRenderUtils.getBakedModel(this.renderItem, ingredient);
        this.renderItem.m_115143_(ingredient, ItemTransforms.TransformType.FIXED, false, stack, buffer, combinedLight, combinedOverlayIn, bakedModel);
        stack.m_85849_();
    }
}

