/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallSeagrassBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BlockTropicraftSand
extends FallingBlock {
    public static final BooleanProperty UNDERWATER = BooleanProperty.m_61465_((String)"underwater");
    private final int dustColor;

    public BlockTropicraftSand(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)UNDERWATER, (Comparable)Boolean.valueOf(false)));
        this.dustColor = this.m_60590_().f_76396_ | 0xFF000000;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UNDERWATER});
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.m_121945_(facing));
        PlantType type = plantable.getPlantType(world, pos.m_121945_(facing));
        if (plant.m_60734_() instanceof SeagrassBlock || plant.m_60734_() instanceof TallSeagrassBlock) {
            return true;
        }
        if (PlantType.BEACH.equals(type)) {
            boolean hasWater = false;
            for (Direction face : Direction.Plane.HORIZONTAL) {
                BlockState blockState = world.m_8055_(pos.m_121945_(face));
                FluidState fluidState = world.m_6425_(pos.m_121945_(face));
                hasWater |= blockState.m_60713_(Blocks.f_50449_);
                if (!(hasWater |= fluidState.m_205070_(FluidTags.f_13131_))) continue;
                break;
            }
            return hasWater;
        }
        return PlantType.DESERT.equals(type);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState upState = context.m_43725_().m_6425_(context.m_8083_().m_7494_());
        boolean waterAbove = false;
        if (!upState.m_76178_()) {
            waterAbove = true;
        }
        return (BlockState)this.m_49966_().m_61124_((Property)UNDERWATER, (Comparable)Boolean.valueOf(waterAbove));
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos2, boolean isMoving) {
        FluidState upState = world.m_6425_(pos.m_7494_());
        boolean underwater = upState.m_76152_().m_6212_((Fluid)Fluids.f_76193_);
        if (underwater != (Boolean)state.m_61143_((Property)UNDERWATER)) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)UNDERWATER, (Comparable)Boolean.valueOf(underwater)), 2);
        }
        super.m_6861_(state, world, pos, block, pos2, isMoving);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int m_6248_(BlockState state, BlockGetter reader, BlockPos pos) {
        return this.dustColor;
    }
}

