/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.tropicraft.core.common.sound.Sounds;

@Mod.EventBusSubscriber
public class BongoDrumBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final Size size;

    public BongoDrumBlock(Size size, BlockBehaviour.Properties properties) {
        super(properties);
        this.size = size;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    public Size getSize() {
        return this.size;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.size.shape;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.m_5940_(state, worldIn, pos, context);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (result.m_82434_() != Direction.UP) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        this.playBongoSound(world, pos, state, this.getAdjustedPitch((HitResult)result));
        return InteractionResult.CONSUME;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean flag = worldIn.m_46753_(pos);
        if (flag != (Boolean)state.m_61143_((Property)POWERED)) {
            if (flag) {
                this.playBongoSound(worldIn, pos, state);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    @SubscribeEvent
    public static void onBlockLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        Level level = event.getLevel();
        BlockState state = level.m_8055_(event.getPos());
        Block block = state.m_60734_();
        if (state.m_60734_() instanceof BongoDrumBlock && event.getFace() == Direction.UP) {
            ((BongoDrumBlock)block).playBongoSound(level, event.getPos(), state);
        }
    }

    public void playBongoSound(Level world, BlockPos pos, BlockState state) {
        this.playBongoSound(world, pos, state, 1.0f);
    }

    public void playBongoSound(Level world, BlockPos pos, BlockState state, float pitch) {
        world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, this.size.soundEvent.get(), SoundSource.BLOCKS, 1.0f, pitch);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    private float getAdjustedPitch(HitResult hitVec) {
        if (hitVec == null || hitVec.m_82450_() == null) {
            return 1.0f;
        }
        double distX = Math.abs(hitVec.m_82450_().f_82479_ - Math.floor(hitVec.m_82450_().f_82479_) - 0.5);
        double distZ = Math.abs(hitVec.m_82450_().f_82481_ - Math.floor(hitVec.m_82450_().f_82481_) - 0.5);
        double dist = (float)Math.sqrt(distX * distX + distZ * distZ);
        double radiusMax = 1.0;
        if (this.size == Size.SMALL) {
            radiusMax = 0.25;
        } else if (this.size == Size.MEDIUM) {
            radiusMax = 0.3125;
        } else if (this.size == Size.LARGE) {
            radiusMax = 0.375;
        }
        double adjPitch = dist / radiusMax;
        return 1.0f + (float)adjPitch;
    }

    public static enum Size {
        SMALL(8, (Supplier<SoundEvent>)Sounds.BONGO_HIGH, 1),
        MEDIUM(10, (Supplier<SoundEvent>)Sounds.BONGO_MED, 2),
        LARGE(12, (Supplier<SoundEvent>)Sounds.BONGO_LOW, 3);

        public final VoxelShape shape;
        final Supplier<SoundEvent> soundEvent;
        public final int recipeColumns;

        private Size(int size, Supplier<SoundEvent> soundEvent, int recipeColumns) {
            this.recipeColumns = recipeColumns;
            double offset = (16 - size) / 2;
            this.shape = Block.m_49796_((double)offset, (double)0.0, (double)offset, (double)(16.0 - offset), (double)16.0, (double)(16.0 - offset));
            this.soundEvent = soundEvent;
        }
    }
}

