/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.tropicraft.core.common.block.PropaguleBlock;

public class MangroveLeavesBlock
extends LeavesBlock {
    private static final int PROPAGULE_GROW_CHANCE = 200;
    private static final int SPACING = 2;
    private final Supplier<PropaguleBlock> propaguleBlock;

    public MangroveLeavesBlock(BlockBehaviour.Properties props, Supplier<PropaguleBlock> propaguleBlock) {
        super(props);
        this.propaguleBlock = propaguleBlock;
    }

    public boolean m_6724_(BlockState state) {
        return this.canGrowPropagules(state) || super.m_6724_(state);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213898_(state, world, pos, random);
        if (this.canGrowPropagules(state) && random.m_188503_(200) == 0) {
            this.tryGrowPropagule(world, pos);
        }
    }

    private void tryGrowPropagule(ServerLevel world, BlockPos pos) {
        BlockPos growPos = pos.m_7495_();
        if (world.m_46859_(growPos) && world.m_46859_(growPos.m_7495_()) && !this.hasNearPropagule(world, pos)) {
            BlockState propagule = (BlockState)this.propaguleBlock.get().m_49966_().m_61124_((Property)PropaguleBlock.PLANTED, (Comparable)Boolean.valueOf(false));
            world.m_46597_(growPos, propagule);
        }
    }

    private boolean canGrowPropagules(BlockState state) {
        return (Integer)state.m_61143_((Property)f_54418_) <= 3;
    }

    private boolean hasNearPropagule(ServerLevel world, BlockPos source) {
        PropaguleBlock propagule = this.propaguleBlock.get();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)source.m_7918_(-2, -2, -2), (BlockPos)source.m_7918_(2, 0, 2))) {
            if (!world.m_8055_(pos).m_60713_((Block)propagule)) continue;
            return true;
        }
        return false;
    }
}

