/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.jigarbov;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.tropicraft.core.common.block.TropicraftBlocks;

public enum JigarbovTorchType implements StringRepresentable
{
    ACACIA("acacia", () -> Blocks.f_50003_),
    BIRCH("birch", () -> Blocks.f_50001_),
    DARK_OAK("dark_oak", () -> Blocks.f_50004_),
    JUNGLE("jungle", () -> Blocks.f_50002_),
    OAK("oak", () -> Blocks.f_49999_),
    SPRUCE("spruce", () -> Blocks.f_50000_),
    BLACK_MANGROVE("black_mangrove", (Supplier<? extends Block>)TropicraftBlocks.BLACK_MANGROVE_LOG),
    LIGHT_MANGROVE("light_mangrove", (Supplier<? extends Block>)TropicraftBlocks.LIGHT_MANGROVE_LOG),
    RED_MANGROVE("red_mangrove", (Supplier<? extends Block>)TropicraftBlocks.RED_MANGROVE_LOG);

    private static final JigarbovTorchType[] VALUES;
    private final String name;
    private final Supplier<? extends Block> log;

    private JigarbovTorchType(String name, Supplier<? extends Block> log) {
        this.name = name;
        this.log = log;
    }

    @Nullable
    public static JigarbovTorchType byBlock(Block block) {
        if (block.m_49966_().m_204336_(BlockTags.f_13106_)) {
            for (JigarbovTorchType type : VALUES) {
                if (!type.matchesLog(block)) continue;
                return type;
            }
            return OAK;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean matchesLog(Block block) {
        return this.log.get() == block;
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        VALUES = JigarbovTorchType.values();
    }
}

