/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.block.tileentity;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.TropicsConfigs;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.projectile.LavaBallEntity;
import net.tropicraft.core.common.volcano.VolcanoState;

public class VolcanoBlockEntity
extends BlockEntity {
    private static final int RAND_DORMANT_DURATION = 4000;
    private static final int MAX_LAVA_LEVEL_DURING_RISE = 183;
    private static final int MAX_LAVA_LEVEL_DURING_ERUPTION = 185;
    private static final int LAVA_BASE_LEVEL = 149;
    private static final int LAVA_ERUPT_LEVEL = 160;
    private int ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
    private int ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
    private int ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
    private int ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT);
    private int ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
    private int lavaLevel = -1;
    private int radius = -1;
    private VolcanoState state = VolcanoState.DORMANT;
    private int heightOffset = Integer.MIN_VALUE;

    public VolcanoBlockEntity(BlockEntityType<VolcanoBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static void volcanoTick(Level level, BlockPos pos, BlockState state, VolcanoBlockEntity volcano) {
        volcano.tick();
    }

    private void tick() {
        if (!TropicsConfigs.allowVolcanoEruption) {
            return;
        }
        if (!this.m_58904_().f_46443_) {
            // empty if block
        }
        if (this.radius == -1) {
            this.radius = this.findRadius();
        }
        if (this.lavaLevel == -1) {
            this.setLavaLevel();
        }
        if (this.radius == -1 || this.lavaLevel == -1) {
            return;
        }
        this.updateStates();
        switch (this.state) {
            case DORMANT: {
                break;
            }
            case ERUPTING: {
                if (this.m_58904_().f_46443_) break;
                if (this.m_58904_().f_46441_.m_188503_(15) == 0) {
                    this.throwLavaFromCaldera(0.05 + Math.abs(this.m_58904_().f_46441_.m_188583_()) * (this.lavaLevel > 90 ? (double)(160 + this.heightOffset) : 0.75));
                }
                if (this.m_58904_().f_46441_.m_188503_(15) != 0) break;
                this.throwLavaFromCaldera(0.05 + Math.abs(this.m_58904_().f_46441_.m_188583_()) * (this.lavaLevel > 160 + this.heightOffset ? 1.0 : 0.75));
                break;
            }
            case RETREATING: {
                if (this.ticksUntilDormant % 30 != 0) break;
                this.lowerLavaLevels();
                break;
            }
            case RISING: {
                if (this.m_58904_().f_46443_) {
                    this.spewSmoke();
                }
                if (this.ticksUntilEruption % 20 != 0) break;
                if (this.lavaLevel < 185 + this.heightOffset) {
                    this.raiseLavaLevels();
                    break;
                }
                this.ticksUntilEruption = 0;
                this.m_58904_().m_7785_((double)this.f_58858_.m_123341_(), 73.0, (double)this.f_58858_.m_123342_(), SoundEvents.f_11913_, SoundSource.NEUTRAL, 1.0f, this.m_58904_().f_46441_.m_188501_() / 4.0f + 0.825f, false);
                int balls = this.m_58904_().f_46441_.m_188503_(25) + 15;
                for (int i = 0; i < balls; ++i) {
                    this.throwLavaFromCaldera(this.m_58904_().f_46441_.m_188500_() * 0.5 + 1.25);
                }
                break;
            }
            case SMOKING: {
                if (!this.m_58904_().f_46443_) break;
                this.spewSmoke();
                break;
            }
        }
    }

    public void cleanUpFromEruption() {
        int xPos = this.f_58858_.m_123341_();
        int zPos = this.f_58858_.m_123343_();
        for (int x = xPos - this.radius * 2; x < xPos + this.radius * 2; ++x) {
            for (int z = zPos - this.radius * 2; z < zPos + this.radius * 2; ++z) {
                for (int y = 149 + this.heightOffset; y < 140; ++y) {
                    BlockPos outBlockPos = new BlockPos(x, y, z);
                    if (this.m_58904_().m_8055_(outBlockPos).m_60734_() != Blocks.f_49991_) continue;
                    this.m_58904_().m_46597_(outBlockPos, Blocks.f_50016_.m_49966_());
                }
            }
        }
    }

    public void throwLavaFromCaldera(double force) {
        Vec3 pos = new Vec3((this.m_58904_().f_46441_.m_188500_() / 2.0 + 0.3) * (double)this.radius, (double)(this.lavaLevel + 2), 0.0);
        float angle = this.m_58904_().f_46441_.m_188501_() * (float)Math.PI * 2.0f;
        pos = pos.m_82524_(angle).m_82549_(Vec3.m_82512_((Vec3i)this.m_58899_()));
        double motX = force * Math.cos(angle);
        double motZ = force * Math.sin(-angle);
        this.throwLava(pos.f_82479_, pos.f_82480_, pos.f_82481_, motX, 0.86, motZ);
    }

    public void throwLava(double i, double j, double k, double xMot, double yMot, double zMot) {
        if (!this.m_58904_().f_46443_) {
            this.m_58904_().m_7967_((Entity)new LavaBallEntity((EntityType<? extends LavaBallEntity>)((EntityType)TropicraftEntities.LAVA_BALL.get()), this.m_58904_(), i, j, k, xMot, yMot, zMot));
        }
    }

    private void raiseLavaLevels() {
        if (this.lavaLevel < 185 + this.heightOffset) {
            ++this.lavaLevel;
            this.setBlocksOnLavaLevel(Blocks.f_49991_.m_49966_(), 3);
        }
    }

    private void lowerLavaLevels() {
        if (this.lavaLevel > 149 + this.heightOffset) {
            this.setBlocksOnLavaLevel(Blocks.f_50016_.m_49966_(), 3);
            --this.lavaLevel;
        }
    }

    private void setBlocksOnLavaLevel(BlockState state, int updateFlag) {
        int xPos = this.f_58858_.m_123341_();
        int zPos = this.f_58858_.m_123343_();
        for (int x = xPos - this.radius; x < xPos + this.radius; ++x) {
            for (int z = zPos - this.radius; z < zPos + this.radius; ++z) {
                if (!(Math.sqrt(Math.pow(x - xPos, 2.0) + Math.pow(z - zPos, 2.0)) < (double)(this.radius + 3))) continue;
                BlockPos botPos = new BlockPos(x, 10, z);
                if (this.m_58904_().m_8055_(botPos).m_60734_() != Blocks.f_49991_) continue;
                BlockPos pos2 = new BlockPos(x, this.lavaLevel, z);
                if (this.lavaLevel >= 183 + this.heightOffset && this.lavaLevel < 185 + this.heightOffset) {
                    if (this.m_58904_().m_8055_(pos2).m_60734_() == TropicraftBlocks.CHUNK.get()) continue;
                    this.m_58904_().m_7731_(pos2, state, updateFlag);
                    continue;
                }
                this.m_58904_().m_7731_(pos2, state, updateFlag);
            }
        }
    }

    public void spewSmoke() {
        int n = this.m_58904_().f_46441_.m_188503_(100) + 4;
        for (int i = 0; i < n; ++i) {
            double x = this.f_58858_.m_123341_() + this.m_58904_().f_46441_.m_188503_(this.radius) * (this.m_58904_().f_46441_.m_188499_() ? -1 : 1);
            double y = this.lavaLevel + this.m_58904_().f_46441_.m_188503_(6);
            double z = this.f_58858_.m_123343_() + this.m_58904_().f_46441_.m_188503_(this.radius) * (this.m_58904_().f_46441_.m_188499_() ? -1 : 1);
            this.m_58904_().m_6493_((ParticleOptions)ParticleTypes.f_123755_, true, x, y, z, 0.0, 0.7, 0.0);
        }
    }

    private void updateStates() {
        switch (this.state) {
            case DORMANT: {
                --this.ticksUntilSmoking;
                if (this.ticksUntilSmoking > 0) break;
                this.state = VolcanoState.SMOKING;
                this.ticksUntilSmoking = VolcanoState.getTimeBefore(VolcanoState.SMOKING);
                break;
            }
            case SMOKING: {
                --this.ticksUntilRising;
                if (this.ticksUntilRising > 0) break;
                this.state = VolcanoState.RISING;
                this.ticksUntilRising = VolcanoState.getTimeBefore(VolcanoState.RISING);
                break;
            }
            case RISING: {
                --this.ticksUntilEruption;
                if (this.ticksUntilEruption > 0) break;
                this.state = VolcanoState.ERUPTING;
                this.ticksUntilEruption = VolcanoState.getTimeBefore(VolcanoState.ERUPTING);
                break;
            }
            case ERUPTING: {
                --this.ticksUntilRetreating;
                if (this.ticksUntilRetreating > 0) break;
                this.state = VolcanoState.RETREATING;
                this.ticksUntilRetreating = VolcanoState.getTimeBefore(VolcanoState.RETREATING);
                break;
            }
            case RETREATING: {
                --this.ticksUntilDormant;
                if (this.ticksUntilDormant > 0) break;
                this.state = VolcanoState.DORMANT;
                this.ticksUntilDormant = VolcanoState.getTimeBefore(VolcanoState.DORMANT) + this.m_58904_().f_46441_.m_188503_(4000);
                break;
            }
        }
    }

    private void setLavaLevel() {
        for (int y = 149 + this.heightOffset; y < this.f_58857_.m_151558_(); ++y) {
            BlockPos pos2 = new BlockPos(this.f_58858_.m_123341_(), y, this.f_58858_.m_123343_());
            if (this.m_58904_().m_8055_(pos2).m_60767_() == Material.f_76307_) continue;
            this.lavaLevel = y - 1;
            return;
        }
    }

    private int findRadius() {
        for (int x = 0; x < 60; ++x) {
            if (this.m_58904_().m_8055_(new BlockPos(x + this.f_58858_.m_123341_(), 10, this.f_58858_.m_123343_())).m_60734_() == Blocks.f_49991_) continue;
            return x;
        }
        return -1;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.heightOffset = nbt.m_128451_("height_offset");
        this.state = VolcanoState.valueOf(nbt.m_128461_("state"));
        this.ticksUntilDormant = nbt.m_128451_("ticksUntilDormant");
        this.ticksUntilSmoking = nbt.m_128451_("ticksUntilSmoking");
        this.ticksUntilRising = nbt.m_128451_("ticksUntilRising");
        this.ticksUntilEruption = nbt.m_128451_("ticksUntilEruption");
        this.ticksUntilRetreating = nbt.m_128451_("ticksUntilRetreating");
        this.lavaLevel = nbt.m_128451_("lavaLevel");
        this.radius = nbt.m_128451_("radius");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("height_offset", this.heightOffset);
        nbt.m_128359_("state", this.state.name());
        nbt.m_128405_("ticksUntilDormant", this.ticksUntilDormant);
        nbt.m_128405_("ticksUntilSmoking", this.ticksUntilSmoking);
        nbt.m_128405_("ticksUntilRising", this.ticksUntilRising);
        nbt.m_128405_("ticksUntilEruption", this.ticksUntilEruption);
        nbt.m_128405_("ticksUntilRetreating", this.ticksUntilRetreating);
        nbt.m_128405_("lavaLevel", this.lavaLevel);
        nbt.m_128405_("radius", this.radius);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        this.m_183515_(nbt);
        return nbt;
    }

    public void setHeightOffset(int y) {
        this.heightOffset = y;
    }
}

