/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension;

import net.minecraft.util.CubicSpline;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;

public final class TropicraftTerrainProvider {
    private static final ToFloatFunction<Float> NO_TRANSFORM = ToFloatFunction.f_216471_;

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> offset(I continents, I erosion, I ridges) {
        ToFloatFunction offsetTransform = ToFloatFunction.m_216475_(offset -> offset + 0.5f);
        CubicSpline<C, I> nearInlandDepth = TropicraftTerrainProvider.buildErosionOffsetSpline(erosion, ridges, -0.15f, 0.0f, 0.0f, 0.1f, 0.0f, -0.03f, false, false, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<C, I> midInlandDepth = TropicraftTerrainProvider.buildErosionOffsetSpline(erosion, ridges, -0.1f, 0.03f, 0.1f, 0.1f, 0.01f, -0.03f, false, false, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<C, I> farInlandDepth = TropicraftTerrainProvider.buildErosionOffsetSpline(erosion, ridges, -0.1f, 0.03f, 0.1f, 0.7f, 0.01f, -0.03f, true, true, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<C, I> peaksDepth = TropicraftTerrainProvider.buildErosionOffsetSpline(erosion, ridges, -0.05f, 0.03f, 0.1f, 1.0f, 0.01f, 0.01f, true, true, (ToFloatFunction<Float>)offsetTransform);
        CubicSpline<C, I> lagoonSpline = TropicraftTerrainProvider.buildLagoonOffset(erosion, (ToFloatFunction<Float>)offsetTransform);
        return CubicSpline.m_184254_(continents, (ToFloatFunction)offsetTransform).m_216114_(-1.1f, 0.14f).m_216114_(-0.92f, -0.2222f).m_216114_(-0.41f, -0.2222f).m_216114_(-0.34f, -0.12f).m_216117_(-0.22f, lagoonSpline).m_216117_(-0.18f, lagoonSpline).m_216117_(-0.16f, nearInlandDepth).m_216117_(-0.15f, nearInlandDepth).m_216117_(-0.1f, midInlandDepth).m_216117_(0.25f, farInlandDepth).m_216117_(1.0f, peaksDepth).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> factor(I continents, I erosion, I weirdness, I ridges) {
        float beachFactorStrength = 6.25f;
        float nearinlandFactorStrength = 4.22f;
        float midInlandFactorStrength = 3.8f;
        float furtherInlandFactorStrength = 2.44f;
        return CubicSpline.m_184254_(continents, NO_TRANSFORM).m_216114_(-1.1f, 0.54f).m_216114_(-0.92f, 3.95f).m_216114_(-0.19f, 3.95f).m_216117_(-0.15f, TropicraftTerrainProvider.getErosionFactor(weirdness, erosion, ridges, 6.25f, true, NO_TRANSFORM)).m_216117_(-0.1f, TropicraftTerrainProvider.getErosionFactor(weirdness, erosion, ridges, 4.22f, true, NO_TRANSFORM)).m_216117_(0.03f, TropicraftTerrainProvider.getErosionFactor(weirdness, erosion, ridges, 3.8f, true, NO_TRANSFORM)).m_216117_(0.06f, TropicraftTerrainProvider.getErosionFactor(weirdness, erosion, ridges, 2.44f, false, NO_TRANSFORM)).m_184297_();
    }

    public static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> jaggedness(I continents, I erosion, I weirdness, I ridges) {
        float jaggednessMax = 0.65f;
        return CubicSpline.m_184254_(continents, NO_TRANSFORM).m_216114_(-0.11f, 0.0f).m_216117_(0.03f, TropicraftTerrainProvider.buildErosionJaggednessSpline(weirdness, erosion, ridges, 1.0f, 0.5f, 0.0f, 0.0f, NO_TRANSFORM)).m_216117_(jaggednessMax, TropicraftTerrainProvider.buildErosionJaggednessSpline(weirdness, erosion, ridges, 1.0f, 1.0f, 1.0f, 0.0f, NO_TRANSFORM)).m_184297_();
    }

    public static float peaksAndValleys(float weirdness) {
        return -(Math.abs(Math.abs(weirdness) - 0.6666667f) - 0.33333334f) * 3.0f;
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionJaggednessSpline(I weirdness, I erosion, I ridges, float p_187295_, float p_187296_, float p_187297_, float p_187298_, ToFloatFunction<Float> p_187299_) {
        float f = -0.5775f;
        CubicSpline<C, I> cubicspline = TropicraftTerrainProvider.buildRidgeJaggednessSpline(weirdness, ridges, p_187295_, p_187297_, p_187299_);
        CubicSpline<C, I> cubicspline1 = TropicraftTerrainProvider.buildRidgeJaggednessSpline(weirdness, ridges, p_187296_, p_187298_, p_187299_);
        return CubicSpline.m_184254_(erosion, p_187299_).m_216117_(-1.0f, cubicspline).m_216117_(-0.78f, cubicspline1).m_216117_(-0.5775f, cubicspline1).m_216114_(-0.375f, 0.0f).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildRidgeJaggednessSpline(I weirdness, I ridges, float p_187301_, float p_187302_, ToFloatFunction<Float> p_187303_) {
        float f = TropicraftTerrainProvider.peaksAndValleys(0.4f);
        float f1 = TropicraftTerrainProvider.peaksAndValleys(0.56666666f);
        float f2 = (f + f1) / 2.0f;
        CubicSpline.Builder builder = CubicSpline.m_184254_(ridges, p_187303_);
        builder.m_216114_(f, 0.0f);
        if (p_187302_ > 0.0f) {
            builder.m_216117_(f2, TropicraftTerrainProvider.buildWeirdnessJaggednessSpline(weirdness, p_187302_, p_187303_));
        } else {
            builder.m_216114_(f2, 0.0f);
        }
        if (p_187301_ > 0.0f) {
            builder.m_216117_(1.0f, TropicraftTerrainProvider.buildWeirdnessJaggednessSpline(weirdness, p_187301_, p_187303_));
        } else {
            builder.m_216114_(1.0f, 0.0f);
        }
        return builder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildWeirdnessJaggednessSpline(I weirdness, float p_187305_, ToFloatFunction<Float> p_187306_) {
        float f = 0.63f * p_187305_;
        float f1 = 0.3f * p_187305_;
        return CubicSpline.m_184254_(weirdness, p_187306_).m_216114_(-0.01f, f).m_216114_(0.01f, f1).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> getErosionFactor(I weirdness, I erosion, I ridges, float strengthForContinentalness, boolean coastal, ToFloatFunction<Float> p_187310_) {
        float defaultScale = 3.1f;
        float roughScale = 2.23f;
        CubicSpline defaultPVScaleSpline = CubicSpline.m_184254_(weirdness, p_187310_).m_216114_(-0.2f, 3.1f).m_216114_(0.2f, strengthForContinentalness).m_184297_();
        CubicSpline.Builder erosionSplineBuilder = CubicSpline.m_184254_(erosion, p_187310_).m_216117_(-0.6f, defaultPVScaleSpline).m_216117_(-0.5f, CubicSpline.m_184254_(weirdness, p_187310_).m_216114_(-0.05f, 3.1f).m_216114_(0.05f, 2.23f).m_184297_()).m_216117_(-0.35f, defaultPVScaleSpline).m_216117_(-0.25f, defaultPVScaleSpline).m_216117_(-0.1f, CubicSpline.m_184254_(weirdness, p_187310_).m_216114_(-0.05f, 2.23f).m_216114_(0.05f, 3.1f).m_184297_()).m_216117_(0.03f, defaultPVScaleSpline);
        if (coastal) {
            CubicSpline coastalWeirdnessForShattered = CubicSpline.m_184254_(weirdness, p_187310_).m_216114_(0.0f, strengthForContinentalness).m_216114_(0.1f, 0.625f).m_184297_();
            CubicSpline coastalRidgeForShattered = CubicSpline.m_184254_(ridges, p_187310_).m_216114_(-0.9f, strengthForContinentalness).m_216117_(-0.69f, coastalWeirdnessForShattered).m_184297_();
            erosionSplineBuilder.m_216114_(0.35f, strengthForContinentalness).m_216117_(0.45f, coastalRidgeForShattered).m_216117_(0.55f, coastalRidgeForShattered).m_216114_(0.62f, strengthForContinentalness);
        } else {
            CubicSpline ridgeLowShattered = CubicSpline.m_184254_(ridges, p_187310_).m_216117_(-0.7f, defaultPVScaleSpline).m_216114_(-0.15f, 1.37f).m_184297_();
            CubicSpline ridgeHighShattered = CubicSpline.m_184254_(ridges, p_187310_).m_216117_(0.35f, defaultPVScaleSpline).m_216114_(0.7f, 1.56f).m_184297_();
            erosionSplineBuilder.m_216117_(0.05f, ridgeHighShattered).m_216117_(0.4f, ridgeHighShattered).m_216117_(0.45f, ridgeLowShattered).m_216117_(0.55f, ridgeLowShattered).m_216114_(0.58f, strengthForContinentalness);
        }
        return erosionSplineBuilder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildLagoonOffset(I erosion, ToFloatFunction<Float> offsetTransform) {
        return CubicSpline.m_184254_(erosion, offsetTransform).m_216114_(-1.0f, -0.12f).m_216114_(0.4f, -0.06f).m_216114_(1.0f, -0.01f).m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildMountainRidgeSplineWithPoints(I ridges, float p_187331_, boolean p_187332_, ToFloatFunction<Float> transform) {
        CubicSpline.Builder builder = CubicSpline.m_184254_(ridges, transform);
        float f2 = TropicraftTerrainProvider.mountainContinentalness(-1.0f, p_187331_, -0.7f);
        float f4 = TropicraftTerrainProvider.mountainContinentalness(1.0f, p_187331_, -0.7f);
        float f5 = TropicraftTerrainProvider.calculateMountainRidgeZeroContinentalnessPoint(p_187331_);
        if (-0.65f < f5 && f5 < 1.0f) {
            float f14 = TropicraftTerrainProvider.mountainContinentalness(-0.65f, p_187331_, -0.7f);
            float f9 = TropicraftTerrainProvider.mountainContinentalness(-0.75f, p_187331_, -0.7f);
            float f10 = TropicraftTerrainProvider.calculateSlope(f2, f9, -1.0f, -0.75f);
            builder.m_184298_(-1.0f, f2, f10);
            builder.m_216114_(-0.75f, f9);
            builder.m_216114_(-0.65f, f14);
            float f11 = TropicraftTerrainProvider.mountainContinentalness(f5, p_187331_, -0.7f);
            float f12 = TropicraftTerrainProvider.calculateSlope(f11, f4, f5, 1.0f);
            builder.m_216114_(f5 - 0.01f, f11);
            builder.m_184298_(f5, f11, f12);
            builder.m_184298_(1.0f, f4, f12);
        } else {
            float f7 = TropicraftTerrainProvider.calculateSlope(f2, f4, -1.0f, 1.0f);
            if (p_187332_) {
                builder.m_216114_(-1.0f, Math.max(0.2f, f2));
                builder.m_184298_(0.0f, Mth.m_14179_((float)0.5f, (float)f2, (float)f4), f7);
            } else {
                builder.m_184298_(-1.0f, f2, f7);
            }
            builder.m_184298_(1.0f, f4, f7);
        }
        return builder.m_184297_();
    }

    private static float calculateSlope(float p_187272_, float p_187273_, float p_187274_, float p_187275_) {
        return (p_187273_ - p_187272_) / (p_187275_ - p_187274_);
    }

    private static float mountainContinentalness(float p_187327_, float p_187328_, float p_187329_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_187328_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_187328_);
        float f4 = (p_187327_ + 1.17f) * 0.46082947f;
        float f5 = f4 * f2 - f3;
        return p_187327_ < p_187329_ ? Math.max(f5, -0.2222f) : Math.max(f5, 0.0f);
    }

    private static float calculateMountainRidgeZeroContinentalnessPoint(float p_187344_) {
        float f = 1.17f;
        float f1 = 0.46082947f;
        float f2 = 1.0f - (1.0f - p_187344_) * 0.5f;
        float f3 = 0.5f * (1.0f - p_187344_);
        return f3 / (0.46082947f * f2) - 1.17f;
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> buildErosionOffsetSpline(I erosion, I ridges, float p_187285_, float p_187286_, float p_187287_, float p_187288_, float p_187289_, float p_187290_, boolean buildSaddleValley, boolean p_187292_, ToFloatFunction<Float> transform) {
        CubicSpline<C, I> cubicspline = TropicraftTerrainProvider.buildMountainRidgeSplineWithPoints(ridges, Mth.m_14179_((float)p_187288_, (float)0.6f, (float)1.5f), p_187292_, transform);
        CubicSpline<C, I> cubicspline1 = TropicraftTerrainProvider.buildMountainRidgeSplineWithPoints(ridges, Mth.m_14179_((float)p_187288_, (float)0.6f, (float)1.0f), p_187292_, transform);
        CubicSpline<C, I> cubicspline2 = TropicraftTerrainProvider.buildMountainRidgeSplineWithPoints(ridges, p_187288_, p_187292_, transform);
        CubicSpline<C, I> cubicspline3 = TropicraftTerrainProvider.ridgeSpline(ridges, p_187285_ - 0.15f, 0.5f * p_187288_, Mth.m_14179_((float)0.5f, (float)0.5f, (float)0.5f) * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, transform);
        CubicSpline<C, I> cubicspline4 = TropicraftTerrainProvider.ridgeSpline(ridges, p_187285_, p_187289_ * p_187288_, p_187286_ * p_187288_, 0.5f * p_187288_, 0.6f * p_187288_, 0.5f, transform);
        CubicSpline<C, I> cubicspline5 = TropicraftTerrainProvider.ridgeSpline(ridges, p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, transform);
        CubicSpline<C, I> saddleValleySlope = TropicraftTerrainProvider.ridgeSpline(ridges, p_187285_, p_187289_, p_187289_, p_187286_, p_187287_, 0.5f, transform);
        CubicSpline saddleValleyMin = CubicSpline.m_184254_(ridges, transform).m_184298_(-1.0f, p_187285_, 0.0f).m_216117_(-0.4f, cubicspline5).m_184298_(0.0f, p_187287_ + 0.07f, 0.0f).m_184297_();
        CubicSpline<C, I> cubicspline8 = TropicraftTerrainProvider.ridgeSpline(ridges, -0.02f, p_187290_, p_187290_, p_187286_, p_187287_, 0.0f, transform);
        CubicSpline.Builder erosionBuilder = CubicSpline.m_184254_(erosion, transform).m_216117_(-0.85f, cubicspline).m_216117_(-0.7f, cubicspline1).m_216117_(-0.4f, cubicspline2).m_216117_(-0.35f, cubicspline3).m_216117_(-0.1f, cubicspline4).m_216117_(0.2f, cubicspline5);
        if (buildSaddleValley) {
            erosionBuilder.m_216117_(0.4f, saddleValleySlope).m_216117_(0.45f, saddleValleyMin).m_216117_(0.55f, saddleValleyMin).m_216117_(0.58f, saddleValleySlope);
        }
        erosionBuilder.m_216117_(0.7f, cubicspline8);
        return erosionBuilder.m_184297_();
    }

    private static <C, I extends ToFloatFunction<C>> CubicSpline<C, I> ridgeSpline(I ridges, float riverHeight, float p_187278_, float p_187279_, float p_187280_, float peakHeight, float p_187282_, ToFloatFunction<Float> transform) {
        float f = Math.max(0.5f * (p_187278_ - riverHeight), p_187282_);
        float f1 = 5.0f * (p_187279_ - p_187278_);
        return CubicSpline.m_184254_(ridges, transform).m_184298_(-1.0f, riverHeight, f).m_184298_(-0.4f, p_187278_, Math.min(f, f1)).m_184298_(0.0f, p_187279_, f1).m_184298_(0.4f, p_187280_, 2.0f * (p_187280_ - p_187279_)).m_184298_(1.0f, peakHeight, 0.7f * (peakHeight - p_187280_)).m_184297_();
    }
}

