/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.TropicraftTerrainProvider;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomes;

public class TropicraftBiomeSource
extends BiomeSource {
    public static final Codec<TropicraftBiomeSource> CODEC = RecordCodecBuilder.create(i -> i.group((App)RegistryOps.m_206832_((ResourceKey)Registry.f_122885_).forGetter(b -> b.biomes)).apply((Applicative)i, i.stable(TropicraftBiomeSource::new)));
    private static final TropicraftBiomeBuilder DEBUG_BIOME_HOLDER = new TropicraftBiomeBuilder();
    private static final Set<ResourceKey<Biome>> POSSIBLE_BIOMES = Stream.of(TropicraftBiomes.TROPICS, TropicraftBiomes.OCEAN, TropicraftBiomes.RIVER, TropicraftBiomes.BEACH, TropicraftBiomes.RAINFOREST, TropicraftBiomes.BAMBOO_RAINFOREST, TropicraftBiomes.KELP_FOREST, TropicraftBiomes.MANGROVES, TropicraftBiomes.OVERGROWN_MANGROVES, TropicraftBiomes.OSA_RAINFOREST, TropicraftBiomes.TROPICAL_PEAKS).map(RegistryObject::getKey).collect(Collectors.toSet());
    private final Registry<Biome> biomes;
    private final Climate.ParameterList<Holder<Biome>> parameters;

    public TropicraftBiomeSource(Registry<Biome> biomes) {
        super(POSSIBLE_BIOMES.stream().map(arg_0 -> biomes.m_206081_(arg_0)));
        this.biomes = biomes;
        ImmutableList.Builder builder = ImmutableList.builder();
        new TropicraftBiomeBuilder().addBiomes((point, biome) -> builder.add((Object)Pair.of((Object)point, (Object)biomes.m_206081_(biome.getKey()))));
        this.parameters = new Climate.ParameterList((List)builder.build());
    }

    public static void register() {
        Registry.m_122965_((Registry)Registry.f_122889_, (ResourceLocation)new ResourceLocation("tropicraft", "tropics"), CODEC);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int x, int y, int z, Climate.Sampler sampler) {
        return (Holder)this.parameters.m_204252_(sampler.m_183445_(x, y, z));
    }

    public void m_207301_(List<String> result, BlockPos pos, Climate.Sampler sampler) {
        Climate.TargetPoint climate = sampler.m_183445_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()));
        float continentalness = Climate.m_186796_((long)climate.f_187005_());
        float erosion = Climate.m_186796_((long)climate.f_187006_());
        float temperature = Climate.m_186796_((long)climate.f_187003_());
        float humidity = Climate.m_186796_((long)climate.f_187004_());
        float weirdness = Climate.m_186796_((long)climate.f_187008_());
        double peaksAndValleys = TropicraftTerrainProvider.peaksAndValleys(weirdness);
        result.add("Biome builder PV: " + OverworldBiomeBuilder.m_187155_((double)peaksAndValleys) + " C: " + DEBUG_BIOME_HOLDER.getDebugStringForContinentalness(continentalness) + " E: " + DEBUG_BIOME_HOLDER.getDebugStringForErosion(erosion) + " T: " + DEBUG_BIOME_HOLDER.getDebugStringForTemperature(temperature) + " H: " + DEBUG_BIOME_HOLDER.getDebugStringForHumidity(humidity));
    }
}

