/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome;

import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.Tropicraft;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.dimension.carver.TropicraftConfiguredCarvers;
import net.tropicraft.core.common.dimension.feature.TropicraftMiscPlacements;
import net.tropicraft.core.common.dimension.feature.TropicraftVegetationPlacements;
import net.tropicraft.core.common.entity.TropicraftEntities;

@Mod.EventBusSubscriber(modid="tropicraft")
public final class TropicraftBiomes {
    public static final Registrate REGISTRATE = Tropicraft.registrate();
    public static final DeferredRegister<Biome> REGISTER = DeferredRegister.create((ResourceKey)Registry.f_122885_, (String)"tropicraft");
    public static final int TROPICS_WATER_COLOR = 5172447;
    public static final int TROPICS_WATER_FOG_COLOR = 270131;
    public static final int TROPICS_FOG_COLOR = 12638463;
    public static final int RAINFOREST_FOG_COLOR = 12248771;
    public static final int TROPICS_SKY_COLOR = TropicraftBiomes.getSkyColor(0.8f);
    public static final RegistryObject<Biome> TROPICS = REGISTER.register("tropics", TropicraftBiomes::createTropics);
    public static final RegistryObject<Biome> BEACH = REGISTER.register("beach", TropicraftBiomes::createBeach);
    public static final RegistryObject<Biome> RAINFOREST = REGISTER.register("rainforest", () -> TropicraftBiomes.createRainforest(false));
    public static final RegistryObject<Biome> BAMBOO_RAINFOREST = REGISTER.register("bamboo_rainforest", () -> TropicraftBiomes.createRainforest(true));
    public static final RegistryObject<Biome> OSA_RAINFOREST = REGISTER.register("osa_rainforest", TropicraftBiomes::createOsaRainforest);
    public static final RegistryObject<Biome> OCEAN = REGISTER.register("ocean", TropicraftBiomes::createOcean);
    public static final RegistryObject<Biome> KELP_FOREST = REGISTER.register("kelp_forest", TropicraftBiomes::createKelpForest);
    public static final RegistryObject<Biome> RIVER = REGISTER.register("river", TropicraftBiomes::createRiver);
    public static final RegistryObject<Biome> MANGROVES = REGISTER.register("mangroves", () -> TropicraftBiomes.createMangroves(false));
    public static final RegistryObject<Biome> OVERGROWN_MANGROVES = REGISTER.register("overgrown_mangroves", () -> TropicraftBiomes.createMangroves(true));
    public static final RegistryObject<Biome> TROPICAL_PEAKS = REGISTER.register("tropical_peaks", TropicraftBiomes::createTropicalPeaks);

    private static Biome createTropics() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftConfiguredCarvers.addLand(generation);
        TropicraftVegetationPlacements.addFloweringBushes(generation);
        TropicraftVegetationPlacements.addFruitTrees(generation);
        TropicraftVegetationPlacements.addPalmTrees(generation);
        TropicraftMiscPlacements.addEih(generation);
        TropicraftVegetationPlacements.addPapaya(generation);
        TropicraftVegetationPlacements.addTropicsFlowers(generation);
        TropicraftVegetationPlacements.addPineapples(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        TropicraftVegetationPlacements.addTropicsGrass(generation);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        spawns.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.FAILGULL.get(), 10, 5, 15));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPI_BEE.get(), 10, 4, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.COWKTAIL.get(), 10, 4, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TREE_FROG.get(), 4, 4, 4));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(2.0f).m_47611_(1.5f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(true).m_48018_()).m_47592_();
    }

    private static Biome createBeach() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftVegetationPlacements.addPalmTrees(generation);
        TropicraftVegetationPlacements.addTropicsFlowers(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.FIDDLER_CRAB.get(), 10, 1, 2));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(1.25f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(false).m_48018_()).m_47592_();
    }

    private static Biome createOsaRainforest() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftConfiguredCarvers.addLand(generation);
        TropicraftVegetationPlacements.addGoldenLeatherFern(generation);
        TropicraftVegetationPlacements.addFloweringBushes(generation);
        TropicraftMiscPlacements.addTropicsGems(generation);
        TropicraftVegetationPlacements.addPleodendron(generation);
        TropicraftVegetationPlacements.addRainforestTrees(generation);
        TropicraftVegetationPlacements.addPapaya(generation);
        TropicraftVegetationPlacements.addTropicsFlowers(generation);
        TropicraftVegetationPlacements.addPineapples(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        TropicraftVegetationPlacements.addTropicsGrass(generation);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)generation);
        TropicraftVegetationPlacements.addRainforestPlants(generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 10, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 10, 1, 2));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TREE_FROG.get(), 25, 2, 5));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPI_SPIDER.get(), 30, 1, 1));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TAPIR.get(), 15, 2, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.WHITE_LIPPED_PECCARY.get(), 15, 6, 12));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.JAGUAR.get(), 5, 1, 2));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.HUMMINGBIRD.get(), 10, 3, 5));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SPIDER_MONKEY.get(), 15, 6, 8));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(2.0f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(true).m_48018_()).m_47592_();
    }

    private static Biome createRainforest(boolean bamboo) {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftConfiguredCarvers.addLand(generation);
        TropicraftVegetationPlacements.addRareFloweringBushes(generation);
        TropicraftMiscPlacements.addTropicsGems(generation);
        TropicraftVegetationPlacements.addRainforestTrees(generation);
        TropicraftVegetationPlacements.addPapaya(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)generation);
        TropicraftVegetationPlacements.addRainforestPlants(generation);
        TropicraftVegetationPlacements.addUndergrowth(generation);
        if (bamboo) {
            TropicraftVegetationPlacements.addBamboo(generation);
        }
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20505_, 10, 1, 1));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 10, 1, 2));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TREE_FROG.get(), 25, 2, 5));
        spawns.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPI_SPIDER.get(), 30, 1, 1));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TAPIR.get(), 15, 2, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.WHITE_LIPPED_PECCARY.get(), 15, 2, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.JAGUAR.get(), 5, 1, 2));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.HUMMINGBIRD.get(), 10, 3, 5));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SPIDER_MONKEY.get(), 15, 5, 8));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(2.0f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(true).m_48018_()).m_47592_();
    }

    private static Biome createOcean() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftVegetationPlacements.addPalmTrees(generation);
        TropicraftMiscPlacements.addTropicsMetals(generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, (Holder)TropicraftVegetationPlacements.TROPI_SEAGRASS.getHolder().get());
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195230_);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195218_);
        TropicraftVegetationPlacements.addUndergroundSeagrass(generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195227_);
        TropicraftVegetationPlacements.addUndergroundPickles(generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        TropicraftBiomes.addOceanWaterCreatures(spawns);
        spawns.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.FAILGULL.get(), 15, 5, 10));
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(1.25f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(false).m_48018_()).m_47592_();
    }

    private static Biome createKelpForest() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftVegetationPlacements.addPalmTrees(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        TropicraftVegetationPlacements.addKelp(generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        TropicraftBiomes.addOceanWaterCreatures(spawns);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(1.25f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(false).m_48018_()).m_47592_();
    }

    private static Biome createRiver() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftConfiguredCarvers.addLand(generation);
        TropicraftVegetationPlacements.addTropicsFlowers(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        TropicraftBiomes.addRiverWaterCreatures(spawns);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(1.25f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(false).m_48018_()).m_47592_();
    }

    private static Biome createTropicalPeaks() {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftMiscPlacements.addTropicsGems(generation);
        TropicraftVegetationPlacements.addRainforestTrees(generation);
        TropicraftVegetationPlacements.addPapaya(generation);
        TropicraftVegetationPlacements.addSeagrass(generation);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)generation);
        TropicraftVegetationPlacements.addRainforestPlants(generation);
        TropicraftVegetationPlacements.addUndergrowth(generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(1.5f).m_47611_(1.25f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(TropicraftBiomes.defaultAmbience(true).m_48018_()).m_47592_();
    }

    private static Biome createMangroves(boolean overgrown) {
        BiomeGenerationSettings.Builder generation = TropicraftBiomes.defaultGeneration();
        TropicraftConfiguredCarvers.addLand(generation);
        TropicraftMiscPlacements.addMudDisks(generation);
        if (overgrown) {
            TropicraftVegetationPlacements.addOvergrownGoldenLeatherFern(generation);
        }
        TropicraftVegetationPlacements.addGoldenLeatherFern(generation);
        TropicraftVegetationPlacements.addMangroveVegetation(generation, overgrown);
        TropicraftVegetationPlacements.addTropicsFlowers(generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195223_);
        TropicraftVegetationPlacements.addMangroveReeds(generation);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195451_);
        generation.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195466_);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)generation);
        MobSpawnSettings.Builder spawns = TropicraftBiomes.defaultSpawns();
        spawns.m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.FAILGULL.get(), 5, 5, 15));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TREE_FROG.get(), 4, 4, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TAPIR.get(), 15, 2, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.WHITE_LIPPED_PECCARY.get(), 15, 2, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.JAGUAR.get(), 8, 1, 3));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.HUMMINGBIRD.get(), 12, 3, 5));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SPIDER_MONKEY.get(), 15, 5, 8));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.BROWN_BASILISK_LIZARD.get(), 10, 1, 3));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.GREEN_BASILISK_LIZARD.get(), 10, 1, 3));
        TropicraftBiomes.addMangroveWaterCreatures(spawns);
        BiomeSpecialEffects.Builder ambience = TropicraftBiomes.defaultAmbience(true);
        ambience.m_48034_(6734231).m_48037_(800034);
        ambience.m_48045_(7320092);
        return new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.RAIN).m_47609_(2.0f).m_47611_(1.5f).m_47601_(generation.m_47831_()).m_47605_(spawns.m_48381_()).m_47603_(ambience.m_48018_()).m_47592_();
    }

    private static void addOceanWaterCreatures(MobSpawnSettings.Builder spawns) {
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPICAL_FISH.get(), 20, 4, 8));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.STARFISH.get(), 4, 1, 4));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SEAHORSE.get(), 6, 6, 12));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SEA_URCHIN.get(), 4, 1, 4));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.MAN_O_WAR.get(), 2, 1, 1));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.MARLIN.get(), 10, 1, 4));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.CUBERA.get(), 10, 2, 4));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.EAGLE_RAY.get(), 6, 1, 1));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SEA_TURTLE.get(), 6, 3, 8));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.DOLPHIN.get(), 3, 4, 7));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.HAMMERHEAD.get(), 2, 1, 1));
    }

    private static void addRiverWaterCreatures(MobSpawnSettings.Builder spawns) {
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.FIDDLER_CRAB.get(), 20, 2, 6));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.PIRANHA.get(), 15, 1, 12));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.RIVER_SARDINE.get(), 20, 1, 8));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 8, 1, 4));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20556_, 4, 1, 5));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 4, 1, 5));
    }

    private static void addMangroveWaterCreatures(MobSpawnSettings.Builder spawns) {
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.FIDDLER_CRAB.get(), 20, 2, 6));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.PIRANHA.get(), 15, 1, 12));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.RIVER_SARDINE.get(), 20, 1, 8));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20556_, 4, 1, 5));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20519_, 4, 1, 5));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData(EntityType.f_20489_, 12, 1, 5));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.STARFISH.get(), 4, 1, 4));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SEA_URCHIN.get(), 4, 1, 4));
        spawns.m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.SEAHORSE.get(), 6, 6, 12));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.HAMMERHEAD.get(), 2, 1, 1));
        spawns.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20480_, 8, 1, 4));
    }

    private static BiomeGenerationSettings.Builder defaultGeneration() {
        BiomeGenerationSettings.Builder generation = new BiomeGenerationSettings.Builder();
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)generation);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)generation);
        return generation;
    }

    private static MobSpawnSettings.Builder defaultSpawns() {
        MobSpawnSettings.Builder spawns = new MobSpawnSettings.Builder();
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20508_, 15, 1, 2));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.V_MONKEY.get(), 15, 1, 3));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.IGUANA.get(), 15, 4, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPICREEPER.get(), 4, 1, 2));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.EIH.get(), 5, 1, 1));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPISKELLY.get(), 8, 2, 4));
        spawns.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)TropicraftEntities.TROPI_SPIDER.get(), 8, 2, 2));
        return spawns;
    }

    private static BiomeSpecialEffects.Builder defaultAmbience(boolean greenFog) {
        return new BiomeSpecialEffects.Builder().m_48019_(greenFog ? 12248771 : 12638463).m_48040_(TROPICS_SKY_COLOR).m_48034_(5172447).m_48037_(270131);
    }

    private static int getSkyColor(float temperature) {
        float shift = Mth.m_14036_((float)(temperature / 3.0f), (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - shift * 0.05f), (float)(0.5f + shift * 0.1f), (float)1.0f);
    }

    static {
        REGISTRATE.addDataGenerator(ProviderType.LANG, prov -> {
            Consumer<String> register = name -> prov.add("biome.tropicraft." + name, RegistrateLangProvider.toEnglishName((String)name));
            register.accept("tropics");
            register.accept("beach");
            register.accept("rainforest");
            register.accept("bamboo_rainforest");
            register.accept("osa_rainforest");
            register.accept("ocean");
            register.accept("kelp_forest");
            register.accept("river");
            register.accept("mangroves");
            register.accept("overgrown_mangroves");
            register.accept("tropical_peaks");
        });
        REGISTRATE.addDataGenerator(Tropicraft.BIOME_TAGS, prov -> {
            prov.m_206424_(BiomeTags.f_207603_).m_211101_(new ResourceKey[]{OCEAN.getKey(), KELP_FOREST.getKey()});
            prov.m_206424_(BiomeTags.f_207604_).m_211101_(new ResourceKey[]{BEACH.getKey()});
            prov.m_206424_(BiomeTags.f_207605_).m_211101_(new ResourceKey[]{RIVER.getKey()});
            prov.m_206424_(BiomeTags.f_207608_).m_211101_(new ResourceKey[]{TROPICAL_PEAKS.getKey()});
            prov.m_206424_(BiomeTags.f_207610_).m_211101_(new ResourceKey[]{RAINFOREST.getKey(), OSA_RAINFOREST.getKey(), BAMBOO_RAINFOREST.getKey()});
            prov.m_206424_(BiomeTags.f_215803_).m_211101_(new ResourceKey[]{MANGROVES.getKey(), OVERGROWN_MANGROVES.getKey()});
            prov.m_206424_(TropicraftTags.Biomes.HAS_HOME_TREE).m_211101_(new ResourceKey[]{RAINFOREST.getKey(), BAMBOO_RAINFOREST.getKey(), OSA_RAINFOREST.getKey()});
            prov.m_206424_(TropicraftTags.Biomes.HAS_KOA_VILLAGE).m_211101_(new ResourceKey[]{BEACH.getKey()});
            prov.m_206424_(TropicraftTags.Biomes.HAS_LAND_VOLCANO).m_211101_(new ResourceKey[]{TROPICS.getKey(), RAINFOREST.getKey()});
            prov.m_206424_(TropicraftTags.Biomes.HAS_OCEAN_VOLCANO).m_211101_(new ResourceKey[]{OCEAN.getKey()});
        });
    }
}

