/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome.simulate;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;
import net.tropicraft.core.common.dimension.biome.TropicraftBiomeBuilder;
import net.tropicraft.core.common.dimension.biome.simulate.NoiseSimulationHelper;

public class BiomeSimulator {
    private static final Map<ResourceKey<Biome>, Integer> COLORS = new HashMap<ResourceKey<Biome>, Integer>();

    private static ResourceKey<Biome> biomeKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("tropicraft", name));
    }

    public static void main(String[] args) {
        long seed = new Random(101L).nextLong();
        BiomeSimulator.init(new NoiseSimulationHelper(seed));
    }

    public static void init(NoiseSimulationHelper sampler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        new TropicraftBiomeBuilder().addBiomes((point, biome) -> builder.add((Object)Pair.of((Object)point, (Object)biome.getKey())));
        Climate.ParameterList params = new Climate.ParameterList((List)builder.build());
        int size = 1024;
        boolean generateTerrainData = true;
        int size8 = size / 8;
        BufferedImage biomeMap = new BufferedImage(size, size, 1);
        BufferedImage baseDepthMap = new BufferedImage(size, size, 1);
        BufferedImage biomeDepth = new BufferedImage(size, size, 1);
        BufferedImage biomeScale = new BufferedImage(size, size, 1);
        BufferedImage biomePeaks = new BufferedImage(size, size, 1);
        Reference2IntOpenHashMap map = new Reference2IntOpenHashMap();
        map.defaultReturnValue(0);
        for (int x = 0; x < size; ++x) {
            if (x % size8 == 0) {
                System.out.println("Mapping... " + (double)(x / size8) / 8.0 * 100.0 + "%");
            }
            for (int z = 0; z < size; ++z) {
                int y = 40;
                ResourceKey value = (ResourceKey)params.m_204252_(sampler.sample(x, y, z));
                if (!COLORS.containsKey(value)) {
                    throw new RuntimeException("Resource key not found: " + value);
                }
                map.addTo((Object)value, 1);
                biomeMap.setRGB(x, z, COLORS.getOrDefault(value, 0));
                if (!generateTerrainData) continue;
                int prelimSurface = sampler.prelimSurfaceLevel(x, z);
                int o = (int)Mth.m_144851_((double)sampler.offset(x, 40, z), (double)-0.3, (double)1.2, (double)0.0, (double)255.0);
                int f = (int)(sampler.factor(x, 40, z) * 35.0f);
                int pv = (int)(sampler.peaksAndValleys(x, y, z) * 127.0) + 128;
                baseDepthMap.setRGB(x, z, BiomeSimulator.getIntFromColor(prelimSurface, prelimSurface, prelimSurface));
                biomeDepth.setRGB(x, z, BiomeSimulator.getIntFromColor(o, o, o));
                biomeScale.setRGB(x, z, BiomeSimulator.getIntFromColor(f, f, f));
                biomePeaks.setRGB(x, z, BiomeSimulator.getIntFromColor(pv, pv, pv));
            }
        }
        for (Reference2IntMap.Entry entry : map.reference2IntEntrySet()) {
            System.out.println(((ResourceKey)entry.getKey()).m_135782_() + ": " + (double)entry.getIntValue() / ((double)size * (double)size) * 100.0 + "%");
        }
        Path p = Paths.get(".", "run");
        try {
            ImageIO.write((RenderedImage)biomeMap, "png", p.resolve("biomes.png").toAbsolutePath().toFile());
            if (generateTerrainData) {
                ImageIO.write((RenderedImage)baseDepthMap, "png", p.resolve("basedepth.png").toAbsolutePath().toFile());
                ImageIO.write((RenderedImage)biomeDepth, "png", p.resolve("biomedepth.png").toAbsolutePath().toFile());
                ImageIO.write((RenderedImage)biomeScale, "png", p.resolve("biomescale.png").toAbsolutePath().toFile());
                ImageIO.write((RenderedImage)biomePeaks, "png", p.resolve("biomepeaks.png").toAbsolutePath().toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getIntFromColor(int red, int green, int blue) {
        red = Mth.m_14045_((int)red, (int)0, (int)255);
        green = Mth.m_14045_((int)green, (int)0, (int)255);
        blue = Mth.m_14045_((int)blue, (int)0, (int)255);
        red = red << 16 & 0xFF0000;
        green = green << 8 & 0xFF00;
        return 0xFF000000 | red | green | (blue &= 0xFF);
    }

    static {
        SharedConstants.m_142977_();
        Bootstrap.m_135870_();
        COLORS.put(BiomeSimulator.biomeKey("ocean"), 5172447);
        COLORS.put(BiomeSimulator.biomeKey("river"), 5172447);
        COLORS.put(BiomeSimulator.biomeKey("beach"), 16440917);
        COLORS.put(BiomeSimulator.biomeKey("rainforest"), 353825);
        COLORS.put(BiomeSimulator.biomeKey("bamboo_rainforest"), 5751356);
        COLORS.put(BiomeSimulator.biomeKey("osa_rainforest"), 5820749);
        COLORS.put(BiomeSimulator.biomeKey("tropics"), 9286496);
        COLORS.put(BiomeSimulator.biomeKey("mangroves"), 5409360);
        COLORS.put(BiomeSimulator.biomeKey("overgrown_mangroves"), 6129459);
    }
}

