/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.biome.simulate;

import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.tropicraft.core.common.dimension.TropicraftTerrainProvider;
import net.tropicraft.core.common.dimension.noise.TropicraftNoiseGenSettings;

public class NoiseSimulationHelper {
    private static final double PRELIMINARY_SURFACE_THRESHOLD = 0.390625;
    private final NoiseGeneratorSettings noiseGeneratorSettings = TropicraftNoiseGenSettings.createNoise(false);
    private final RandomState randomState;
    private final CubicSpline<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate> offset;
    private final CubicSpline<DensityFunctions.Spline.Point, DensityFunctions.Spline.Coordinate> factor;

    public NoiseSimulationHelper(long seed) {
        RegistryAccess.Writable registries = RegistryAccess.m_206197_();
        this.randomState = RandomState.m_224570_((NoiseGeneratorSettings)this.noiseGeneratorSettings, (Registry)registries.m_175515_(Registry.f_194568_), (long)seed);
        this.offset = TropicraftTerrainProvider.offset(NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209451_), NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209452_), NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_224429_));
        this.factor = TropicraftTerrainProvider.factor(NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209451_), NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209452_), NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209453_), NoiseSimulationHelper.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_224429_));
    }

    private static DensityFunctions.Spline.Coordinate splineCoordinate(ResourceKey<DensityFunction> key) {
        return new DensityFunctions.Spline.Coordinate(BuiltinRegistries.f_211085_.m_206081_(key));
    }

    public Climate.TargetPoint sample(int x, int y, int z) {
        return this.randomState.m_224579_().m_183445_(x, y, z);
    }

    public float offset(int x, int y, int z) {
        return this.offset.m_183321_((Object)new DensityFunctions.Spline.Point((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z)));
    }

    public float factor(int x, int y, int z) {
        return this.factor.m_183321_((Object)new DensityFunctions.Spline.Point((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z)));
    }

    public double peaksAndValleys(int x, int y, int z) {
        return TropicraftTerrainProvider.peaksAndValleys((float)this.randomState.m_224579_().f_207850_().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z)));
    }

    public int prelimSurfaceLevel(int x, int z) {
        NoiseSettings settings = this.noiseGeneratorSettings.f_64439_();
        int minY = settings.f_158688_();
        for (int y = minY + settings.f_64508_(); y >= minY; y -= settings.m_189212_()) {
            DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(x, y, z);
            if (!(this.randomState.m_224578_().f_209390_().m_207386_((DensityFunction.FunctionContext)singlePointContext) > 0.390625)) continue;
            return y;
        }
        return Integer.MAX_VALUE;
    }
}

