/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.tropicraft.core.common.dimension.feature.SimpleTreeFeatureConfig;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class SingleUndergrowthFeature
extends Feature<SimpleTreeFeatureConfig> {
    private static final int LARGE_BUSH_CHANCE = 4;

    public SingleUndergrowthFeature(Codec<SimpleTreeFeatureConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<SimpleTreeFeatureConfig> context) {
        int size;
        WorldGenLevel level = context.m_159774_();
        context.m_159775_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        SimpleTreeFeatureConfig config = (SimpleTreeFeatureConfig)context.m_159778_();
        int n = size = rand.m_188503_(4) == 0 ? 3 : 2;
        if (!this.isValidPosition((LevelSimulatedReader)level, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(level, pos.m_123342_(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)level, pos.m_7495_())) {
            return false;
        }
        level.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
        int count = 0;
        if (this.isValidPosition((LevelSimulatedReader)level, pos) && pos.m_123342_() < level.m_151558_() - 1) {
            for (int y = pos.m_123342_(); y < pos.m_123342_() + size; ++y) {
                int bushWidth = size - (y - pos.m_123342_());
                for (int x = pos.m_123341_() - bushWidth; x < pos.m_123341_() + bushWidth; ++x) {
                    int xVariance = x - pos.m_123341_();
                    for (int z = pos.m_123343_() - bushWidth; z < pos.m_123343_() + bushWidth; ++z) {
                        int zVariance = z - pos.m_123343_();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.m_188503_(2) == 0 || !this.isValidPosition((LevelSimulatedReader)level, newPos)) continue;
                        this.m_5974_((LevelWriter)level, newPos, config.leaves().get());
                    }
                }
            }
            ++count;
        }
        this.m_5974_((LevelWriter)level, pos, config.log().get());
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(LevelSimulatedReader level, BlockPos pos) {
        if (!TreeFeature.m_67267_((LevelSimulatedReader)level, (BlockPos)pos)) return false;
        if (level.m_7433_(pos, Blocks.f_50627_.m_49966_()::equals)) return false;
        return true;
    }
}

