/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import java.util.List;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatures;
import net.tropicraft.core.common.dimension.feature.TropicraftMiscFeatures;

public final class TropicraftMiscPlacements {
    public static final TropicraftFeatures.Register REGISTER = TropicraftFeatures.Register.create();
    public static final RegistryObject<PlacedFeature> MUD_DISK = REGISTER.placed("mud_disk", TropicraftMiscFeatures.MUD_DISK, () -> List.of(CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195353_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> EIH = REGISTER.placed("eih", TropicraftMiscFeatures.EIH, () -> List.of(PlacementUtils.m_195364_((int)0, (float)0.0025f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()));
    public static final RegistryObject<PlacedFeature> AZURITE = REGISTER.placed("azurite", TropicraftMiscFeatures.AZURITE, () -> REGISTER.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-20), (VerticalAnchor)VerticalAnchor.m_158935_((int)80))));
    public static final RegistryObject<PlacedFeature> EUDIALYTE = REGISTER.placed("eudialyte", TropicraftMiscFeatures.EUDIALYTE, () -> REGISTER.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-20), (VerticalAnchor)VerticalAnchor.m_158935_((int)80))));
    public static final RegistryObject<PlacedFeature> ZIRCON = REGISTER.placed("zircon", TropicraftMiscFeatures.ZIRCON, () -> REGISTER.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158930_((int)-20), (VerticalAnchor)VerticalAnchor.m_158935_((int)80))));
    public static final RegistryObject<PlacedFeature> MANGANESE = REGISTER.placed("manganese", TropicraftMiscFeatures.MANGANESE, () -> REGISTER.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158935_((int)32))));
    public static final RegistryObject<PlacedFeature> SHAKA = REGISTER.placed("shaka", TropicraftMiscFeatures.SHAKA, () -> REGISTER.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158935_((int)32))));

    public static void addMudDisks(BiomeGenerationSettings.Builder generation) {
        TropicraftMiscPlacements.addFeature(generation, GenerationStep.Decoration.UNDERGROUND_ORES, MUD_DISK);
    }

    public static void addEih(BiomeGenerationSettings.Builder generation) {
        TropicraftMiscPlacements.addFeature(generation, GenerationStep.Decoration.VEGETAL_DECORATION, EIH);
    }

    public static void addTropicsGems(BiomeGenerationSettings.Builder generation) {
        TropicraftMiscPlacements.addOres(generation, AZURITE);
        TropicraftMiscPlacements.addOres(generation, EUDIALYTE);
        TropicraftMiscPlacements.addOres(generation, ZIRCON);
    }

    public static void addTropicsMetals(BiomeGenerationSettings.Builder generation) {
        TropicraftMiscPlacements.addOres(generation, MANGANESE);
        TropicraftMiscPlacements.addOres(generation, SHAKA);
    }

    private static void addOres(BiomeGenerationSettings.Builder generation, RegistryObject<PlacedFeature> feature) {
        TropicraftMiscPlacements.addFeature(generation, GenerationStep.Decoration.UNDERGROUND_ORES, feature);
    }

    private static void addFeature(BiomeGenerationSettings.Builder generation, GenerationStep.Decoration step, RegistryObject<PlacedFeature> feature) {
        generation.m_204201_(step, TropicraftFeatures.holderOf(feature));
    }
}

