/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.TropicraftFeatureUtil;

public class UndergrowthFeature
extends Feature<NoneFeatureConfiguration> {
    private static final int LARGE_BUSH_CHANCE = 5;

    public UndergrowthFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_();
        int size = 2;
        if (rand.m_188503_(5) == 0) {
            size = 3;
        }
        if (!this.isValidPosition((LevelSimulatedRW)world, pos)) {
            return false;
        }
        if (TropicraftFeatureUtil.goesBeyondWorldSize(world, pos.m_123342_(), size)) {
            return false;
        }
        if (!TropicraftFeatureUtil.isSoil((LevelAccessor)world, pos.m_7495_())) {
            return false;
        }
        world.m_7731_(pos.m_7495_(), Blocks.f_50493_.m_49966_(), 3);
        this.m_5974_((LevelWriter)world, pos, ((RotatedPillarBlock)TropicraftBlocks.MAHOGANY_LOG.get()).m_49966_());
        int count = 0;
        for (int round = 0; round < 64; ++round) {
            BlockPos posTemp = pos.m_7918_(rand.m_188503_(8) - rand.m_188503_(8), rand.m_188503_(4) - rand.m_188503_(4), rand.m_188503_(8) - rand.m_188503_(8));
            if (!this.isValidPosition((LevelSimulatedRW)world, posTemp) || posTemp.m_123342_() >= 255) continue;
            for (int y = posTemp.m_123342_(); y < posTemp.m_123342_() + size; ++y) {
                int bushWidth = size - (y - posTemp.m_123342_());
                for (int x = posTemp.m_123341_() - bushWidth; x < posTemp.m_123341_() + bushWidth; ++x) {
                    int xVariance = x - posTemp.m_123341_();
                    for (int z = posTemp.m_123343_() - bushWidth; z < posTemp.m_123343_() + bushWidth; ++z) {
                        int zVariance = z - posTemp.m_123343_();
                        BlockPos newPos = new BlockPos(x, y, z);
                        if (Math.abs(xVariance) == bushWidth && Math.abs(zVariance) == bushWidth && rand.m_188503_(2) == 0 || !this.isValidPosition((LevelSimulatedRW)world, newPos)) continue;
                        this.m_5974_((LevelWriter)world, newPos, ((LeavesBlock)TropicraftBlocks.KAPOK_LEAVES.get()).m_49966_());
                    }
                }
            }
            ++count;
        }
        return count > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isValidPosition(LevelSimulatedRW world, BlockPos pos) {
        if (!TreeFeature.m_67267_((LevelSimulatedReader)world, (BlockPos)pos)) return false;
        if (world.m_7433_(pos, Blocks.f_50627_.m_49966_()::equals)) return false;
        return true;
    }
}

