/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.jigsaw;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.tropicraft.core.common.block.TropicraftBlocks;
import net.tropicraft.core.common.dimension.feature.jigsaw.PathStructureProcessor;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorTypes;

public class SteepPathProcessor
extends PathStructureProcessor {
    public static final Codec<SteepPathProcessor> CODEC = Codec.unit((Object)((Object)new SteepPathProcessor()));

    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos seedPos, BlockPos pos2, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo blockInfo, StructurePlaceSettings placementSettingsIn, StructureTemplate template) {
        BlockPos pos = blockInfo.f_74675_;
        if (originalBlockInfo.f_74675_.m_123342_() != 1 || originalBlockInfo.f_74676_.m_60734_() == TropicraftBlocks.BAMBOO_STAIRS.get() || originalBlockInfo.f_74676_.m_60795_()) {
            return blockInfo;
        }
        Direction.Axis axis = this.getPathDirection(level, seedPos, blockInfo, placementSettingsIn, template);
        if (axis == null) {
            return blockInfo;
        }
        int bridgeTo = -1;
        BlockState ladder = null;
        for (Direction.AxisDirection axisDir : Direction.AxisDirection.values()) {
            Direction dir = Direction.m_122390_((Direction.AxisDirection)axisDir, (Direction.Axis)axis);
            BlockPos nextHeight = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_121945_(dir)).m_7495_();
            if (nextHeight.m_123342_() > pos.m_123342_()) {
                ladder = this.getLadderState(dir);
                bridgeTo = nextHeight.m_123342_();
            }
            if (ladder != null) break;
        }
        if (ladder == null) {
            return blockInfo;
        }
        Direction dir = ((Direction)ladder.m_61143_((Property)LadderBlock.f_54337_)).m_122424_();
        if (bridgeTo == (pos = pos.m_7494_()).m_123342_() && this.canPlaceLadderAt(level, pos.m_7494_(), dir) == null) {
            if (pos.m_123342_() > 127) {
                this.setBlockState(level, pos, (BlockState)((StairBlock)TropicraftBlocks.THATCH_STAIRS.get()).m_49966_().m_61124_((Property)StairBlock.f_56841_, (Comparable)dir));
            }
        } else {
            while (bridgeTo >= pos.m_123342_() || this.canPlaceLadderAt(level, pos, dir) != null) {
                this.setBlockState(level, pos, ladder);
                this.setBlockState(level, pos.m_121945_(dir), ((RotatedPillarBlock)TropicraftBlocks.THATCH_BUNDLE.get()).m_49966_());
                pos = pos.m_7494_();
            }
        }
        return blockInfo;
    }

    private BlockState canPlaceLadderAt(LevelReader level, BlockPos pos, Direction dir) {
        BlockState ladderState;
        BlockPos check = pos.m_121945_(dir);
        BlockState state = level.m_8055_(check);
        if (!state.m_60795_() && (ladderState = this.getLadderState(dir)).m_60710_(level, pos)) {
            return ladderState;
        }
        return null;
    }

    private BlockState getLadderState(Direction dir) {
        return (BlockState)((LadderBlock)TropicraftBlocks.BAMBOO_LADDER.get()).m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)dir.m_122424_());
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)TropicraftProcessorTypes.STEEP_PATH.get();
    }
}

