/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.pools;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.feature.jigsaw.TropicraftProcessorLists;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.HomeTreeBranchPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.NoRotateSingleJigsawPiece;
import net.tropicraft.core.common.dimension.feature.jigsaw.piece.SingleNoAirJigsawPiece;

public final class TropicraftTemplatePools {
    public static final DeferredRegister<StructureTemplatePool> REGISTER = DeferredRegister.create((ResourceKey)Registry.f_122884_, (String)"tropicraft");
    public static final RegistryObject<StructureTemplatePool> KOA_TOWN_CENTERS = TropicraftTemplatePools.register("koa_village/town_centers", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/town_centers/firepit_01", TropicraftProcessorLists.KOA_TOWN_CENTERS, 1));
    public static final RegistryObject<StructureTemplatePool> KOA_HUTS = TropicraftTemplatePools.register("koa_village/huts", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_01", TropicraftProcessorLists.KOA_BUILDINGS, 5), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_02", TropicraftProcessorLists.KOA_BUILDINGS, 2), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_03", TropicraftProcessorLists.KOA_BUILDINGS, 3), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_04", TropicraftProcessorLists.KOA_BUILDINGS, 4), TropicraftTemplatePools.noAirSingle("koa_village/huts/hut_05", TropicraftProcessorLists.KOA_BUILDINGS, 10), TropicraftTemplatePools.noAirSingle("koa_village/huts/bongo_hut_01", TropicraftProcessorLists.KOA_BUILDINGS, 2), TropicraftTemplatePools.noAirSingle("koa_village/huts/trade_hut_01", TropicraftProcessorLists.KOA_BUILDINGS, 2));
    public static final RegistryObject<StructureTemplatePool> KOA_STREETS = TropicraftTemplatePools.register("koa_village/streets", new ResourceLocation("tropicraft", "koa_village/terminators"), StructureTemplatePool.Projection.TERRAIN_MATCHING, TropicraftTemplatePools.koaPath("koa_village/streets/straight_01", 3), TropicraftTemplatePools.koaPath("koa_village/streets/straight_02", 4), TropicraftTemplatePools.koaPath("koa_village/streets/straight_03", 10), TropicraftTemplatePools.koaPath("koa_village/streets/straight_04", 2), TropicraftTemplatePools.koaPath("koa_village/streets/straight_05", 3), TropicraftTemplatePools.koaPath("koa_village/streets/straight_06", 2), TropicraftTemplatePools.koaPath("koa_village/streets/corner_01", 2), TropicraftTemplatePools.koaPath("koa_village/streets/corner_02", 4), TropicraftTemplatePools.koaPath("koa_village/streets/corner_03", 6), TropicraftTemplatePools.koaPath("koa_village/streets/corner_04", 2), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_01", 5), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_02", 2), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_03", 1), TropicraftTemplatePools.koaPath("koa_village/streets/crossroad_04", 2));
    public static final RegistryObject<StructureTemplatePool> KOA_TERMINATORS = TropicraftTemplatePools.register("koa_village/terminators", StructureTemplatePool.Projection.TERRAIN_MATCHING, TropicraftTemplatePools.koaPath("koa_village/terminators/terminator_01", 1));
    public static final RegistryObject<StructureTemplatePool> KOA_VILLAGERS = TropicraftTemplatePools.register("koa_village/villagers", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/villagers/unemployed", 1));
    public static final RegistryObject<StructureTemplatePool> KOA_FISH = TropicraftTemplatePools.register("koa_village/fish", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noAirSingle("koa_village/fish/fish_01", 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_STARTS = TropicraftTemplatePools.register("home_tree/starts", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/trunks/bottom/trunk_0", TropicraftProcessorLists.HOME_TREE_START, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/bottom/trunk_1", TropicraftProcessorLists.HOME_TREE_START, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_ROOFS = TropicraftTemplatePools.register("home_tree/roofs", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/roofs/roof_0", TropicraftProcessorLists.HOME_TREE_BASE, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_DUMMY = TropicraftTemplatePools.register("home_tree/dummy", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/dummy", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.singlePiece("home_tree/outer_dummy", TropicraftProcessorLists.HOME_TREE_BASE, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_TRUNK_MIDDLE = TropicraftTemplatePools.register("home_tree/trunks/middle", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_0", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_1", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_1_iguanas", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.singlePiece("home_tree/trunks/middle/trunk_1_ashen", TropicraftProcessorLists.HOME_TREE_BASE, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_TRUNK_TOP = TropicraftTemplatePools.register("home_tree/trunks/top", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_0", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_1", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_2", TropicraftProcessorLists.HOME_TREE_BASE, 1), TropicraftTemplatePools.noRotateSingle("home_tree/trunks/top/trunk_3", TropicraftProcessorLists.HOME_TREE_BASE, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_SOUTH = TropicraftTemplatePools.register("home_tree/branches/south", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(-30.0f, 30.0f, 4), TropicraftTemplatePools.homeTreeBranch(0.0f, 0.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_SOUTH_EAST = TropicraftTemplatePools.register("home_tree/branches/southeast", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(30.0f, 60.0f, 4), TropicraftTemplatePools.homeTreeBranch(45.0f, 45.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_EAST = TropicraftTemplatePools.register("home_tree/branches/east", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(60.0f, 120.0f, 4), TropicraftTemplatePools.homeTreeBranch(90.0f, 90.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_NORTH_EAST = TropicraftTemplatePools.register("home_tree/branches/northeast", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(120.0f, 150.0f, 4), TropicraftTemplatePools.homeTreeBranch(135.0f, 135.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_NORTH = TropicraftTemplatePools.register("home_tree/branches/north", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(150.0f, 210.0f, 4), TropicraftTemplatePools.homeTreeBranch(180.0f, 180.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_NORTH_WEST = TropicraftTemplatePools.register("home_tree/branches/northwest", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(210.0f, 240.0f, 4), TropicraftTemplatePools.homeTreeBranch(225.0f, 225.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_WEST = TropicraftTemplatePools.register("home_tree/branches/west", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(240.0f, 300.0f, 4), TropicraftTemplatePools.homeTreeBranch(270.0f, 270.0f, 1));
    public static final RegistryObject<StructureTemplatePool> HOME_TREE_BRANCHES_SOUTH_WEST = TropicraftTemplatePools.register("home_tree/branches/southwest", StructureTemplatePool.Projection.RIGID, TropicraftTemplatePools.homeTreeBranch(300.0f, 330.0f, 4), TropicraftTemplatePools.homeTreeBranch(315.0f, 315.0f, 1));

    private static WeightedPiece singlePiece(String path, RegistryObject<StructureProcessorList> processors, int weight) {
        return new WeightedPiece(() -> StructurePoolElement.m_210531_((String)("tropicraft:" + path), (Holder)((Holder)processors.getHolder().orElseThrow())), weight);
    }

    private static WeightedPiece singlePiece(String path, int weight) {
        return new WeightedPiece(() -> StructurePoolElement.m_210526_((String)("tropicraft:" + path)), weight);
    }

    private static WeightedPiece noAirSingle(String path, RegistryObject<StructureProcessorList> processors, int weight) {
        return new WeightedPiece(() -> SingleNoAirJigsawPiece.create("tropicraft:" + path, (Holder<StructureProcessorList>)((Holder)processors.getHolder().orElseThrow()), false), weight);
    }

    private static WeightedPiece noAirSingle(String path, int weight) {
        return new WeightedPiece(() -> SingleNoAirJigsawPiece.create("tropicraft:" + path), weight);
    }

    private static WeightedPiece noRotateSingle(String path, RegistryObject<StructureProcessorList> processors, int weight) {
        return new WeightedPiece(() -> NoRotateSingleJigsawPiece.createNoRotate("tropicraft:" + path, (Holder<StructureProcessorList>)((Holder)processors.getHolder().orElseThrow())), weight);
    }

    private static WeightedPiece feature(Holder<PlacedFeature> feature, int weight) {
        return new WeightedPiece(() -> StructurePoolElement.m_210502_((Holder)feature), weight);
    }

    private static WeightedPiece homeTreeBranch(float minAngle, float maxAngle, int weight) {
        return new WeightedPiece(() -> HomeTreeBranchPiece.create(minAngle, maxAngle), weight);
    }

    private static WeightedPiece koaPath(String path, int weight) {
        return new WeightedPiece(() -> SingleNoAirJigsawPiece.create("tropicraft:" + path, (Holder<StructureProcessorList>)((Holder)TropicraftProcessorLists.KOA_PATH.getHolder().orElseThrow()), true), weight);
    }

    private static RegistryObject<StructureTemplatePool> register(String name, StructureTemplatePool.Projection placementBehaviour, WeightedPiece ... pieces) {
        return TropicraftTemplatePools.register(name, new ResourceLocation("empty"), placementBehaviour, pieces);
    }

    private static RegistryObject<StructureTemplatePool> register(String name, ResourceLocation fallback, StructureTemplatePool.Projection placementBehaviour, WeightedPiece ... pieces) {
        ResourceLocation id = new ResourceLocation("tropicraft", name);
        return REGISTER.register(name, () -> new StructureTemplatePool(id, fallback, Arrays.stream(pieces).map(WeightedPiece::resolve).toList(), placementBehaviour));
    }

    private record WeightedPiece(Supplier<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>> factory, int weight) {
        public Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> resolve() {
            return new Pair(this.factory.get(), (Object)this.weight);
        }
    }
}

