/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayFIFOQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.block.MangroveRootsBlock;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public final class MangroveTrunkPlacer
extends FancyTrunkPlacer {
    public static final Codec<MangroveTrunkPlacer> CODEC = RecordCodecBuilder.create(i -> MangroveTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)i).and(i.group((App)BlockStateProvider.f_68747_.fieldOf("roots_block").forGetter(c -> c.rootsBlock), (App)Codec.BOOL.fieldOf("can_generate_raised").forGetter(c -> c.canGenerateRaised), (App)Codec.BOOL.fieldOf("tea_mangrove").forGetter(c -> c.teaMangrove))).apply((Applicative)i, MangroveTrunkPlacer::new));
    private static final int MIN_LENGTH = 2;
    private static final int MAX_LENGTH = 4;
    private static final int MAX_RADIUS = 4;
    private static final int MAX_SIZE = 9;
    private final BlockStateProvider rootsBlock;
    private final boolean canGenerateRaised;
    private final boolean teaMangrove;

    public MangroveTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, BlockStateProvider rootsBlock, boolean canGenerateRaised, boolean teaMangrove) {
        super(baseHeight, heightRandA, heightRandB);
        this.rootsBlock = rootsBlock;
        this.canGenerateRaised = canGenerateRaised;
        this.teaMangrove = teaMangrove;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TropicraftTrunkPlacers.MANGROVE.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> acceptor, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        int waterDepth;
        int rootLength = Mth.m_14045_((int)(height - 5), (int)2, (int)4);
        boolean placeDirtOnOrigin = world.m_7433_(origin.m_7495_(), b -> b.m_60713_(Blocks.f_50440_));
        if (this.canGenerateRaised && (waterDepth = this.getWaterDepthAbove(world, origin, 3)) <= 2 && random.m_188503_(2) == 0) {
            int surfaceY = origin.m_123342_() + waterDepth;
            origin = new BlockPos(origin.m_123341_(), surfaceY + 1, origin.m_123343_());
            placeDirtOnOrigin = false;
        }
        RootSystem roots = new RootSystem();
        if (this.teaMangrove) {
            this.growTeaRoots(roots, rootLength);
        } else {
            this.growRoots(roots, random, rootLength);
        }
        this.placeRoots((LevelSimulatedRW)world, origin, rootLength, roots, random);
        if (placeDirtOnOrigin) {
            MangroveTrunkPlacer.m_226169_((LevelSimulatedReader)world, acceptor, (RandomSource)random, (BlockPos)origin.m_7495_(), (TreeConfiguration)config);
        }
        for (int i = 0; i < height; ++i) {
            this.m_226187_(world, acceptor, random, origin.m_6630_(i), config);
        }
        ArrayList<FoliagePlacer.FoliageAttachment> leafNodes = new ArrayList<FoliagePlacer.FoliageAttachment>();
        leafNodes.add(new FoliagePlacer.FoliageAttachment(origin.m_6630_(height), 1, false));
        this.growBranches((LevelSimulatedRW)world, acceptor, random, height, origin, config, leafNodes);
        return leafNodes;
    }

    private int getWaterDepthAbove(LevelSimulatedReader world, BlockPos origin, int maxDepth) {
        int depth;
        BlockPos.MutableBlockPos pos = origin.m_122032_();
        for (depth = 0; depth <= maxDepth; ++depth) {
            pos.m_142448_(origin.m_123342_() + depth);
            if (!MangroveTrunkPlacer.isWaterAt(world, (BlockPos)pos)) break;
        }
        return depth;
    }

    private void growBranches(LevelSimulatedRW world, BiConsumer<BlockPos, BlockState> acceptor, RandomSource random, int height, BlockPos origin, TreeConfiguration config, List<FoliagePlacer.FoliageAttachment> leafNodes) {
        int count = 2 + random.m_188503_(3);
        Direction lastDirection = null;
        block0: for (int i = 0; i < count; ++i) {
            Direction direction;
            BlockPos base = origin.m_6630_(height - count + i);
            int length = 1 + random.m_188503_(2);
            boolean hasBranch = false;
            while ((direction = Direction.Plane.HORIZONTAL.m_235690_(random)) == lastDirection) {
            }
            lastDirection = direction;
            for (int j = 1; j <= length + 1; ++j) {
                if (j == length) {
                    this.m_226187_((LevelSimulatedReader)world, acceptor, random, base.m_5484_(direction, j).m_7494_(), config);
                    leafNodes.add(new FoliagePlacer.FoliageAttachment(base.m_5484_(direction, j).m_7494_(), random.m_188503_(2), false));
                    continue block0;
                }
                if (!hasBranch && random.m_188499_()) {
                    hasBranch = true;
                    Direction branchBranchDir = random.m_188499_() ? direction.m_122427_() : direction.m_122428_();
                    this.m_226187_((LevelSimulatedReader)world, acceptor, random, base.m_5484_(direction, j).m_121945_(branchBranchDir), config);
                    leafNodes.add(new FoliagePlacer.FoliageAttachment(base.m_5484_(direction, j).m_121945_(branchBranchDir), 0, false));
                }
                this.m_226187_((LevelSimulatedReader)world, acceptor, random, base.m_5484_(direction, j), config);
            }
        }
    }

    private void growRoots(RootSystem roots, RandomSource random, int length) {
        RootGrower grower = new RootGrower(roots);
        grower.growAt(RootSystem.pos(-1, 0), RootSystem.seed(Direction.WEST));
        grower.growAt(RootSystem.pos(1, 0), RootSystem.seed(Direction.EAST));
        grower.growAt(RootSystem.pos(0, -1), RootSystem.seed(Direction.NORTH));
        grower.growAt(RootSystem.pos(0, 1), RootSystem.seed(Direction.SOUTH));
        while (grower.hasNext()) {
            int pos = grower.nextPos();
            int root = roots.get(pos);
            int distance = RootSystem.distance(root);
            if (distance >= length || random.m_188503_(8) == 0) continue;
            Direction side = RootSystem.side(root);
            Direction flow = RootSystem.flow(root);
            if (random.m_188503_((length - distance >> 1) + 1) == 0) {
                if (distance <= 1 || random.m_188499_()) {
                    grower.growOut(pos, distance, side, flow);
                }
                grower.growOut(pos, distance, side, MangroveTrunkPlacer.nextFlow(random, flow));
                continue;
            }
            grower.growOut(pos, distance, side, flow);
        }
    }

    private static Direction nextFlow(RandomSource random, Direction side) {
        return switch (random.m_188503_(3)) {
            case 0 -> side.m_122427_();
            case 1 -> side.m_122428_();
            default -> side;
        };
    }

    private void growTeaRoots(RootSystem roots, int length) {
        int radius = length / 2;
        for (int z = -radius; z <= radius; ++z) {
            for (int x = -radius; x <= radius; ++x) {
                if (x == 0 && z == 0) continue;
                int distance = (Math.abs(x) + Math.abs(z) - 1) * 2;
                roots.set(RootSystem.pos(x, z), RootSystem.root(distance));
            }
        }
    }

    private void placeRoots(LevelSimulatedRW world, BlockPos origin, int rootLength, RootSystem roots, RandomSource random) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (int z = -4; z <= 4; ++z) {
            for (int x = -4; x <= 4; ++x) {
                int root = roots.get(RootSystem.pos(x, z));
                if (root == 0) continue;
                mutablePos.m_122178_(origin.m_123341_() + x, 0, origin.m_123343_() + z);
                int rootHeight = rootLength - RootSystem.distance(root);
                if (rootHeight <= 0) continue;
                int maxY = origin.m_123342_() + rootHeight;
                int minY = maxY - 8;
                int y = maxY;
                while (y >= minY) {
                    mutablePos.m_142448_(y--);
                    if (this.setRootsAt(world, (BlockPos)mutablePos, random)) continue;
                }
            }
        }
    }

    private boolean setRootsAt(LevelSimulatedRW world, BlockPos pos, RandomSource random) {
        return MangroveTrunkPlacer.setRootsAt(world, pos, this.rootsBlock.m_213972_(random, pos));
    }

    public static boolean setRootsAt(LevelSimulatedRW world, BlockPos pos, BlockState rootsBlock) {
        if (MangroveTrunkPlacer.isReplaceableAt((LevelSimulatedReader)world, pos)) {
            BlockState state = (BlockState)rootsBlock.m_61124_((Property)MangroveRootsBlock.WATERLOGGED, (Comparable)Boolean.valueOf(MangroveTrunkPlacer.isWaterAt((LevelSimulatedReader)world, pos)));
            world.m_7731_(pos, state, 19);
            return true;
        }
        return false;
    }

    public static boolean isReplaceableAt(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60795_() || state.m_204336_(BlockTags.f_13035_) || state.m_60767_() == Material.f_76302_ || state.m_60767_() == Material.f_76304_ || state.m_60767_() == Material.f_76300_ || state.m_60713_(Blocks.f_49990_) || state.m_204336_(TropicraftTags.Blocks.ROOTS));
    }

    public static boolean isWaterAt(LevelSimulatedReader world, BlockPos pos) {
        return world.m_7433_(pos, state -> state.m_60819_().m_76152_() == Fluids.f_76193_);
    }

    static final class RootSystem {
        static final int NULL = 0;
        private final int[] map = new int[81];

        RootSystem() {
        }

        boolean set(int pos, int root) {
            if (!this.contains(pos)) {
                this.map[pos] = root;
                return true;
            }
            return false;
        }

        int get(int pos) {
            return this.map[pos];
        }

        boolean contains(int pos) {
            return this.get(pos) != 0;
        }

        static int pos(int x, int z) {
            return x + 4 + (z + 4) * 9;
        }

        static int offsetPos(int pos, int x, int z) {
            return pos + x + z * 9;
        }

        static int seed(Direction side) {
            return RootSystem.root(1, side, side);
        }

        static int root(int distance, Direction side, Direction flow) {
            return RootSystem.root(distance) | side.m_122416_() << 3 | flow.m_122416_() << 1;
        }

        static int root(int distance) {
            return distance << 5 | 1;
        }

        static int distance(int root) {
            return root >> 5;
        }

        static Direction side(int root) {
            return Direction.m_122407_((int)(root >> 3 & 3));
        }

        static Direction flow(int root) {
            return Direction.m_122407_((int)(root >> 1 & 3));
        }
    }

    static final class RootGrower {
        private final RootSystem roots;
        private final IntArrayFIFOQueue queue = new IntArrayFIFOQueue();

        RootGrower(RootSystem roots) {
            this.roots = roots;
        }

        boolean hasNext() {
            return !this.queue.isEmpty();
        }

        int nextPos() {
            return this.queue.dequeueInt();
        }

        void growOut(int pos, int distance, Direction side, Direction flow) {
            int growPos = RootSystem.offsetPos(pos, flow.m_122429_(), flow.m_122431_());
            this.growAt(growPos, RootSystem.root(distance + 1, side, flow));
        }

        void growAt(int pos, int root) {
            if (this.roots.set(pos, root)) {
                this.queue.enqueue(pos);
            }
        }
    }
}

