/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.tree.mangrove;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedRW;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.tropicraft.core.common.dimension.feature.tree.TropicraftTrunkPlacers;

public class SmallMangroveTrunkPlacer
extends TrunkPlacer {
    public static final Codec<SmallMangroveTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> SmallMangroveTrunkPlacer.m_70305_((RecordCodecBuilder.Instance)instance).and((App)Registry.f_122824_.m_194605_().fieldOf("roots_block").forGetter(c -> c.rootsBlock)).apply((Applicative)instance, SmallMangroveTrunkPlacer::new));
    private final Block rootsBlock;

    public SmallMangroveTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, Block rootsBlock) {
        super(baseHeight, heightRandA, heightRandB);
        this.rootsBlock = rootsBlock;
    }

    protected TrunkPlacerType<?> m_7362_() {
        return (TrunkPlacerType)TropicraftTrunkPlacers.SMALL_MANGROVE.get();
    }

    public List<FoliagePlacer.FoliageAttachment> m_213934_(LevelSimulatedReader world, BiConsumer<BlockPos, BlockState> acceptor, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        if (world.m_7433_(origin.m_7495_(), b -> b.m_60713_(Blocks.f_50440_))) {
            SmallMangroveTrunkPlacer.m_226169_((LevelSimulatedReader)world, acceptor, (RandomSource)random, (BlockPos)origin.m_7495_(), (TreeConfiguration)config);
        }
        for (int i = 0; i < height; ++i) {
            this.m_226187_(world, acceptor, random, origin.m_6630_(i), config);
        }
        this.generateRoots((LevelSimulatedRW)world, random, origin, 0);
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(origin.m_6630_(height - 1), 1, false));
    }

    private void generateRoots(LevelSimulatedRW world, RandomSource random, BlockPos origin, int depth) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos offset = origin.m_121945_(direction);
            if (!world.m_7433_(offset, BlockBehaviour.BlockStateBase::m_60795_) || !world.m_7433_(offset.m_7495_(), state -> state.m_60767_().m_76337_())) continue;
            world.m_7731_(offset, this.rootsBlock.m_49966_(), 19);
            if (depth >= 2 || random.m_188503_(depth + 2) != 0) continue;
            this.generateRoots(world, random, offset, depth + 1);
        }
    }
}

