/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.feature.volcano;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.tropicraft.core.common.dimension.feature.TropicraftStructureTypes;
import net.tropicraft.core.common.dimension.feature.volcano.VolcanoStructurePiece;

public class VolcanoStructure
extends Structure {
    public static final Codec<VolcanoStructure> CODEC = RecordCodecBuilder.create(i -> i.group((App)VolcanoStructure.m_226567_((RecordCodecBuilder.Instance)i), (App)HeightProvider.f_161970_.fieldOf("height").forGetter(s -> s.height), (App)IntProvider.f_146531_.fieldOf("radius").forGetter(s -> s.radius)).apply((Applicative)i, VolcanoStructure::new));
    private final HeightProvider height;
    private final IntProvider radius;

    public VolcanoStructure(Structure.StructureSettings settings, HeightProvider height, IntProvider radius) {
        super(settings);
        this.height = height;
        this.radius = radius;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        WorldgenRandom random = context.f_226626_();
        int height = this.height.m_213859_((RandomSource)random, new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        int radiusX = this.radius.m_214085_((RandomSource)random);
        int radiusZ = this.radius.m_214085_((RandomSource)random);
        long noiseSeed = random.m_188505_();
        BlockPos pos = new BlockPos(chunkPos.m_45604_() + 8, height, chunkPos.m_45605_() + 8);
        return Optional.of(new Structure.GenerationStub(pos, builder -> builder.m_142679_((StructurePiece)new VolcanoStructurePiece(context.f_226629_(), pos, radiusX, radiusZ, noiseSeed))));
    }

    public StructureType<?> m_213658_() {
        return (StructureType)TropicraftStructureTypes.VOLCANO.get();
    }
}

