/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.dimension.noise;

import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.tropicraft.core.common.dimension.TropicraftTerrainProvider;

public final class TropicraftNoiseRouterData {
    public static final DeferredRegister<DensityFunction> REGISTER = DeferredRegister.create((ResourceKey)Registry.f_211074_, (String)"tropicraft");
    private static final DensityFunction BLENDING_FACTOR = DensityFunctions.m_208264_((double)10.0);
    private static final DensityFunction BLENDING_JAGGEDNESS = DensityFunctions.m_208263_();
    private static final ResourceKey<DensityFunction> Y = TropicraftNoiseRouterData.vanillaKey("y");
    private static final ResourceKey<DensityFunction> SHIFT_X = TropicraftNoiseRouterData.vanillaKey("shift_x");
    private static final ResourceKey<DensityFunction> SHIFT_Z = TropicraftNoiseRouterData.vanillaKey("shift_z");
    private static final ResourceKey<DensityFunction> BASE_3D_NOISE_OVERWORLD = TropicraftNoiseRouterData.vanillaKey("overworld/base_3d_noise");
    private static final ResourceKey<DensityFunction> SPAGHETTI_ROUGHNESS_FUNCTION = TropicraftNoiseRouterData.vanillaKey("overworld/caves/spaghetti_roughness_function");
    private static final ResourceKey<DensityFunction> ENTRANCES = TropicraftNoiseRouterData.vanillaKey("overworld/caves/entrances");
    private static final ResourceKey<DensityFunction> NOODLE = TropicraftNoiseRouterData.vanillaKey("overworld/caves/noodle");
    private static final ResourceKey<DensityFunction> PILLARS = TropicraftNoiseRouterData.vanillaKey("overworld/caves/pillars");
    private static final ResourceKey<DensityFunction> SPAGHETTI_2D = TropicraftNoiseRouterData.vanillaKey("overworld/caves/spaghetti_2d");
    public static final RegistryObject<DensityFunction> OFFSET = REGISTER.register("tropics/offset", () -> TropicraftNoiseRouterData.splineWithBlending(DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.50375f), (DensityFunction)DensityFunctions.m_224020_(TropicraftTerrainProvider.offset(TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209451_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209452_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_224429_)))), DensityFunctions.m_208372_()));
    public static final RegistryObject<DensityFunction> FACTOR = REGISTER.register("tropics/factor", () -> TropicraftNoiseRouterData.splineWithBlending(DensityFunctions.m_224020_(TropicraftTerrainProvider.factor(TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209451_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209452_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209453_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_224429_))), BLENDING_FACTOR));
    public static final RegistryObject<DensityFunction> DEPTH = REGISTER.register("tropics/depth", () -> DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208266_((int)-64, (int)320, (double)1.5, (double)-1.5), (DensityFunction)TropicraftNoiseRouterData.getFunction(OFFSET)));
    public static final RegistryObject<DensityFunction> JAGGEDNESS = REGISTER.register("tropics/jaggedness", () -> TropicraftNoiseRouterData.splineWithBlending(DensityFunctions.m_224020_(TropicraftTerrainProvider.jaggedness(TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209451_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209452_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_209453_), TropicraftNoiseRouterData.splineCoordinate((ResourceKey<DensityFunction>)NoiseRouterData.f_224429_))), BLENDING_JAGGEDNESS));
    public static final RegistryObject<DensityFunction> SLOPED_CHEESE = REGISTER.register("tropics/sloped_cheese", () -> {
        DensityFunction jagged = DensityFunctions.m_208363_((DensityFunction)TropicraftNoiseRouterData.getFunction(JAGGEDNESS), (DensityFunction)DensityFunctions.m_208368_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189255_), (double)1500.0, (double)0.0).m_208232_());
        return DensityFunctions.m_208293_((DensityFunction)TropicraftNoiseRouterData.noiseGradientDensity((DensityFunction)TropicraftNoiseRouterData.getFunction(FACTOR), DensityFunctions.m_208293_((DensityFunction)TropicraftNoiseRouterData.getFunction(DEPTH), (DensityFunction)jagged)), (DensityFunction)TropicraftNoiseRouterData.getFunction((Registry<DensityFunction>)BuiltinRegistries.f_211085_, BASE_3D_NOISE_OVERWORLD));
    });

    private static DensityFunctions.Spline.Coordinate splineCoordinate(ResourceKey<DensityFunction> key) {
        return new DensityFunctions.Spline.Coordinate(BuiltinRegistries.f_211085_.m_206081_(key));
    }

    private static DensityFunction splineWithBlending(DensityFunction p_224454_, DensityFunction p_224455_) {
        DensityFunction densityfunction = DensityFunctions.m_208301_((DensityFunction)DensityFunctions.m_208360_(), (DensityFunction)p_224455_, (DensityFunction)p_224454_);
        return DensityFunctions.m_208361_((DensityFunction)DensityFunctions.m_208373_((DensityFunction)densityfunction));
    }

    public static NoiseRouter tropics(Registry<DensityFunction> registry) {
        DensityFunction aquiferBarrier = DensityFunctions.m_208324_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189287_), (double)0.5);
        DensityFunction aquiferFluidLevelFloodedness = DensityFunctions.m_208324_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189288_), (double)0.67);
        DensityFunction aquiferFluidLevelSpread = DensityFunctions.m_208324_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189290_), (double)0.7142857142857143);
        DensityFunction aquiferLava = DensityFunctions.m_208322_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189289_));
        DensityFunction shiftX = TropicraftNoiseRouterData.getFunction(registry, SHIFT_X);
        DensityFunction shiftZ = TropicraftNoiseRouterData.getFunction(registry, SHIFT_Z);
        DensityFunction temperature = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189269_));
        DensityFunction vegetation = DensityFunctions.m_208296_((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189278_));
        DensityFunctions.HolderHolder factor = TropicraftNoiseRouterData.getFunction(FACTOR);
        DensityFunctions.HolderHolder depth = TropicraftNoiseRouterData.getFunction(DEPTH);
        DensityFunction initialDensityWithoutJaggedness = TropicraftNoiseRouterData.noiseGradientDensity(DensityFunctions.m_208373_((DensityFunction)factor), (DensityFunction)depth);
        DensityFunctions.HolderHolder slopedCheese = TropicraftNoiseRouterData.getFunction(SLOPED_CHEESE);
        DensityFunction densityfunction12 = DensityFunctions.m_208375_((DensityFunction)slopedCheese, (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)5.0), (DensityFunction)TropicraftNoiseRouterData.getFunction(registry, ENTRANCES)));
        DensityFunction densityfunction13 = DensityFunctions.m_208287_((DensityFunction)slopedCheese, (double)-1000000.0, (double)1.5625, (DensityFunction)densityfunction12, (DensityFunction)TropicraftNoiseRouterData.underground(registry, (DensityFunction)slopedCheese));
        DensityFunction finalDensity = DensityFunctions.m_208375_((DensityFunction)TropicraftNoiseRouterData.postProcess(TropicraftNoiseRouterData.slideTropics(densityfunction13)), (DensityFunction)TropicraftNoiseRouterData.getFunction(registry, NOODLE));
        DensityFunction y = TropicraftNoiseRouterData.getFunction(registry, Y);
        int j = -60;
        int k = 50;
        DensityFunction veinToggle = TropicraftNoiseRouterData.yLimitedInterpolatable(y, DensityFunctions.m_208368_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189247_), (double)1.5, (double)1.5), j, k, 0);
        DensityFunction oreVeinA = TropicraftNoiseRouterData.yLimitedInterpolatable(y, DensityFunctions.m_208368_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189248_), (double)4.0, (double)4.0), j, k, 0).m_208229_();
        DensityFunction oreVeinB = TropicraftNoiseRouterData.yLimitedInterpolatable(y, DensityFunctions.m_208368_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189249_), (double)4.0, (double)4.0), j, k, 0).m_208229_();
        DensityFunction veinRidged = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.08f), (DensityFunction)DensityFunctions.m_208382_((DensityFunction)oreVeinA, (DensityFunction)oreVeinB));
        DensityFunction veinGap = DensityFunctions.m_208322_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189250_));
        return new NoiseRouter(aquiferBarrier, aquiferFluidLevelFloodedness, aquiferFluidLevelSpread, aquiferLava, temperature, vegetation, TropicraftNoiseRouterData.getFunction(registry, (ResourceKey<DensityFunction>)NoiseRouterData.f_209451_), TropicraftNoiseRouterData.getFunction(registry, (ResourceKey<DensityFunction>)NoiseRouterData.f_209452_), (DensityFunction)depth, TropicraftNoiseRouterData.getFunction(registry, (ResourceKey<DensityFunction>)NoiseRouterData.f_209453_), initialDensityWithoutJaggedness, finalDensity, veinToggle, veinRidged, veinGap);
    }

    private static DensityFunction postProcess(DensityFunction function) {
        DensityFunction blendedFunction = DensityFunctions.m_208389_((DensityFunction)function);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208281_((DensityFunction)blendedFunction), (DensityFunction)DensityFunctions.m_208264_((double)0.64)).m_208234_();
    }

    private static DensityFunction slideTropics(DensityFunction function) {
        return TropicraftNoiseRouterData.slide(function, -64, 384, 80, 64, -0.078125, 0, 24, 0.1171875);
    }

    private static DensityFunction slide(DensityFunction function, int minY, int height, int topSliderLowerOffset, int topSlideUpperOffset, double topSlideTarget, int bottomSlideLowerOffset, int bottomSlideUpperOffset, double bottomSlideTarget) {
        DensityFunction topSlideFactor = DensityFunctions.m_208266_((int)(minY + height - topSliderLowerOffset), (int)(minY + height - topSlideUpperOffset), (double)1.0, (double)0.0);
        DensityFunction bottomSlideFactor = DensityFunctions.m_208266_((int)(minY + bottomSlideLowerOffset), (int)(minY + bottomSlideUpperOffset), (double)0.0, (double)1.0);
        return DensityFunctions.m_224030_((DensityFunction)bottomSlideFactor, (double)bottomSlideTarget, (DensityFunction)DensityFunctions.m_224030_((DensityFunction)topSlideFactor, (double)topSlideTarget, (DensityFunction)function));
    }

    private static Holder<NormalNoise.NoiseParameters> getNoise(ResourceKey<NormalNoise.NoiseParameters> key) {
        return BuiltinRegistries.f_194654_.m_206081_(key);
    }

    private static ResourceKey<DensityFunction> vanillaKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_211074_, (ResourceLocation)new ResourceLocation(name));
    }

    private static DensityFunctions.HolderHolder getFunction(RegistryObject<DensityFunction> function) {
        return new DensityFunctions.HolderHolder((Holder)function.getHolder().orElseThrow());
    }

    private static DensityFunction getFunction(Registry<DensityFunction> registry, ResourceKey<DensityFunction> key) {
        return new DensityFunctions.HolderHolder(registry.m_206081_(key));
    }

    private static DensityFunction yLimitedInterpolatable(DensityFunction p_209472_, DensityFunction p_209473_, int p_209474_, int p_209475_, int p_209476_) {
        return DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208287_((DensityFunction)p_209472_, (double)p_209474_, (double)(p_209475_ + 1), (DensityFunction)p_209473_, (DensityFunction)DensityFunctions.m_208264_((double)p_209476_)));
    }

    private static DensityFunction noiseGradientDensity(DensityFunction p_212272_, DensityFunction p_212273_) {
        DensityFunction densityfunction = DensityFunctions.m_208363_((DensityFunction)p_212273_, (DensityFunction)p_212272_);
        return DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)densityfunction.m_208233_());
    }

    private static DensityFunction underground(Registry<DensityFunction> registry, DensityFunction slopedCheese) {
        DensityFunction spaghetti2d = TropicraftNoiseRouterData.getFunction(registry, SPAGHETTI_2D);
        DensityFunction spaghettiRoughness = TropicraftNoiseRouterData.getFunction(registry, SPAGHETTI_ROUGHNESS_FUNCTION);
        DensityFunction caveLayer = DensityFunctions.m_208324_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189245_), (double)8.0);
        DensityFunction densityfunction3 = DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)4.0), (DensityFunction)caveLayer.m_208230_());
        DensityFunction caveCheese = DensityFunctions.m_208324_(TropicraftNoiseRouterData.getNoise((ResourceKey<NormalNoise.NoiseParameters>)Noises.f_189246_), (double)0.6666666666666666);
        DensityFunction densityfunction5 = DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.27), (DensityFunction)caveCheese).m_208220_(-1.0, 1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.5), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)-0.64), (DensityFunction)slopedCheese)).m_208220_(0.0, 0.5));
        DensityFunction densityfunction6 = DensityFunctions.m_208293_((DensityFunction)densityfunction3, (DensityFunction)densityfunction5);
        DensityFunction caves = DensityFunctions.m_208375_((DensityFunction)DensityFunctions.m_208375_((DensityFunction)densityfunction6, (DensityFunction)TropicraftNoiseRouterData.getFunction(registry, ENTRANCES)), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)spaghetti2d, (DensityFunction)spaghettiRoughness));
        DensityFunction pillars = TropicraftNoiseRouterData.getFunction(registry, PILLARS);
        DensityFunction pillarsThreshold = DensityFunctions.m_208287_((DensityFunction)pillars, (double)-1000000.0, (double)0.03, (DensityFunction)DensityFunctions.m_208264_((double)-1000000.0), (DensityFunction)pillars);
        return DensityFunctions.m_208382_((DensityFunction)caves, (DensityFunction)pillarsThreshold);
    }
}

