/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.drinks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.drinks.Ingredient;
import net.tropicraft.core.common.drinks.MixerRecipe;
import net.tropicraft.core.common.item.CocktailItem;

public class Drinks {
    private static List<MixerRecipe> recipes = new LinkedList<MixerRecipe>();

    public static void register(MixerRecipe recipe) {
        recipes.add(recipe);
    }

    public static boolean isRegisteredIngredient(ItemStack item) {
        if (Drink.isDrink(item.m_41720_())) {
            return true;
        }
        for (MixerRecipe recipe : recipes) {
            for (Ingredient i : recipe.getIngredients()) {
                if (i.getIngredientItem() != item.m_41720_()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRegisteredIngredient(@Nonnull Item item) {
        return Drinks.isRegisteredIngredient(new ItemStack((ItemLike)item));
    }

    @Nonnull
    public static ItemStack getResult(NonNullList<ItemStack> ingredients) {
        for (MixerRecipe recipe : recipes) {
            int validIngredientsFound = 0;
            block1: for (Ingredient recipeIngredient : recipe.getIngredients()) {
                for (ItemStack mixerIngredient : ingredients) {
                    if (recipeIngredient.getIngredientItem() != mixerIngredient.m_41720_()) continue;
                    ++validIngredientsFound;
                    continue block1;
                }
            }
            if (validIngredientsFound != recipe.getIngredients().length) continue;
            return CocktailItem.makeCocktail(recipe);
        }
        ArrayList<Ingredient> is = new ArrayList<Ingredient>();
        for (ItemStack ingredientStack : ingredients) {
            is.addAll(Ingredient.listIngredients(ingredientStack));
        }
        Collections.sort(is);
        return CocktailItem.makeCocktail(ingredients);
    }

    public static List<MixerRecipe> getRecipes() {
        return recipes;
    }
}

