/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity;

import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.tropicraft.core.common.dimension.TropicraftDimension;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.SeaTurtleEggEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class SeaTurtleEntity
extends Turtle {
    private static final EntityDataAccessor<Boolean> IS_MATURE = SynchedEntityData.m_135353_(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> TURTLE_TYPE = SynchedEntityData.m_135353_(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> NO_BRAKES = SynchedEntityData.m_135353_(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_FLY = SynchedEntityData.m_135353_(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_DIGGING = SynchedEntityData.m_135353_(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_EGG = SynchedEntityData.m_135353_(SeaTurtleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final int NUM_TYPES = 6;
    private double lastPosY;
    private int digCounter;
    private float swimSpeedCurrent;

    public SeaTurtleEntity(EntityType<? extends Turtle> type, Level world) {
        super(type, world);
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.15f;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficultyInstance, MobSpawnType spawnReason, @Nullable SpawnGroupData data, @Nullable CompoundTag nbt) {
        this.setRandomTurtleType();
        this.lastPosY = this.m_20186_();
        return super.m_6518_(world, difficultyInstance, spawnReason, data, nbt);
    }

    protected void m_8099_() {
        Optional<WrappedGoal> mateGoal;
        super.m_8099_();
        Set goalSet = this.f_21345_.m_148105_();
        Optional<WrappedGoal> eggGoal = goalSet.stream().filter(p -> p.m_26015_().toString().contains("Egg")).findFirst();
        if (eggGoal.isPresent()) {
            this.f_21345_.m_25363_(eggGoal.get().m_26015_());
            this.f_21345_.m_25352_(1, (Goal)new BetterLayEggGoal(this, 1.0));
        }
        if ((mateGoal = goalSet.stream().filter(p -> p.m_26015_().toString().contains("Mate")).findFirst()).isPresent()) {
            this.f_21345_.m_25363_(mateGoal.get().m_26015_());
            this.f_21345_.m_25352_(1, (Goal)new BetterMateGoal(this, 1.0));
        }
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_MATURE, (Object)true);
        this.m_20088_().m_135372_(TURTLE_TYPE, (Object)1);
        this.m_20088_().m_135372_(NO_BRAKES, (Object)false);
        this.m_20088_().m_135372_(CAN_FLY, (Object)false);
        this.m_20088_().m_135372_(IS_DIGGING, (Object)false);
        this.m_20088_().m_135372_(HAS_EGG, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("TurtleType", this.getTurtleType());
        nbt.m_128379_("IsMature", this.isMature());
        nbt.m_128379_("NoBrakesOnThisTrain", this.getNoBrakes());
        nbt.m_128379_("LongsForTheSky", this.getCanFly());
        nbt.m_128379_("HasEgg", this.m_30205_());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("TurtleType")) {
            this.setTurtleType(nbt.m_128451_("TurtleType"));
        } else {
            this.setRandomTurtleType();
        }
        if (nbt.m_128441_("IsMature")) {
            this.setIsMature(nbt.m_128471_("IsMature"));
        } else {
            this.setIsMature(true);
        }
        this.setNoBrakes(nbt.m_128471_("NoBrakesOnThisTrain"));
        this.setCanFly(nbt.m_128471_("LongsForTheSky"));
        this.m_30234_(nbt.m_128471_("HasEgg"));
        this.lastPosY = this.m_20186_();
    }

    public boolean isMature() {
        return (Boolean)this.m_20088_().m_135370_(IS_MATURE);
    }

    public SeaTurtleEntity setIsMature(boolean mature) {
        this.m_20088_().m_135381_(IS_MATURE, (Object)mature);
        return this;
    }

    public int getTurtleType() {
        return (Integer)this.m_20088_().m_135370_(TURTLE_TYPE);
    }

    public void setRandomTurtleType() {
        this.setTurtleType(this.f_19796_.m_188503_(6) + 1);
    }

    public SeaTurtleEntity setTurtleType(int type) {
        this.m_20088_().m_135381_(TURTLE_TYPE, (Object)Mth.m_14045_((int)type, (int)1, (int)6));
        return this;
    }

    public boolean getNoBrakes() {
        return (Boolean)this.m_20088_().m_135370_(NO_BRAKES);
    }

    public SeaTurtleEntity setNoBrakes(boolean noBrakes) {
        this.m_20088_().m_135381_(NO_BRAKES, (Object)noBrakes);
        return this;
    }

    public boolean getCanFly() {
        return (Boolean)this.m_20088_().m_135370_(CAN_FLY);
    }

    public SeaTurtleEntity setCanFly(boolean canFly) {
        this.m_20088_().m_135381_(CAN_FLY, (Object)canFly);
        return this;
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        LivingEntity living;
        Entity entity = this.m_146895_();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    public static boolean canSpawnOnLand(EntityType<SeaTurtleEntity> turtle, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource rand) {
        return pos.m_123342_() < TropicraftDimension.getSeaLevel((LevelReader)world) + 4 && world.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_49992_ && world.m_45524_(pos, 0) > 8;
    }

    public double m_6048_() {
        return super.m_6048_() - 0.1;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob partner) {
        return ((SeaTurtleEntity)((EntityType)TropicraftEntities.SEA_TURTLE.get()).m_20615_(this.f_19853_)).setTurtleType(this.f_19796_.m_188499_() && partner instanceof SeaTurtleEntity ? ((SeaTurtleEntity)partner).getTurtleType() : this.getTurtleType()).setIsMature(false);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result = super.m_6071_(player, hand);
        if (result != InteractionResult.PASS) {
            return result;
        }
        if (!this.f_19853_.f_46443_ && !player.m_6144_() && this.m_7310_((Entity)player) && this.isMature()) {
            player.m_20329_((Entity)this);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean m_6000_(double x, double y, double z) {
        LivingEntity controller = this.getControllingPassenger();
        if (controller != null) {
            return controller.m_6000_(x, y, z);
        }
        return super.m_6000_(x, y, z);
    }

    public void m_8119_() {
        super.m_8119_();
        this.lastPosY = this.m_20186_();
    }

    public void m_8107_() {
        BlockPos pos;
        super.m_8107_();
        if (this.m_6084_() && this.m_30206_() && this.digCounter >= 1 && this.digCounter % 5 == 0 && this.f_19853_.m_8055_((pos = this.m_20183_()).m_7495_()).m_60767_() == Material.f_76317_) {
            this.f_19853_.m_46796_(2001, pos, Block.m_49956_((BlockState)Blocks.f_49992_.m_49966_()));
        }
        if (this.f_19853_.f_46443_ && this.m_20160_() && this.m_217005_() && (this.m_20069_() || this.getCanFly())) {
            Vec3 movement = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82492_(this.f_19854_, this.f_19855_, this.f_19856_);
            double speed = movement.m_82553_();
            Vec3 particleOffset = movement.m_82548_().m_82490_(2.0);
            if (speed > 0.05) {
                int maxParticles = Mth.m_14165_((double)(speed * 5.0));
                int particlesToSpawn = this.f_19796_.m_188503_(1 + maxParticles);
                SimpleParticleType particle = this.m_20069_() ? ParticleTypes.f_123795_ : ParticleTypes.f_123810_;
                for (int i = 0; i < particlesToSpawn; ++i) {
                    Vec3 particleMotion = movement.m_82490_(1.0);
                    this.f_19853_.m_6493_((ParticleOptions)particle, true, particleOffset.m_7096_() + this.m_20185_() - 0.25 + this.f_19796_.m_188500_() * 0.5, particleOffset.m_7098_() + this.m_20186_() + 0.1 + this.f_19796_.m_188500_() * 0.1, particleOffset.m_7094_() + this.m_20189_() - 0.25 + this.f_19796_.m_188500_() * 0.5, particleMotion.f_82479_, particleMotion.f_82480_, particleMotion.f_82481_);
                }
            }
        }
    }

    public float lerp(float x1, float x2, float t) {
        return x1 + t * 0.03f * Mth.m_14177_((float)(x2 - x1));
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (this.m_20363_(passenger)) {
            if (passenger instanceof Player) {
                Player p = (Player)passenger;
                if (this.m_20069_()) {
                    if (p.f_20902_ > 0.0f) {
                        this.m_146926_(this.lerp(this.m_146909_(), -(passenger.m_146909_() * 0.5f), 6.0f));
                        this.m_146922_(this.lerp(this.m_146908_(), -passenger.m_146908_(), 6.0f));
                        this.swimSpeedCurrent += 0.05f;
                        if (this.swimSpeedCurrent > 4.0f) {
                            this.swimSpeedCurrent = 4.0f;
                        }
                    }
                    if (p.f_20902_ < 0.0f) {
                        this.swimSpeedCurrent *= 0.89f;
                        if (this.swimSpeedCurrent < 0.1f) {
                            this.swimSpeedCurrent = 0.1f;
                        }
                    }
                    if (p.f_20902_ == 0.0f) {
                        if (this.swimSpeedCurrent > 1.0f) {
                            this.swimSpeedCurrent *= 0.94f;
                            if (this.swimSpeedCurrent <= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                        if (this.swimSpeedCurrent < 1.0f) {
                            this.swimSpeedCurrent *= 1.06f;
                            if (this.swimSpeedCurrent >= 1.0f) {
                                this.swimSpeedCurrent = 1.0f;
                            }
                        }
                    }
                }
            } else if (passenger instanceof Mob) {
                Mob mobentity = (Mob)passenger;
                this.f_20883_ = mobentity.f_20883_;
                this.f_20886_ = mobentity.f_20886_;
            }
        }
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
    }

    public void m_7023_(Vec3 input) {
        if (this.m_6084_()) {
            LivingEntity controllingPassenger = this.getControllingPassenger();
            if (this.m_20160_() && controllingPassenger != null) {
                this.m_146922_(controllingPassenger.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(controllingPassenger.m_146909_());
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                this.f_19793_ = 1.0f;
                this.f_20887_ = this.m_6113_() * 0.1f;
                float strafe = controllingPassenger.f_20900_;
                float forward = this.getNoBrakes() ? 1.0f : controllingPassenger.f_20902_;
                float vertical = controllingPassenger.f_20901_;
                double verticalFromPitch = -Math.sin(Math.toRadians(this.m_146909_())) * (double)forward;
                forward *= Mth.m_14036_((float)(1.0f - Math.abs(this.m_146909_()) / 90.0f), (float)0.01f, (float)1.0f);
                if (!this.m_20069_()) {
                    if (this.getCanFly()) {
                        this.m_20256_(this.m_20184_().m_82520_(0.0, -this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_() * 0.05, 0.0));
                    } else {
                        this.m_20256_(this.m_20184_().m_82542_(0.9, 0.99, 0.9).m_82520_(0.0, -this.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get()).m_22135_(), 0.0));
                    }
                }
                if (this.m_6109_()) {
                    Vec3 travel = new Vec3((double)strafe, verticalFromPitch + (double)vertical, (double)forward).m_82490_(this.m_21051_(Attributes.f_22279_).m_22135_()).m_82490_((double)0.025f);
                    this.m_19920_(1.0f, travel);
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82490_(forward > 0.0f || !this.m_20069_() ? 0.975 : 0.9));
                } else {
                    this.f_19789_ = (float)Math.max(0.0, (this.m_20186_() - this.lastPosY) * -8.0);
                    this.m_20256_(Vec3.f_82478_);
                }
                this.f_20923_ = this.f_20924_;
                double d1 = this.m_20185_() - this.f_19854_;
                double d0 = this.m_20189_() - this.f_19856_;
                float swinger = Mth.m_14116_((float)((float)(d1 * d1 + d0 * d0))) * 4.0f;
                if (swinger > 1.0f) {
                    swinger = 1.0f;
                }
                this.f_20924_ += (swinger - this.f_20924_) * 0.4f;
                this.f_20925_ += this.f_20924_;
            } else {
                this.f_20887_ = 0.02f;
                super.m_7023_(input);
            }
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.SEA_TURTLE_SPAWN_EGG.get());
    }

    public boolean m_6146_() {
        return true;
    }

    private void setDigging(boolean digging) {
        this.digCounter = digging ? 1 : 0;
        this.f_19804_.m_135381_(IS_DIGGING, (Object)digging);
    }

    public boolean m_30206_() {
        return this.digCounter > 0;
    }

    private void m_30234_(boolean hasEgg) {
        this.f_19804_.m_135381_(HAS_EGG, (Object)hasEgg);
    }

    public boolean m_30205_() {
        return (Boolean)this.f_19804_.m_135370_(HAS_EGG);
    }

    static class BetterLayEggGoal
    extends MoveToBlockGoal {
        private final SeaTurtleEntity turtle;

        BetterLayEggGoal(SeaTurtleEntity turtle, double speedIn) {
            super((PathfinderMob)turtle, speedIn, 16);
            this.turtle = turtle;
        }

        public boolean m_8036_() {
            return this.turtle.m_30205_() && this.turtle.m_30208_().m_203195_((Position)this.turtle.m_20182_(), 9.0) && super.m_8036_();
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.turtle.m_30205_() && this.turtle.m_30208_().m_203195_((Position)this.turtle.m_20182_(), 9.0);
        }

        public void m_8037_() {
            super.m_8037_();
            BlockPos blockpos = this.turtle.m_20183_();
            if (!this.turtle.m_20069_() && this.m_25625_()) {
                if (!this.turtle.m_30206_()) {
                    this.turtle.setDigging(true);
                } else if (this.turtle.digCounter > 200) {
                    Level world = this.turtle.f_19853_;
                    world.m_5594_(null, blockpos, SoundEvents.f_12486_, SoundSource.BLOCKS, 0.3f, 0.9f + world.f_46441_.m_188501_() * 0.2f);
                    SeaTurtleEggEntity egg = (SeaTurtleEggEntity)((EntityType)TropicraftEntities.SEA_TURTLE_EGG.get()).m_20615_(world);
                    BlockPos spawnPos = this.f_25602_.m_7494_();
                    egg.m_6034_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_());
                    world.m_7967_((Entity)egg);
                    this.turtle.m_30234_(false);
                    this.turtle.setDigging(false);
                    this.turtle.m_27601_(600);
                }
                if (this.turtle.m_30206_()) {
                    ++this.turtle.digCounter;
                }
            }
        }

        protected boolean m_6465_(LevelReader worldIn, BlockPos pos) {
            if (!worldIn.m_46859_(pos.m_7494_())) {
                return false;
            }
            return worldIn.m_8055_(pos).m_60767_() == Material.f_76317_;
        }
    }

    static class BetterMateGoal
    extends BreedGoal {
        private final SeaTurtleEntity turtle;

        BetterMateGoal(SeaTurtleEntity turtle, double speedIn) {
            super((Animal)turtle, speedIn);
            this.turtle = turtle;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.turtle.m_30205_();
        }

        protected void m_8026_() {
            ServerPlayer serverplayerentity = this.f_25113_.m_27592_();
            if (serverplayerentity == null && this.f_25115_.m_27592_() != null) {
                serverplayerentity = this.f_25115_.m_27592_();
            }
            if (serverplayerentity != null) {
                serverplayerentity.m_36220_(Stats.f_12937_);
                CriteriaTriggers.f_10581_.m_147278_(serverplayerentity, this.f_25113_, this.f_25115_, null);
            }
            this.turtle.m_30234_(true);
            this.f_25113_.m_27594_();
            this.f_25115_.m_27594_();
            RandomSource random = this.f_25113_.m_217043_();
            if (this.f_25114_.m_46469_().m_46207_(GameRules.f_46135_)) {
                this.f_25114_.m_7967_((Entity)new ExperienceOrb(this.f_25114_, this.f_25113_.m_20185_(), this.f_25113_.m_20186_(), this.f_25113_.m_20189_(), random.m_188503_(7) + 1));
            }
        }
    }
}

