/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityAIChillAtFire
extends Goal {
    private final EntityKoaBase entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private int randXPos = 0;
    private int randYPos = 0;
    private int randZPos = 0;

    public EntityAIChillAtFire(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if ((this.entityObj.getWantsToParty() || this.entityObj.druggedTime > 0) && this.entityObj.listPosDrums.size() > 0) {
            return false;
        }
        BlockPos blockpos = this.entityObj.m_20183_();
        if (!this.entityObj.f_19853_.m_46461_() || this.entityObj.f_19853_.m_46471_() && ((Biome)this.entityObj.f_19853_.m_204166_(blockpos).m_203334_()).m_47530_() != Biome.Precipitation.RAIN) {
            if (!this.isTooClose()) {
                return this.entityObj.f_19853_.f_46441_.m_188503_(20) == 0;
            }
            return false;
        }
        return false;
    }

    public boolean m_8045_() {
        if ((this.entityObj.getWantsToParty() || this.entityObj.druggedTime > 0) && this.entityObj.listPosDrums.size() > 0) {
            return false;
        }
        BlockPos blockpos = this.entityObj.m_20183_();
        if (!this.entityObj.f_19853_.m_46461_() || this.entityObj.f_19853_.m_46471_() && ((Biome)this.entityObj.f_19853_.m_204166_(blockpos).m_203334_()).m_47530_() != Biome.Precipitation.RAIN) {
            return !this.isTooClose();
        }
        return this.entityObj.f_19853_.f_46441_.m_188503_(60) != 0;
    }

    public void m_8037_() {
        super.m_8037_();
        boolean isClose = false;
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.m_7918_(0, -1, 0) : this.entityObj.m_21534_();
        if (blockposGoal.equals((Object)BlockPos.f_121853_)) {
            this.m_8041_();
            return;
        }
        double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
        if (dist < 4.0 && this.entityObj.m_20096_()) {
            this.entityObj.setSitting(true);
            this.entityObj.m_21573_().m_26573_();
            isClose = true;
            if (this.lookUpdateTimer <= 0) {
                this.lookUpdateTimer = 200 + this.entityObj.f_19853_.f_46441_.m_188503_(100);
                int range = 2;
                this.randXPos = this.entityObj.f_19853_.f_46441_.m_188503_(range) - this.entityObj.f_19853_.f_46441_.m_188503_(range);
                this.randYPos = this.entityObj.f_19853_.f_46441_.m_188503_(3) == 0 ? 5 + this.entityObj.f_19853_.f_46441_.m_188503_(5) : 0;
                this.randZPos = this.entityObj.f_19853_.f_46441_.m_188503_(range) - this.entityObj.f_19853_.f_46441_.m_188503_(range);
                if (this.entityObj.m_19879_() % 3 == 0) {
                    this.entityObj.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get()));
                } else if (this.entityObj.m_19879_() % 5 == 0) {
                    this.entityObj.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.COOKED_FROG_LEG.get()));
                } else {
                    this.entityObj.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.ORANGE.get()));
                }
                this.entityObj.m_5634_(1.0f);
            }
            this.entityObj.m_21563_().m_24950_((double)(blockposGoal.m_123341_() + this.randXPos), (double)(blockposGoal.m_123342_() + this.randYPos) + 1.0, (double)(blockposGoal.m_123343_() + this.randZPos), 8.0f, 8.0f);
        } else {
            this.entityObj.setSitting(false);
        }
        if (!isClose) {
            if ((this.entityObj.m_21573_().m_26571_() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                Vec3 Vector3d;
                int i = blockposGoal.m_123341_();
                int j = blockposGoal.m_123342_();
                int k = blockposGoal.m_123343_();
                boolean success = false;
                success = this.entityObj.m_20238_(Vec3.m_82512_((Vec3i)blockposGoal)) > 256.0 ? ((Vector3d = DefaultRandomPos.m_148412_((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866)) != null ? this.entityObj.m_21573_().m_26519_(Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_, 1.0) : Util.tryMoveToXYZLongDist((Mob)this.entityObj, new BlockPos(i, j, k), 1.0)) : this.entityObj.m_21573_().m_26519_((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                if (!success) {
                    this.repathPentalty = 40;
                } else {
                    this.walkingTimeout = this.walkingTimeoutMax;
                }
            } else if (this.walkingTimeout > 0) {
                --this.walkingTimeout;
            }
        }
        if (this.repathPentalty > 0) {
            --this.repathPentalty;
        }
        if (this.lookUpdateTimer > 0) {
            --this.lookUpdateTimer;
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.entityObj.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.m_7918_(0, -1, 0) : this.entityObj.m_21534_();
        if (blockposGoal.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
        return dist <= 3.0;
    }
}

