/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;

public class EntityAIEatToHeal
extends Goal {
    private final EntityKoaBase entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private int randXPos = 0;
    private int randYPos = 0;
    private int randZPos = 0;
    private float missingHealthToHeal = 5.0f;

    public EntityAIEatToHeal(EntityKoaBase entityObjIn) {
        this.entityObj = entityObjIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.entityObj.m_21223_() < this.entityObj.m_21233_() - this.missingHealthToHeal) {
            return this.hasFoodSource();
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.hasFoodSource((Container)this.entityObj.inventory)) {
            this.consumeOneStackSizeOfFood((Container)this.entityObj.inventory);
            this.entityObj.m_5634_(5.0f);
            this.entityObj.f_19853_.m_5594_(null, this.entityObj.m_20183_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return;
        }
        if (this.hasFoodAtHome()) {
            boolean isClose = false;
            BlockPos blockposGoal = this.entityObj.m_21534_();
            if (blockposGoal.equals((Object)BlockPos.f_121853_)) {
                this.m_8041_();
                return;
            }
            double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
            if (dist < 5.0) {
                this.consumeOneStackSizeOfFoodAtHome();
                this.entityObj.m_5634_(5.0f);
                this.entityObj.f_19853_.m_5594_(null, this.entityObj.m_20183_(), SoundEvents.f_12321_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                return;
            }
            if (!isClose) {
                if ((this.entityObj.m_21573_().m_26571_() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.m_123341_();
                    int j = blockposGoal.m_123342_();
                    int k = blockposGoal.m_123343_();
                    boolean success = false;
                    if (this.entityObj.m_20238_(Vec3.m_82512_((Vec3i)blockposGoal)) > 256.0) {
                        Vec3 Vector3d = DefaultRandomPos.m_148412_((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866);
                        if (Vector3d != null) {
                            success = this.entityObj.m_21573_().m_26519_(Vector3d.f_82479_, Vector3d.f_82480_, Vector3d.f_82481_, 1.0);
                        }
                    } else {
                        success = this.entityObj.m_21573_().m_26519_((double)i + 0.5, (double)j, (double)k + 0.5, 1.0);
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = this.walkingTimeoutMax;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.entityObj.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.entityObj.setSitting(false);
        this.walkingTimeout = 0;
    }

    public boolean isTooClose() {
        BlockPos blockposGoal = null;
        blockposGoal = this.entityObj.posLastFireplaceFound != null ? this.entityObj.posLastFireplaceFound.m_7918_(0, -1, 0) : this.entityObj.m_21534_();
        if (blockposGoal.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
        return dist <= 3.0;
    }

    public boolean hasFoodSource() {
        if (this.hasFoodSource((Container)this.entityObj.inventory)) {
            return true;
        }
        return this.hasFoodAtHome();
    }

    public boolean hasFoodAtHome() {
        ChestBlockEntity chest;
        BlockEntity tile;
        BlockPos blockposGoal = this.entityObj.m_21534_();
        return !blockposGoal.equals((Object)BlockPos.f_121853_) && (tile = this.entityObj.f_19853_.m_7702_(blockposGoal)) instanceof ChestBlockEntity && this.hasFoodSource((Container)(chest = (ChestBlockEntity)tile));
    }

    public boolean hasFoodSource(Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().m_41472_()) continue;
            return true;
        }
        return false;
    }

    public ItemStack consumeOneStackSizeOfFoodAtHome() {
        BlockEntity tile;
        BlockPos blockposGoal = this.entityObj.m_21534_();
        if (!blockposGoal.equals((Object)BlockPos.f_121853_) && (tile = this.entityObj.f_19853_.m_7702_(blockposGoal)) instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            return this.consumeOneStackSizeOfFood((Container)chest);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack consumeOneStackSizeOfFood(Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_41720_().m_41472_()) continue;
            stack.m_41774_(1);
            if (stack.m_41613_() <= 0) {
                inv.m_6836_(i, ItemStack.f_41583_);
            }
            ItemStack newStack = stack.m_41777_();
            newStack.m_41764_(1);
            return newStack;
        }
        return ItemStack.f_41583_;
    }
}

