/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.tropicraft.core.common.Util;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityAIGoneFishin
extends Goal {
    private FISHING_STATE state = FISHING_STATE.IDLE;
    private boolean debugTask = false;
    private EntityKoaBase entity;
    private RandomSource rand;
    private BlockPos posLastWaterFound;
    private BlockPos posLastLandFound;
    private int walkingTimeoutMax = 600;
    private int fishingTimeoutMax = 600;
    private int walkingTimeout;
    private int fishingTimeout;
    private float moveSpeedAmp = 1.0f;
    private int fishCaught = 0;
    private int repathPenalty = 0;
    private int repathPenaltyMax = 60;
    private int repathAttempts = 0;
    public long timeBetweenFishing = 1200L;
    public long timeBetweenFishingRandom = 30L;
    public List<ItemStack> listFishables = new ArrayList<ItemStack>();

    public EntityAIGoneFishin(EntityKoaBase entity) {
        this.entity = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.rand = RandomSource.m_216327_();
        this.walkingTimeout = this.walkingTimeoutMax;
        this.fishingTimeout = this.fishingTimeoutMax;
        this.listFishables.add(new ItemStack((ItemLike)Items.f_42528_));
        this.listFishables.add(new ItemStack((ItemLike)TropicraftItems.FRESH_MARLIN.get()));
        this.listFishables.add(new ItemStack((ItemLike)TropicraftItems.TROPICAL_FERTILIZER.get()));
        this.listFishables.add(new ItemStack((ItemLike)TropicraftItems.RAW_RAY.get()));
    }

    public void m_8056_() {
        this.entity.setFishingItem();
    }

    public boolean m_8036_() {
        this.entity.lastTimeFished = 0L;
        this.debugTask = false;
        BlockPos blockpos = this.entity.m_20183_();
        if (!this.entity.f_19853_.m_46461_() || this.entity.f_19853_.m_46471_() && ((Biome)this.entity.f_19853_.m_204166_(blockpos).m_203334_()).m_47530_() == Biome.Precipitation.RAIN) {
            return false;
        }
        boolean result = false;
        if (this.entity.lastTimeFished < this.entity.f_19853_.m_46467_() && this.entity.f_19853_.f_46441_.m_188503_(3) == 0) {
            BlockPos posWater = this.findWater();
            if (posWater == null) {
                posWater = Util.findBlock((Mob)this.entity, 5, Util::isDeepWater);
            }
            if (posWater != null) {
                if (Util.tryMoveToXYZLongDist((Mob)this.entity, posWater, this.moveSpeedAmp)) {
                    this.posLastWaterFound = posWater;
                    result = true;
                    this.entity.lastTimeFished = this.entity.f_19853_.m_46467_() + this.timeBetweenFishing + this.timeBetweenFishingRandom;
                    this.setState(FISHING_STATE.WALKING_TO_WATER);
                    this.debug("found water, start executing");
                } else {
                    this.debug("failed the path, skip executing");
                }
            } else {
                this.debug("couldnt find water, skip executing");
            }
        }
        return result;
    }

    public boolean m_8045_() {
        return this.posLastWaterFound != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_8037_() {
        super.m_8037_();
        if (this.repathPenalty > 0) {
            --this.repathPenalty;
        }
        if (this.state == FISHING_STATE.IDLE) {
            if (this.posLastWaterFound == null) {
                this.posLastWaterFound = this.findWater();
            }
            if (this.posLastWaterFound == null) {
                if (this.rand.m_188503_(150) != 0) return;
                if (!this.entity.m_21573_().m_26571_()) return;
                return;
            }
            if (Util.tryMoveToXYZLongDist((Mob)this.entity, this.posLastWaterFound, this.moveSpeedAmp)) {
                this.setState(FISHING_STATE.WALKING_TO_WATER);
                return;
            }
            this.debug("found water but pathing failed, abort");
            this.m_8041_();
            return;
        }
        if (this.state == FISHING_STATE.WALKING_TO_WATER) {
            if (this.posLastWaterFound == null) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            if (!this.entity.m_20069_()) {
                if (this.walkingTimeout <= 0 || this.entity.m_21573_().m_26571_()) {
                    if (this.walkingTimeout <= 0) {
                        this.debug("water pathing taking too long");
                    } else if (this.entity.m_21573_().m_26571_()) {
                        this.debug("water pathing having no path, pf find failed?");
                    }
                    if (!Util.tryMoveToXYZLongDist((Mob)this.entity, this.posLastWaterFound, this.moveSpeedAmp)) {
                        this.m_8041_();
                        return;
                    }
                    this.debug("found new path to try");
                }
            } else {
                BlockPos posLand = this.findLand();
                if (posLand != null) {
                    this.posLastLandFound = posLand;
                    if (!Util.tryMoveToXYZLongDist((Mob)this.entity, posLand, this.moveSpeedAmp)) {
                        this.m_8041_();
                        return;
                    }
                    this.setState(FISHING_STATE.WALKING_TO_LAND);
                }
            }
            if (Util.getDistance((Entity)this.entity, this.posLastWaterFound.m_123341_(), this.posLastWaterFound.m_123342_(), this.posLastWaterFound.m_123343_()) < 8.0 || this.entity.m_20069_()) {
                this.entity.m_21573_().m_26573_();
                this.setState(FISHING_STATE.FISHING);
                this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
                this.castLine();
            }
            if (this.walkingTimeout <= 0) return;
            --this.walkingTimeout;
            return;
        }
        BlockPos homePosition = this.entity.m_21534_();
        if (this.state == FISHING_STATE.FISHING) {
            BlockPos posLand;
            if (this.entity.m_20069_() && (posLand = this.findLand()) != null) {
                this.posLastLandFound = posLand;
                if (!Util.tryMoveToXYZLongDist((Mob)this.entity, posLand, this.moveSpeedAmp)) {
                    this.m_8041_();
                    return;
                }
                this.setState(FISHING_STATE.WALKING_TO_LAND);
            }
            if (this.entity.getLure() != null && (this.entity.getLure().m_20096_() || this.entity.getLure().caughtEntity != null)) {
                this.m_8041_();
            }
            if (!this.ifCaughtFish()) {
                --this.fishingTimeout;
                return;
            }
            this.retractLine();
            ++this.fishCaught;
            this.entity.inventory.m_19173_(this.listFishables.get(this.rand.m_188503_(this.listFishables.size())));
            this.debug("caught a fish");
            if (this.getFishCount() > 4 || this.rand.m_188503_(1) == 0 && this.getFishCount() >= 2) {
                if (Util.tryMoveToXYZLongDist((Mob)this.entity, homePosition, this.moveSpeedAmp)) {
                    this.setState(FISHING_STATE.RETURN_TO_BASE);
                    return;
                }
                this.m_8041_();
                return;
            }
            if (this.rand.m_188503_(2) == 0) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            if (this.posLastWaterFound == null) {
                this.setState(FISHING_STATE.IDLE);
                return;
            }
            this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
            this.castLine();
            return;
        }
        if (this.state == FISHING_STATE.RETURN_TO_BASE) {
            if (homePosition.equals((Object)BlockPos.f_121853_)) {
                this.m_8041_();
            }
            if (Util.getDistance((Entity)this.entity, homePosition.m_123341_(), homePosition.m_123342_(), homePosition.m_123343_()) < 3.0) {
                this.debug("dropping off fish, reset");
                this.fishCaught = 0;
                this.entity.tryDumpInventoryIntoHomeChest();
                this.m_8041_();
            }
            if ((this.walkingTimeout <= 0 || this.entity.m_21573_().m_26571_() && this.entity.f_19853_.m_46467_() % 20L == 0L) && !this.retryPathOrAbort(homePosition)) {
                return;
            }
            if (this.walkingTimeout <= 0) return;
            --this.walkingTimeout;
            return;
        }
        if (this.state != FISHING_STATE.WALKING_TO_LAND) return;
        if (Util.getDistance((Entity)this.entity, this.posLastLandFound.m_123341_(), this.posLastLandFound.m_123342_(), this.posLastLandFound.m_123343_()) < 5.0 || this.entity.m_20096_()) {
            this.posLastLandFound = new BlockPos((Vec3i)this.entity.m_20183_());
            this.entity.m_21573_().m_26573_();
            this.setState(FISHING_STATE.FISHING);
            this.faceCoord(this.posLastWaterFound, 180.0f, 180.0f);
            this.castLine();
            return;
        }
        if (this.walkingTimeout <= 0 || this.entity.m_21573_().m_26571_()) {
            if (this.walkingTimeout <= 0) {
                this.debug("pathing taking too long");
            } else if (this.entity.m_21573_().m_26571_()) {
                this.debug("pathing having no path, pf find failed?");
            }
            if (Util.getDistance((Entity)this.entity, this.posLastLandFound.m_123341_(), this.posLastLandFound.m_123342_(), this.posLastLandFound.m_123343_()) < 64.0 ? !this.retryPathOrAbort(this.posLastLandFound) : !this.retryPathOrAbort(this.posLastWaterFound)) {
                return;
            }
        }
        if (this.walkingTimeout <= 0) return;
        --this.walkingTimeout;
    }

    private void setState(FISHING_STATE state) {
        this.debug("setting state from " + this.state + " to " + state + " - " + this.entity.m_20183_());
        if (state != FISHING_STATE.FISHING) {
            this.retractLine();
        }
        this.state = state;
        if (this.state == FISHING_STATE.FISHING) {
            this.fishingTimeout = this.fishingTimeoutMax;
        } else if (this.state == FISHING_STATE.WALKING_TO_LAND || this.state == FISHING_STATE.WALKING_TO_WATER || this.state == FISHING_STATE.RETURN_TO_BASE) {
            this.walkingTimeout = this.walkingTimeoutMax;
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.debug("reset task");
        this.fishCaught = 0;
        this.posLastLandFound = null;
        this.posLastWaterFound = null;
        this.repathAttempts = 0;
        this.retractLine();
        this.state = FISHING_STATE.IDLE;
    }

    private void maintainPathToBlock(BlockPos pos) {
        if (this.repathPenalty <= 0) {
            this.walkingTimeout = this.walkingTimeoutMax;
            boolean success = Util.tryMoveToXYZLongDist((Mob)this.entity, pos, this.moveSpeedAmp);
            if (!success) {
                this.debug("repathing failed - " + this.entity.m_19879_() + " - " + this.state + " - " + pos);
                this.repathPenalty = this.repathPenaltyMax;
            }
        }
    }

    private boolean retryPathOrAbort(BlockPos pos) {
        boolean success = Util.tryMoveToXYZLongDist((Mob)this.entity, pos, this.moveSpeedAmp);
        if (!success) {
            this.debug("repathing failed, resetting - " + this.entity.m_19879_() + " - " + this.state + " - " + pos);
            this.m_8041_();
        } else {
            this.debug("repathing success - " + this.entity.m_19879_() + " - " + this.state + " - " + pos);
            this.walkingTimeout = this.walkingTimeoutMax;
        }
        return success;
    }

    private void debug(String str) {
        if (this.debugTask) {
            System.out.println(str);
        }
    }

    private BlockPos findWater() {
        return Util.findBlock((Mob)this.entity, 60, Util::isDeepWater);
    }

    private BlockPos findLand() {
        return Util.findBlock((Mob)this.entity, 60, Util::isLand);
    }

    private int getFishCount() {
        return this.fishCaught;
    }

    private boolean ifCaughtFish() {
        return this.fishingTimeout <= 40;
    }

    private void castLine() {
        this.fishingTimeout = this.fishingTimeoutMax;
        this.retractLine();
        this.entity.m_6674_(InteractionHand.MAIN_HAND);
        FishingBobberEntity lure = new FishingBobberEntity(this.entity, this.entity.f_19853_, 0, 0);
        this.entity.f_19853_.m_7967_((Entity)lure);
    }

    private void retractLine() {
        if (this.entity.getLure() != null) {
            this.entity.getLure().m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void faceCoord(BlockPos coord, float maxDeltaYaw, float maxDeltaPitch) {
        this.faceCoord(coord.m_123341_(), coord.m_123342_(), coord.m_123343_(), maxDeltaYaw, maxDeltaPitch);
    }

    public void faceCoord(int x, int y, int z, float maxDeltaYaw, float maxDeltaPitch) {
        double d = (double)((float)x + 0.5f) - this.entity.m_20185_();
        double d2 = (double)((float)z + 0.5f) - this.entity.m_20189_();
        double d1 = (double)((float)y + 0.5f) - (this.entity.m_20186_() + (double)this.entity.m_20192_());
        double d3 = Mth.m_14116_((float)((float)(d * d + d2 * d2)));
        float f2 = (float)(Math.atan2(d2, d) * 180.0 / 3.1415927410125732) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / 3.1415927410125732));
        this.entity.m_146926_(-this.updateRotation(this.entity.m_146909_(), f3, maxDeltaPitch));
        this.entity.m_146922_(this.updateRotation(this.entity.m_146908_(), f2, maxDeltaYaw));
    }

    public float updateRotation(float curRotation, float targetRotation, float maxDeltaRotation) {
        float f3;
        for (f3 = targetRotation - curRotation; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        if (f3 > maxDeltaRotation) {
            f3 = maxDeltaRotation;
        }
        if (f3 < -maxDeltaRotation) {
            f3 = -maxDeltaRotation;
        }
        return curRotation + f3;
    }

    static enum FISHING_STATE {
        IDLE,
        WALKING_TO_WATER,
        FISHING,
        RETURN_TO_BASE,
        WALKING_TO_LAND;

    }
}

