/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.ashen;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.tropicraft.core.common.entity.hostile.AshenEntity;
import net.tropicraft.core.common.item.AshenMaskItem;

public class AIAshenShootDart
extends Goal {
    private final AshenEntity entity;
    private int attackCooldown;
    private int attackTime = -1;
    private int seeTime;
    private final float maxAttackDistance;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;
    private float moveSpeedAmplifier;

    public AIAshenShootDart(AshenEntity entity) {
        this.entity = entity;
        this.attackCooldown = 60;
        this.maxAttackDistance = 225.0f;
        this.moveSpeedAmplifier = 1.0f;
    }

    public void setAttackCooldown(int attackCooldown) {
        this.attackCooldown = attackCooldown;
    }

    public boolean m_8036_() {
        ItemStack headGear;
        if (this.entity.m_5448_() != null && (headGear = this.entity.m_5448_().m_6844_(EquipmentSlot.HEAD)).m_41720_() instanceof AshenMaskItem) {
            return false;
        }
        return this.entity.m_5448_() != null && this.entity.hasMask();
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.entity.m_21573_().m_26571_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.seeTime = 0;
        this.attackTime = -1;
        this.entity.m_5810_();
    }

    public void m_8037_() {
        LivingEntity target = this.entity.m_5448_();
        if (target != null) {
            boolean hasSeenEnemy;
            ItemStack headGear = target.m_6844_(EquipmentSlot.HEAD);
            if (headGear.m_41720_() instanceof AshenMaskItem) {
                return;
            }
            double d0 = this.entity.m_20275_(target.m_20185_(), target.m_20191_().f_82289_, target.m_20189_());
            boolean canSeeEnemy = this.entity.m_21574_().m_148306_((Entity)target);
            boolean bl = hasSeenEnemy = this.seeTime > 0;
            if (canSeeEnemy != hasSeenEnemy) {
                this.seeTime = 0;
            }
            this.seeTime = canSeeEnemy ? ++this.seeTime : --this.seeTime;
            if (d0 <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                this.entity.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.entity.m_21573_().m_5624_((Entity)target, (double)this.moveSpeedAmplifier);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.entity.m_217043_().m_188501_() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (d0 > (double)(this.maxAttackDistance * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (d0 < (double)(this.maxAttackDistance * 0.25f)) {
                    this.strafingBackwards = true;
                }
                this.entity.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                this.entity.m_21391_((Entity)target, 30.0f, 30.0f);
            } else {
                this.entity.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            if (this.entity.m_6117_()) {
                int i;
                if (!canSeeEnemy && this.seeTime < -60) {
                    this.entity.m_5810_();
                } else if (canSeeEnemy && (i = this.entity.m_21252_()) >= 20) {
                    this.entity.m_5810_();
                    this.entity.m_6504_(target, 14 - this.entity.f_19853_.m_46791_().m_19028_() * 4);
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.entity.m_6672_(InteractionHand.MAIN_HAND);
            }
        }
    }
}

