/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class MonkeyAngryThrowGoal
extends Goal {
    private final VMonkeyEntity entity;
    private final float speedModifier;
    private final float stopDistance;
    private final PathNavigation navigation;
    private float oldWaterCost;
    private int timeToRecalcPath;
    private int madMeter;
    private ItemEntity trackedMug;
    private LivingEntity trackedPlayer;

    public MonkeyAngryThrowGoal(VMonkeyEntity monkeyEntity) {
        this.entity = monkeyEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.speedModifier = 1.2f;
        this.stopDistance = 1.0f;
        this.navigation = monkeyEntity.m_21573_();
    }

    public void m_8041_() {
        this.navigation.m_26573_();
        this.madMeter = 0;
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
        this.trackedMug = null;
        this.trackedPlayer = null;
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.madMeter = 100;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.trackedMug = null;
        this.trackedPlayer = null;
    }

    public boolean m_8036_() {
        return !this.entity.m_21824_() && !this.entity.m_21523_() && this.entity.isMadAboutStolenAlcohol();
    }

    public boolean m_8045_() {
        return !this.entity.m_21824_() && !this.entity.m_21523_() && this.entity.isMadAboutStolenAlcohol();
    }

    public void m_8037_() {
        if (this.trackedMug != null && this.entity.m_21205_().m_41720_() == ((Item)TropicraftItems.BAMBOO_MUG.get()).m_5456_()) {
            this.trackedPlayer = this.nearbyPlayer();
            if (this.trackedPlayer != null) {
                this.entity.m_21563_().m_24960_((Entity)this.trackedPlayer, 10.0f, (float)this.entity.m_8132_());
                if (this.entity.m_20280_((Entity)this.trackedPlayer) < 4.0) {
                    this.leapTowardTarget(this.trackedPlayer);
                    this.entity.m_19983_(this.entity.m_21205_());
                    this.entity.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    this.entity.setMadAboutStolenAlcohol(false);
                } else {
                    this.moveTowardsEntity((Entity)this.trackedPlayer);
                }
            }
            return;
        }
        if (this.trackedMug != null && this.trackedMug.m_6084_()) {
            this.entity.m_21563_().m_24960_((Entity)this.trackedMug, 10.0f, (float)this.entity.m_8132_());
            if (this.entity.m_20280_((Entity)this.trackedMug) > (double)(this.stopDistance * this.stopDistance)) {
                this.moveTowardsEntity((Entity)this.trackedMug);
            } else {
                this.entity.m_21008_(InteractionHand.MAIN_HAND, this.trackedMug.m_32055_());
                this.trackedMug.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            return;
        }
        if (--this.madMeter <= 0) {
            this.entity.setMadAboutStolenAlcohol(false);
            return;
        }
        this.trackedMug = this.nearbyMug();
    }

    private LivingEntity nearbyPlayer() {
        List list = this.entity.f_19853_.m_45976_(Player.class, this.entity.m_20191_().m_82400_(20.0));
        if (!list.isEmpty()) {
            for (Player entityliving : list) {
                if (entityliving.m_20145_()) continue;
                return entityliving;
            }
        }
        return null;
    }

    private void moveTowardsEntity(Entity itemEntity) {
        if (--this.timeToRecalcPath <= 0) {
            double d2;
            double d1;
            this.timeToRecalcPath = 10;
            double d0 = this.entity.m_20185_() - itemEntity.m_20185_();
            double d3 = d0 * d0 + (d1 = this.entity.m_20186_() - itemEntity.m_20186_()) * d1 + (d2 = this.entity.m_20189_() - itemEntity.m_20189_()) * d2;
            if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                this.navigation.m_5624_(itemEntity, (double)this.speedModifier);
            } else {
                this.navigation.m_26573_();
                if (d3 <= (double)this.stopDistance) {
                    double d4 = itemEntity.m_20185_() - this.entity.m_20185_();
                    double d5 = itemEntity.m_20189_() - this.entity.m_20189_();
                    this.navigation.m_26519_(this.entity.m_20185_() - d4, this.entity.m_20186_(), this.entity.m_20189_() - d5, (double)this.speedModifier);
                }
            }
        }
    }

    private void leapTowardTarget(LivingEntity leapTarget) {
        if (leapTarget == null) {
            return;
        }
        double d0 = leapTarget.m_20185_() - this.entity.m_20185_();
        double d1 = leapTarget.m_20189_() - this.entity.m_20189_();
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1)));
        Vec3 motion = this.entity.m_20184_();
        if ((double)f >= 1.0E-4) {
            this.entity.m_20256_(motion.m_82520_(d0 / (double)f * 0.5 * (double)0.8f + motion.f_82479_ * (double)0.2f, 0.0, d1 / (double)f * 0.5 * (double)0.8f + motion.f_82481_ * (double)0.2f));
        }
        this.entity.m_20256_(new Vec3(motion.f_82479_, 0.25, motion.f_82481_));
    }

    private ItemEntity nearbyMug() {
        List list = this.entity.f_19853_.m_45976_(ItemEntity.class, this.entity.m_20191_().m_82400_(10.0));
        if (!list.isEmpty()) {
            for (ItemEntity item : list) {
                if (item.m_20145_() || !item.m_32055_().m_41656_(new ItemStack((ItemLike)TropicraftItems.BAMBOO_MUG.get())) || !item.m_6084_()) continue;
                return item;
            }
        }
        return null;
    }
}

