/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.ai.vmonkey;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.neutral.VMonkeyEntity;

public class MonkeyFollowNearestPinaColadaHolderGoal
extends Goal {
    private final VMonkeyEntity monkey;
    private final float areaSize;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public MonkeyFollowNearestPinaColadaHolderGoal(VMonkeyEntity entity, double speedModifier, float stopDistance, float areaSize) {
        this.monkey = entity;
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
        this.areaSize = areaSize;
        this.navigation = this.monkey.m_21573_();
    }

    public boolean m_8036_() {
        if (this.monkey.m_21827_()) {
            return false;
        }
        if (this.monkey.m_21824_()) {
            return false;
        }
        if (this.monkey.selfHoldingDrink(Drink.PINA_COLADA)) {
            return false;
        }
        List list = this.monkey.f_19853_.m_6443_(Player.class, this.monkey.m_20191_().m_82400_((double)this.areaSize), VMonkeyEntity.FOLLOW_PREDICATE);
        if (!list.isEmpty()) {
            for (Player entityliving : list) {
                if (entityliving.m_20145_()) continue;
                this.monkey.setFollowing((LivingEntity)entityliving);
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.monkey.getFollowing() == null) {
            return false;
        }
        return VMonkeyEntity.FOLLOW_PREDICATE.test((Object)this.monkey.getFollowing()) && this.m_8036_() && !this.navigation.m_26571_() && this.monkey.m_20280_((Entity)this.monkey.getFollowing()) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.monkey.m_21439_(BlockPathTypes.WATER);
        this.monkey.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.monkey.setFollowing(null);
        this.navigation.m_26573_();
        this.monkey.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        LivingEntity following = this.monkey.getFollowing();
        if (following != null && !this.monkey.m_21523_()) {
            this.monkey.m_21563_().m_24960_((Entity)following, 10.0f, (float)this.monkey.m_8132_());
            if (--this.timeToRecalcPath <= 0) {
                double zDist;
                double yDist;
                this.timeToRecalcPath = 10;
                double xDist = this.monkey.m_20185_() - following.m_20185_();
                double sqrDist = xDist * xDist + (yDist = this.monkey.m_20186_() - following.m_20186_()) * yDist + (zDist = this.monkey.m_20189_() - following.m_20189_()) * zDist;
                if (sqrDist > (double)(this.stopDistance * this.stopDistance)) {
                    this.navigation.m_5624_((Entity)following, this.speedModifier);
                } else {
                    this.navigation.m_26573_();
                    if (sqrDist <= (double)this.stopDistance) {
                        double xDist2 = following.m_20185_() - this.monkey.m_20185_();
                        double zDist2 = following.m_20189_() - this.monkey.m_20189_();
                        this.navigation.m_26519_(this.monkey.m_20185_() - xDist2, this.monkey.m_20186_(), this.monkey.m_20189_() - zDist2, this.speedModifier);
                    }
                }
            }
        }
    }
}

