/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.egg;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.egg.EchinodermEggEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishEntity;
import net.tropicraft.core.common.entity.underdasea.StarfishType;
import net.tropicraft.core.common.item.TropicraftItems;

public class StarfishEggEntity
extends EchinodermEggEntity
implements IEntityAdditionalSpawnData {
    private StarfishType starfishType;

    public StarfishEggEntity(EntityType<? extends StarfishEggEntity> type, Level world) {
        super((EntityType<? extends EchinodermEggEntity>)type, world);
        this.starfishType = StarfishType.values()[this.f_19796_.m_188503_(StarfishType.values().length)];
    }

    public StarfishType getStarfishType() {
        return this.starfishType;
    }

    public void setStarfishType(StarfishType starfishType) {
        this.starfishType = starfishType;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeByte(this.starfishType.ordinal());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        this.starfishType = StarfishType.values()[additionalData.readByte()];
    }

    @Override
    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("StarfishType", (byte)this.getStarfishType().ordinal());
    }

    @Override
    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setStarfishType(StarfishType.values()[nbt.m_128445_("StarfishType")]);
    }

    @Override
    public String getEggTexture() {
        return "starfishegg";
    }

    @Override
    public Entity onHatch() {
        StarfishEntity baby = new StarfishEntity((EntityType<? extends StarfishEntity>)((EntityType)TropicraftEntities.STARFISH.get()), this.f_19853_);
        baby.setBaby();
        baby.setStarfishType(this.starfishType);
        return baby;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.STARFISH.get());
    }
}

