/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.hostile;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.ashen.AIAshenChaseAndPickupLostMask;
import net.tropicraft.core.common.entity.ai.ashen.AIAshenShootDart;
import net.tropicraft.core.common.entity.ai.ashen.EntityAIMeleeAndRangedAttack;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.entity.passive.EntityKoaBase;
import net.tropicraft.core.common.entity.placeable.AshenMaskEntity;
import net.tropicraft.core.common.item.AshenMaskItem;
import net.tropicraft.core.common.item.AshenMasks;
import net.tropicraft.core.common.item.BlowGunItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class AshenEntity
extends TropicraftCreatureEntity
implements RangedAttackMob {
    private static final EntityDataAccessor<Byte> MASK_TYPE = SynchedEntityData.m_135353_(AshenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> ACTION_STATE = SynchedEntityData.m_135353_(AshenEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public AshenMaskEntity maskToTrack;

    public AshenEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.setActionState(AshenState.HOSTILE);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)TropicraftItems.BLOW_GUN.get()));
        this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)TropicraftItems.DAGGER.get()));
        this.setMaskType((byte)AshenMasks.VALUES[world.m_213780_().m_188503_(AshenMasks.VALUES.length)].ordinal());
        this.setActionState(AshenState.HOSTILE);
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(MASK_TYPE, (Object)0);
        this.m_20088_().m_135372_(ACTION_STATE, (Object)((byte)AshenState.HOSTILE.ordinal()));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AIAshenChaseAndPickupLostMask(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new AIAshenShootDart(this));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new EntityAIMeleeAndRangedAttack(this, 1.0, 40, 200, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, EntityKoaBase.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 3.0);
    }

    public boolean hasMask() {
        return this.getActionState() != AshenState.LOST_MASK;
    }

    public void setMaskType(byte type) {
        this.m_20088_().m_135381_(MASK_TYPE, (Object)type);
    }

    public byte getMaskType() {
        return (Byte)this.m_20088_().m_135370_(MASK_TYPE);
    }

    public void setActionState(AshenState state) {
        this.m_20088_().m_135381_(ACTION_STATE, (Object)((byte)state.ordinal()));
    }

    public AshenState getActionState() {
        return AshenState.VALUES[this.getActionStateValue()];
    }

    private byte getActionStateValue() {
        return (Byte)this.m_20088_().m_135370_(ACTION_STATE);
    }

    public void m_6504_(LivingEntity target, float velocity) {
        ItemStack headGear = target.m_6844_(EquipmentSlot.HEAD);
        if (headGear.m_41720_() instanceof AshenMaskItem) {
            return;
        }
        Arrow tippedArrow = BlowGunItem.createArrow(this.f_19853_, (LivingEntity)this, BlowGunItem.getProjectile());
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20191_().f_82289_ + (double)(target.m_20206_() / 3.0f) - tippedArrow.m_20186_();
        double d2 = target.m_20189_() - this.m_20189_();
        double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        tippedArrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, velocity);
        tippedArrow.m_36781_(1.0);
        tippedArrow.m_36735_(0);
        this.m_5496_(SoundEvents.f_11847_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)tippedArrow);
    }

    public boolean m_6469_(DamageSource source, float amt) {
        boolean wasHit = super.m_6469_(source, amt);
        if (!this.f_19853_.f_46443_ && this.hasMask() && wasHit && !source.equals(DamageSource.f_19317_)) {
            this.dropMask();
        }
        return wasHit;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128344_("MaskType", this.getMaskType());
        nbt.m_128344_("ActionState", this.getActionStateValue());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setMaskType(nbt.m_128445_("MaskType"));
        this.setActionState(AshenState.VALUES[nbt.m_128445_("ActionState")]);
    }

    public void dropMask() {
        this.setActionState(AshenState.LOST_MASK);
        this.maskToTrack = new AshenMaskEntity((EntityType)TropicraftEntities.ASHEN_MASK.get(), this.f_19853_);
        this.maskToTrack.setMaskType(this.getMaskType());
        this.maskToTrack.m_19890_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), 0.0f);
        this.f_19853_.m_7967_((Entity)this.maskToTrack);
    }

    public void pickupMask(AshenMaskEntity mask) {
        this.setActionState(AshenState.HOSTILE);
        this.maskToTrack = null;
        this.setMaskType(mask.getMaskType());
        mask.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.ASHEN_SPAWN_EGG.get());
    }

    public static enum AshenState {
        PEACEFUL,
        LOST_MASK,
        HOSTILE;

        public static final AshenState[] VALUES;

        static {
            VALUES = AshenState.values();
        }
    }
}

