/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.sound.Sounds;

public class IguanaEntity
extends TropicraftCreatureEntity {
    private int angerLevel;
    private UUID angerTargetUUID;
    private static final UUID ATTACK_SPEED_BOOST_MODIFIER_UUID = UUID.fromString("49455A49-7EC5-45BA-B886-3B90B23A1718");
    private static final AttributeModifier ATTACK_SPEED_BOOST_MODIFIER = new AttributeModifier(ATTACK_SPEED_BOOST_MODIFIER_UUID, "Attacking speed boost", 0.05, AttributeModifier.Operation.ADDITION);

    public IguanaEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.IGUANA_SPAWN_EGG.get());
    }

    public void m_6703_(@Nullable LivingEntity entity) {
        super.m_6703_(entity);
        if (entity != null) {
            this.angerTargetUUID = entity.m_20148_();
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 5.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByAggressorGoal(this));
        this.f_21346_.m_25352_(2, (Goal)new TargetAggressorGoal(this));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128376_("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.m_128359_("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.m_128359_("HurtBy", "");
        }
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.angerLevel = compound.m_128448_("Anger");
        String hurtBy = compound.m_128461_("HurtBy");
        if (!hurtBy.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(hurtBy);
            Player entityplayer = this.f_19853_.m_46003_(this.angerTargetUUID);
            this.m_6703_((LivingEntity)entityplayer);
            if (entityplayer != null) {
                this.f_20888_ = entityplayer;
                this.f_20889_ = this.m_21213_();
            }
        }
    }

    protected void m_8024_() {
        AttributeInstance attribute = this.m_21051_(Attributes.f_22279_);
        if (this.isAngry()) {
            if (!this.m_6162_() && !attribute.m_22109_(ATTACK_SPEED_BOOST_MODIFIER)) {
                attribute.m_22118_(ATTACK_SPEED_BOOST_MODIFIER);
            }
            --this.angerLevel;
        } else if (attribute.m_22109_(ATTACK_SPEED_BOOST_MODIFIER)) {
            attribute.m_22130_(ATTACK_SPEED_BOOST_MODIFIER);
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.m_21188_() == null) {
            Player entityplayer = this.f_19853_.m_46003_(this.angerTargetUUID);
            this.m_6703_((LivingEntity)entityplayer);
            this.f_20888_ = entityplayer;
            this.f_20889_ = this.m_21213_();
        }
        super.m_8024_();
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        if (this.m_6673_(damageSource)) {
            return false;
        }
        Entity sourceEntity = damageSource.m_7639_();
        if (sourceEntity instanceof Player && !((Player)sourceEntity).m_7500_() && this.m_142582_(sourceEntity)) {
            this.becomeAngryAt(sourceEntity);
        }
        return super.m_6469_(damageSource, amount);
    }

    private boolean becomeAngryAt(Entity target) {
        this.angerLevel = 400 + this.f_19796_.m_188503_(400);
        if (target instanceof LivingEntity) {
            this.m_6703_((LivingEntity)target);
        }
        return true;
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.IGGY_LIVING.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)Sounds.IGGY_ATTACK.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Sounds.IGGY_DEATH.get();
    }

    static class HurtByAggressorGoal
    extends HurtByTargetGoal {
        public HurtByAggressorGoal(IguanaEntity iguana) {
            super((PathfinderMob)iguana, new Class[0]);
            this.m_26044_(new Class[]{IguanaEntity.class});
        }

        protected void m_5766_(Mob mob, LivingEntity target) {
            if (mob instanceof IguanaEntity && this.f_26135_.m_142582_((Entity)target) && ((IguanaEntity)mob).becomeAngryAt((Entity)target)) {
                mob.m_6710_(target);
            }
        }
    }

    static class TargetAggressorGoal
    extends NearestAttackableTargetGoal<Player> {
        public TargetAggressorGoal(IguanaEntity iggy) {
            super((Mob)iggy, Player.class, true);
        }

        public boolean m_8036_() {
            return ((IguanaEntity)this.f_26135_).isAngry() && super.m_8036_();
        }
    }
}

