/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.hostile.TropicraftCreatureEntity;
import net.tropicraft.core.common.entity.projectile.PoisonBlotEntity;
import net.tropicraft.core.common.item.TropicraftItems;
import net.tropicraft.core.common.sound.Sounds;

public class TreeFrogEntity
extends TropicraftCreatureEntity
implements Enemy,
RangedAttackMob {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(TreeFrogEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private NearestAttackableTargetGoal<Player> hostileAI;
    public int jumpDelay = 0;
    private int attackTime;

    public TreeFrogEntity(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.f_21364_ = 5;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 60, 10.0f));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!(this.m_21573_().m_26571_() && this.m_5448_() == null || !this.f_19861_ && !this.m_20069_())) {
            if (this.jumpDelay > 0) {
                --this.jumpDelay;
            }
            if (this.jumpDelay <= 0) {
                this.jumpDelay = 5 + this.f_19796_.m_188503_(4);
                Vec3 motion = this.m_20184_();
                double speed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
                if (speed > 0.02) {
                    double motionY = motion.f_82480_ + 0.4;
                    double motionX = motion.f_82479_ * 1.1;
                    double motionZ = motion.f_82481_ * 1.1;
                    this.m_20334_(motionX, motionY, motionZ);
                }
            }
        }
        if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(TYPE, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("Type", this.getFrogType());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setFrogType(nbt.m_128451_("Type"));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        int type = this.f_19796_.m_188503_(Type.values().length);
        this.setFrogType(type);
        if (type != 0) {
            this.hostileAI = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
            this.f_21346_.m_25352_(1, this.hostileAI);
        }
        return super.m_6518_(world, difficulty, reason, spawnData, dataTag);
    }

    public void setFrogType(int i) {
        this.f_19804_.m_135381_(TYPE, (Object)i);
    }

    public int getFrogType() {
        return (Integer)this.f_19804_.m_135370_(TYPE);
    }

    public String getColor() {
        return Type.values()[this.getFrogType()].getColor();
    }

    public void m_6504_(LivingEntity entity, float dist) {
        if (dist < 4.0f && !this.f_19853_.f_46443_ && this.attackTime == 0 && this.f_19853_.m_46791_() != Difficulty.PEACEFUL) {
            double d = entity.m_20185_() - this.m_20185_();
            double d1 = entity.m_20189_() - this.m_20189_();
            PoisonBlotEntity poison = new PoisonBlotEntity((EntityType<? extends ThrowableProjectile>)((EntityType)TropicraftEntities.POISON_BLOT.get()), (LivingEntity)this, this.f_19853_);
            poison.m_6034_(poison.m_20185_(), poison.m_20186_() + (double)1.4f, poison.m_20189_());
            double shotHeight = entity.m_20186_() + (double)entity.m_20192_() - (double)0.2f - poison.m_20186_();
            float f1 = Mth.m_14116_((float)((float)(d * d + d1 * d1))) * 0.2f;
            entity.m_20193_().m_5594_(null, entity.m_20183_(), (SoundEvent)Sounds.FROG_SPIT.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            this.f_19853_.m_7967_((Entity)poison);
            poison.m_6686_(d, shotHeight + (double)f1, d1, 0.6f, 12.0f);
            this.attackTime = 50;
            this.m_146922_((float)(Math.atan2(d1, d) * 180.0 / 3.1415927410125732) - 90.0f);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.TREE_FROG_SPAWN_EGG.get());
    }

    public static enum Type {
        GREEN("green"),
        RED("red"),
        BLUE("blue"),
        YELLOW("yellow");

        final String color;

        private Type(String s) {
            this.color = s;
        }

        public String getColor() {
            return this.color;
        }
    }
}

