/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.neutral;

import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.drinks.Drink;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyAngryThrowGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyFollowNearestPinaColadaHolderGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyPickUpPinaColadaGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeySitAndDrinkGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeySitInChairGoal;
import net.tropicraft.core.common.entity.ai.vmonkey.MonkeyStealDrinkGoal;
import net.tropicraft.core.common.item.CocktailItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class VMonkeyEntity
extends TamableAnimal {
    private static final EntityDataAccessor<Byte> DATA_FLAGS = SynchedEntityData.m_135353_(VMonkeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final int FLAG_CLIMBING = 1;
    public static final Predicate<LivingEntity> FOLLOW_PREDICATE = ent -> {
        if (ent == null) {
            return false;
        }
        if (!(ent instanceof Player)) {
            return false;
        }
        Player player = (Player)ent;
        ItemStack heldMain = player.m_21205_();
        ItemStack heldOff = player.m_21206_();
        if (heldMain.m_41720_() instanceof CocktailItem && CocktailItem.getDrink(heldMain) == Drink.PINA_COLADA) {
            return true;
        }
        if (heldOff.m_41720_() instanceof CocktailItem) {
            return CocktailItem.getDrink(heldOff) == Drink.PINA_COLADA;
        }
        return false;
    };
    private LivingEntity following;
    private boolean madAboutStolenAlcohol;

    public VMonkeyEntity(EntityType<? extends TamableAnimal> type, Level world) {
        super(type, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS, (Object)0);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new MonkeyFollowNearestPinaColadaHolderGoal(this, 1.0, 2.0f, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(3, (Goal)new MonkeyPickUpPinaColadaGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MonkeyStealDrinkGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MonkeySitAndDrinkGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new MonkeyAngryThrowGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new MonkeySitInChairGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("MonkeyFlags", this.getMonkeyFlags());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setMonkeyFlags(compound.m_128445_("MonkeyFlags"));
    }

    public LivingEntity getFollowing() {
        return this.following;
    }

    public void setFollowing(@Nullable LivingEntity following) {
        this.following = following;
    }

    public boolean selfHoldingDrink(Drink drink) {
        ItemStack heldItem = this.m_21205_();
        if (heldItem.m_41720_() instanceof CocktailItem) {
            return CocktailItem.getDrink(heldItem) == drink;
        }
        return false;
    }

    private void setMonkeyFlags(byte flags) {
        this.m_20088_().m_135381_(DATA_FLAGS, (Object)flags);
    }

    private byte getMonkeyFlags() {
        return (Byte)this.m_20088_().m_135370_(DATA_FLAGS);
    }

    public boolean isClimbing() {
        return this.getMonkeyFlag(1);
    }

    private void setClimbing(boolean state) {
        this.setMonkeyFlag(1, state);
    }

    public void setMonkeyFlag(int id, boolean flag) {
        if (flag) {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS) | id)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS, (Object)((byte)((Byte)this.f_19804_.m_135370_(DATA_FLAGS) & ~id)));
        }
    }

    private boolean getMonkeyFlag(int flag) {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS) & flag) != 0;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)player) && !this.f_19853_.f_46443_) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21561_(false);
            }
        } else if (!stack.m_41619_() && this.m_6898_(stack)) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (!this.f_19853_.f_46443_) {
                if (this.f_19796_.m_188503_(3) == 0) {
                    this.m_7105_(true);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_21839_(true);
                    this.m_21153_(20.0f);
                    this.m_21816_(player.m_20148_());
                    this.f_19853_.m_7605_((Entity)this, (byte)7);
                } else {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.PASS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack stack) {
        return CocktailItem.getDrink(stack) == Drink.PINA_COLADA;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        return !this.m_21824_() && target.m_6095_() == EntityType.f_20532_;
    }

    public boolean m_7327_(Entity entity) {
        boolean damaged = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21051_(Attributes.f_22281_).m_22135_());
        if (damaged) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return damaged;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity entity = source.m_7639_();
        this.m_21839_(false);
        if (entity != null && entity.m_6095_() != EntityType.f_20532_ && !(entity instanceof Arrow)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.V_MONKEY_SPAWN_EGG.get());
    }

    public boolean isMadAboutStolenAlcohol() {
        return this.madAboutStolenAlcohol;
    }

    public void setMadAboutStolenAlcohol(boolean madAboutStolenAlcohol) {
        this.madAboutStolenAlcohol = madAboutStolenAlcohol;
    }
}

