/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive;

import com.tterrag.registrate.util.entry.ItemEntry;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.entity.TropicraftEntities;
import net.tropicraft.core.common.entity.ai.EntityAIAvoidEntityOnLowHealth;
import net.tropicraft.core.common.entity.ai.EntityAIChillAtFire;
import net.tropicraft.core.common.entity.ai.EntityAIEatToHeal;
import net.tropicraft.core.common.entity.ai.EntityAIGoneFishin;
import net.tropicraft.core.common.entity.ai.EntityAIKoaMate;
import net.tropicraft.core.common.entity.ai.EntityAIPartyTime;
import net.tropicraft.core.common.entity.ai.EntityAIPlayKoa;
import net.tropicraft.core.common.entity.ai.EntityAITemptHelmet;
import net.tropicraft.core.common.entity.ai.EntityAIWanderNotLazy;
import net.tropicraft.core.common.entity.passive.EntityKoaHunter;
import net.tropicraft.core.common.entity.passive.FishingBobberEntity;
import net.tropicraft.core.common.item.TropicraftItems;

public class EntityKoaBase
extends Villager {
    public long lastTimeFished = 0L;
    public BlockPos posLastFireplaceFound = null;
    public List<BlockPos> listPosDrums = new ArrayList<BlockPos>();
    public static int MAX_DRUMS = 12;
    public SimpleContainer inventory;
    private static final EntityDataAccessor<Integer> ROLE = SynchedEntityData.m_135353_(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> GENDER = SynchedEntityData.m_135353_(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.m_135353_(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> LURE_ID = SynchedEntityData.m_135353_(EntityKoaBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float clientHealthLastTracked = 0.0f;
    public static int MAX_HOME_DISTANCE = 128;
    private int villageID = -1;
    private ResourceKey<Level> villageDimension;
    private FishingBobberEntity lure;
    private boolean wasInWater = false;
    private boolean wasNightLastTick = false;
    private boolean wantsToParty = false;
    public boolean jumpingOutOfWater = false;
    public int hitIndex = 0;
    public int hitIndex2 = 0;
    public int hitIndex3 = 0;
    public int hitDelay = 0;
    private long lastTradeTime = 0L;
    private static final int TRADE_COOLDOWN = 72000;
    private static final int DIVE_TIME_NEEDED = 3600;
    public boolean debug = false;
    public int druggedTime = 0;
    private static final Set<ItemEntry<? extends Item>> TEMPTATION_ITEMS = Set.of(TropicraftItems.NIGEL_STACHE);
    private boolean isMating;
    private boolean isPlaying;
    private boolean finalizedSpawn;
    private int updateMerchantTimer;
    private boolean increaseProfessionLevelOnUpdate;
    public static com.google.common.base.Predicate<Entity> ENEMY_PREDICATE = input -> input instanceof Monster;

    public EntityKoaBase(EntityType<? extends EntityKoaBase> type, Level level) {
        super(type, level);
        this.m_21530_();
        this.inventory = new SimpleContainer(9);
    }

    public boolean m_5825_() {
        return true;
    }

    public long getLastTradeTime() {
        return this.lastTradeTime;
    }

    public void setLastTradeTime(long lastTradeTime) {
        this.lastTradeTime = lastTradeTime;
    }

    public Genders getGender() {
        return Genders.get((Integer)this.m_20088_().m_135370_(GENDER));
    }

    public void setGender(Genders gender) {
        this.m_20088_().m_135381_(GENDER, (Object)gender.ordinal());
    }

    public Roles getRole() {
        return Roles.get((Integer)this.m_20088_().m_135370_(ROLE));
    }

    public boolean isSitting() {
        return (Boolean)this.m_20088_().m_135370_(SITTING);
    }

    public void setSitting(boolean sitting) {
        this.m_20088_().m_135381_(SITTING, (Object)sitting);
    }

    public boolean isDancing() {
        return (Boolean)this.m_20088_().m_135370_(DANCING);
    }

    public void setDancing(boolean val) {
        this.m_20088_().m_135381_(DANCING, (Object)val);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ROLE, (Object)0);
        this.m_20088_().m_135372_(GENDER, (Object)0);
        this.m_20088_().m_135372_(SITTING, (Object)false);
        this.m_20088_().m_135372_(DANCING, (Object)false);
        this.m_20088_().m_135372_(LURE_ID, (Object)-1);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (!this.f_19853_.f_46443_) {
            return;
        }
        if (key == LURE_ID) {
            int id = (Integer)this.m_20088_().m_135370_(LURE_ID);
            if (id != -1) {
                this.scheduleEntityLookup(this, id);
            } else {
                this.setLure(null);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void scheduleEntityLookup(EntityKoaBase koa, int id) {
        Minecraft.m_91087_().execute(() -> {
            Entity ent = this.f_19853_.m_6815_(id);
        });
    }

    protected void m_8099_() {
    }

    private Int2ObjectMap<VillagerTrades.ItemListing[]> getTradesByLevel() {
        return switch (this.getRole()) {
            default -> throw new IncompatibleClassChangeError();
            case Roles.FISHERMAN -> EntityKoaBase.getFishermanTrades();
            case Roles.HUNTER -> EntityKoaBase.getHunterTrades();
        };
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getFishermanTrades() {
        Int2ObjectOpenHashMap tradesByLevel = new Int2ObjectOpenHashMap();
        tradesByLevel.put(1, (Object)new VillagerTrades.ItemListing[]{new ItemToPearlTrade((ItemLike)Items.f_42528_, 20, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.FISHING_NET.get(), 1, 8, 2), new ItemToPearlTrade((ItemLike)Items.f_42523_, 1, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.FRESH_MARLIN.get(), 3, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.SARDINE_BUCKET.get(), 1, 4, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.PIRANHA_BUCKET.get(), 1, 3, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.TROPICAL_FERTILIZER.get(), 5, 8, 2)});
        tradesByLevel.put(2, (Object)new VillagerTrades.ItemListing[]{new PearlToItemTrade((ItemLike)TropicraftItems.COOKED_FISH.get(), 8, 1, 8, 10), new PearlToItemTrade((ItemLike)TropicraftItems.COOKED_RAY.get(), 6, 1, 8, 10)});
        tradesByLevel.put(3, (Object)new VillagerTrades.ItemListing[]{new ItemToPearlTrade((ItemLike)TropicraftItems.GRAPEFRUIT.get(), 12, 12, 15), new ItemToPearlTrade((ItemLike)TropicraftItems.LEMON.get(), 12, 12, 15), new ItemToPearlTrade((ItemLike)TropicraftItems.LIME.get(), 12, 12, 15)});
        return tradesByLevel;
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getHunterTrades() {
        Int2ObjectOpenHashMap tradesByLevel = new Int2ObjectOpenHashMap();
        tradesByLevel.put(1, (Object)new VillagerTrades.ItemListing[]{new ItemToPearlTrade((ItemLike)TropicraftItems.FROG_LEG.get(), 5, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.IGUANA_LEATHER.get(), 2, 8, 2), new ItemToPearlTrade((ItemLike)TropicraftItems.SCALE.get(), 5, 8, 2)});
        tradesByLevel.put(2, (Object)new VillagerTrades.ItemListing[]{new PearlToEnchantItemTrade((ItemLike)TropicraftItems.BAMBOO_SPEAR.get(), 1, 8, 10), new ItemToPearlTrade((ItemLike)TropicraftItems.BAMBOO_STICK.get(), 32, 12, 8)});
        tradesByLevel.put(3, (Object)new VillagerTrades.ItemListing[]{new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_HELMET.get(), 4, 4, 15), new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_CHESTPLATE.get(), 6, 4, 15)});
        tradesByLevel.put(4, (Object)new VillagerTrades.ItemListing[]{new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_LEGGINGS.get(), 5, 4, 20), new PearlToEnchantItemTrade((ItemLike)TropicraftItems.SCALE_BOOTS.get(), 4, 4, 20)});
        return tradesByLevel;
    }

    protected void m_7604_() {
        VillagerData data = this.m_7141_();
        VillagerTrades.ItemListing[] possibleTrades = (VillagerTrades.ItemListing[])this.getTradesByLevel().get(data.m_35576_());
        if (possibleTrades != null) {
            this.m_35277_(this.m_6616_(), possibleTrades, 2);
        }
    }

    public void updateUniqueEntityAI() {
        this.f_21345_.m_25386_().forEach(WrappedGoal::m_8041_);
        this.f_21346_.m_25386_().forEach(WrappedGoal::m_8041_);
        int curPri = 0;
        this.f_21345_.m_25352_(curPri++, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(curPri++, new EntityAIAvoidEntityOnLowHealth<LivingEntity>((PathfinderMob)this, LivingEntity.class, (Predicate<Entity>)ENEMY_PREDICATE, 12.0f, 1.4, 1.4, 15.0f));
        this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIEatToHeal(this));
        this.f_21345_.m_25352_(curPri++, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(curPri++, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public void m_8056_() {
                super.m_8056_();
                if (this.f_25540_ instanceof EntityKoaBase) {
                    ((EntityKoaBase)this.f_25540_).setFightingItem();
                }
            }

            protected double m_6639_(LivingEntity attackTarget) {
                return this.f_25540_.m_6095_().m_20680_().f_20377_ * 2.5f * this.f_25540_.m_6095_().m_20680_().f_20377_ * 2.5f + attackTarget.m_6095_().m_20680_().f_20377_;
            }
        });
        this.f_21345_.m_25352_(curPri++, (Goal)new EntityAITemptHelmet((PathfinderMob)this, 1.0, false, TEMPTATION_ITEMS));
        this.f_21345_.m_25352_(curPri++, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIKoaMate(this));
        this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIChillAtFire(this));
        this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIPartyTime(this));
        if (this.canFish()) {
            this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIGoneFishin(this));
        }
        if (this.m_6162_()) {
            this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIPlayKoa(this, 1.2));
        }
        this.f_21345_.m_25352_(curPri, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(curPri++, (Goal)new EntityAIWanderNotLazy((PathfinderMob)this, 1.0, 40));
        this.f_21345_.m_25352_(curPri++, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        if (this.canHunt()) {
            this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, ENEMY_PREDICATE));
        }
    }

    public Villager m_142606_(ServerLevel world, AgeableMob ageable) {
        EntityKoaHunter child = new EntityKoaHunter((EntityType<? extends EntityKoaHunter>)((EntityType)TropicraftEntities.KOA.get()), this.f_19853_);
        child.m_6518_((ServerLevelAccessor)world, world.m_6436_(child.m_20183_()), MobSpawnType.BREEDING, null, null);
        return child;
    }

    protected void m_30232_() {
        super.m_30232_();
        this.updateUniqueEntityAI();
    }

    public boolean canFish() {
        return ((Integer)this.m_20088_().m_135370_(ROLE)).intValue() == Roles.FISHERMAN.ordinal();
    }

    public boolean canHunt() {
        return ((Integer)this.m_20088_().m_135370_(ROLE)).intValue() == Roles.HUNTER.ordinal() && !this.m_6162_();
    }

    public void setHunter() {
        this.m_20088_().m_135381_(ROLE, (Object)Roles.HUNTER.ordinal());
        this.setFightingItem();
    }

    public void setFisher() {
        this.m_20088_().m_135381_(ROLE, (Object)Roles.FISHERMAN.ordinal());
        this.setFishingItem();
    }

    protected void m_8024_() {
        if (!this.m_35306_() && this.updateMerchantTimer > 0 && --this.updateMerchantTimer <= 0) {
            if (this.increaseProfessionLevelOnUpdate) {
                this.m_35528_();
                this.increaseProfessionLevelOnUpdate = false;
            }
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
        }
        this.monitorHomeVillage();
        this.findAndSetHomeToCloseChest(false);
        this.findAndSetFireSource(false);
        this.findAndSetDrums(false);
        this.findAndSetTownID(false);
    }

    public static AttributeSupplier.Builder m_35503_() {
        return Villager.m_35503_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public void m_6710_(@Nullable LivingEntity entitylivingbaseIn) {
        super.m_6710_(entitylivingbaseIn);
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag;
        float damage = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        float knockback = (float)this.m_21133_(Attributes.f_22282_);
        if (entityIn instanceof LivingEntity) {
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entityIn).m_6336_());
            knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if (flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), damage)) {
            int j;
            if (knockback > 0.0f && entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_147240_((double)(knockback * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20334_(this.m_20184_().f_82479_ * 0.6, this.m_20184_().f_82480_, this.m_20184_().f_82481_ * 0.6);
            }
            if ((j = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                entityIn.m_20254_(j * 4);
            }
            if (entityIn instanceof Player) {
                ItemStack itemstack1;
                Player entityplayer = (Player)entityIn;
                ItemStack itemstack = this.m_21205_();
                ItemStack itemStack = itemstack1 = entityplayer.m_6117_() ? entityplayer.m_21211_() : ItemStack.f_41583_;
                if (!itemstack.m_41619_() && !itemstack1.m_41619_() && itemstack.m_41720_() instanceof AxeItem && itemstack1.m_41720_() == Items.f_42740_) {
                    float f1 = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
                    if (this.f_19796_.m_188501_() < f1) {
                        entityplayer.m_36335_().m_41524_(Items.f_42740_, 100);
                        this.f_19853_.m_7605_((Entity)entityplayer, (byte)30);
                    }
                }
            }
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        InteractionResult ret = InteractionResult.PASS;
        try {
            boolean doTrade = true;
            if (!this.f_19853_.f_46443_) {
                ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
                if (!stack.m_41619_() && stack.m_41720_() == TropicraftItems.POISON_FROG_SKIN.get()) {
                    doTrade = false;
                    this.dbg("koa drugged, zapping memory");
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    this.zapMemory();
                    this.druggedTime += 2400;
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19604_, this.druggedTime));
                    this.findAndSetDrums(true);
                }
                if (doTrade) {
                    ret = super.m_6071_(player, hand);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return null;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_21446_(this.m_20183_(), MAX_HOME_DISTANCE);
        this.rollDiceChild();
        this.rollDiceRole();
        this.rollDiceGender();
        this.updateUniqueEntityAI();
        this.finalizedSpawn = true;
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void rollDiceChild() {
        int childChance = 20;
        if (childChance >= this.f_19853_.f_46441_.m_188503_(100)) {
            this.m_146762_(-24000);
        }
    }

    public void rollDiceRole() {
        int randValRole = this.f_19853_.f_46441_.m_188503_(Roles.values().length);
        if (randValRole == Roles.FISHERMAN.ordinal()) {
            this.setFisher();
        } else if (randValRole == Roles.HUNTER.ordinal()) {
            this.setHunter();
        }
    }

    public void rollDiceGender() {
        this.m_20088_().m_135381_(GENDER, (Object)this.f_19796_.m_188503_(Genders.values().length));
    }

    public void m_7380_(CompoundTag compound) {
        int i;
        super.m_7380_(compound);
        compound.m_128405_("home_X", this.m_21534_().m_123341_());
        compound.m_128405_("home_Y", this.m_21534_().m_123342_());
        compound.m_128405_("home_Z", this.m_21534_().m_123343_());
        if (this.posLastFireplaceFound != null) {
            compound.m_128405_("fireplace_X", this.posLastFireplaceFound.m_123341_());
            compound.m_128405_("fireplace_Y", this.posLastFireplaceFound.m_123342_());
            compound.m_128405_("fireplace_Z", this.posLastFireplaceFound.m_123343_());
        }
        compound.m_128356_("lastTimeFished", this.lastTimeFished);
        ListTag nbttaglist = new ListTag();
        for (i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag nbttagcompound = new CompoundTag();
            nbttagcompound.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(nbttagcompound);
            nbttaglist.add((Object)nbttagcompound);
        }
        compound.m_128365_("koa_inventory", (Tag)nbttaglist);
        compound.m_128405_("role_id", ((Integer)this.m_20088_().m_135370_(ROLE)).intValue());
        compound.m_128405_("gender_id", ((Integer)this.m_20088_().m_135370_(GENDER)).intValue());
        compound.m_128405_("village_id", this.villageID);
        if (this.villageDimension != null) {
            compound.m_128359_("village_dimension", this.villageDimension.m_135782_().toString());
        }
        compound.m_128356_("lastTradeTime", this.lastTradeTime);
        for (i = 0; i < this.listPosDrums.size(); ++i) {
            compound.m_128405_("drum_" + i + "_X", this.listPosDrums.get(i).m_123341_());
            compound.m_128405_("drum_" + i + "_Y", this.listPosDrums.get(i).m_123342_());
            compound.m_128405_("drum_" + i + "_Z", this.listPosDrums.get(i).m_123343_());
        }
        compound.m_128405_("druggedTime", this.druggedTime);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("home_X")) {
            this.m_21446_(new BlockPos(compound.m_128451_("home_X"), compound.m_128451_("home_Y"), compound.m_128451_("home_Z")), MAX_HOME_DISTANCE);
        }
        if (compound.m_128441_("fireplace_X")) {
            this.setFirelacePos(new BlockPos(compound.m_128451_("fireplace_X"), compound.m_128451_("fireplace_Y"), compound.m_128451_("fireplace_Z")));
        }
        this.lastTimeFished = compound.m_128454_("lastTimeFished");
        if (compound.m_128425_("koa_inventory", 9)) {
            ListTag nbttaglist = compound.m_128437_("koa_inventory", 10);
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundTag nbttagcompound = nbttaglist.m_128728_(i);
                int j = nbttagcompound.m_128445_("Slot") & 0xFF;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)nbttagcompound));
            }
        }
        this.villageID = compound.m_128451_("village_id");
        this.villageDimension = !compound.m_128441_("village_dimension") ? this.f_19853_.m_46472_() : ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(compound.m_128461_("village_dim_id")));
        if (compound.m_128441_("role_id")) {
            this.m_20088_().m_135381_(ROLE, (Object)compound.m_128451_("role_id"));
        } else {
            this.rollDiceRole();
        }
        if (compound.m_128441_("gender_id")) {
            this.m_20088_().m_135381_(GENDER, (Object)compound.m_128451_("gender_id"));
        } else {
            this.rollDiceGender();
        }
        this.lastTradeTime = compound.m_128454_("lastTradeTime");
        for (int i = 0; i < MAX_DRUMS; ++i) {
            if (!compound.m_128441_("drum_" + i + "_X")) continue;
            this.listPosDrums.add(new BlockPos(compound.m_128451_("drum_" + i + "_X"), compound.m_128451_("drum_" + i + "_Y"), compound.m_128451_("drum_" + i + "_Z")));
        }
        this.druggedTime = compound.m_128451_("druggedTime");
        this.updateUniqueEntityAI();
    }

    public void setFishingItem() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
    }

    public void setFightingItem() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TropicraftItems.DAGGER.get()));
    }

    public void monitorHomeVillage() {
        if (this.villageDimension != null && this.f_19853_.m_46472_() != this.villageDimension) {
            this.dbg("koa detected different dimension, zapping memory");
            this.zapMemory();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5));
        }
    }

    public void findAndSetHomeToCloseChest(boolean force) {
        if (!force && (this.f_19853_.m_46467_() + (long)this.m_19879_()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.m_21534_().equals((Object)BlockPos.f_121853_)) {
            tryFind = true;
        } else {
            BlockEntity tile = this.f_19853_.m_7702_(this.m_21534_());
            if (!(tile instanceof ChestBlockEntity)) {
                tryFind = true;
            }
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.m_20183_().m_7918_(x, y, z);
                        BlockEntity tile = this.f_19853_.m_7702_(pos);
                        if (!(tile instanceof ChestBlockEntity)) continue;
                        this.dbg("found chest, updating home position to " + pos);
                        this.m_21446_(pos, MAX_HOME_DISTANCE);
                        return;
                    }
                }
            }
        }
    }

    public boolean findAndSetTownID(boolean force) {
        if (!force && (this.f_19853_.m_46467_() + (long)this.m_19879_()) % 600L != 0L) {
            return false;
        }
        boolean tryFind = false;
        if (this.villageID == -1 || this.villageDimension == null) {
            tryFind = true;
            this.villageID = -1;
        }
        if (tryFind) {
            List listEnts = this.f_19853_.m_45976_(EntityKoaBase.class, new AABB(this.m_20183_()).m_82377_(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                if (ent.villageID == -1 || ent.villageDimension == null) continue;
                this.setVillageAndDimID(ent.villageID, ent.villageDimension);
                break;
            }
        }
        return this.villageID != -1;
    }

    public void findAndSetFireSource(boolean force) {
        BlockState state;
        if (!force && (this.f_19853_.m_46467_() + (long)this.m_19879_()) % 600L != 0L) {
            return;
        }
        boolean tryFind = false;
        if (this.posLastFireplaceFound == null) {
            tryFind = true;
        } else if (this.posLastFireplaceFound != null && (state = this.f_19853_.m_8055_(this.posLastFireplaceFound)).m_60734_() != Blocks.f_50683_) {
            this.posLastFireplaceFound = null;
            tryFind = true;
        }
        if (tryFind) {
            int range = 20;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range / 2; y <= range / 2; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos pos = this.m_20183_().m_7918_(x, y, z);
                        BlockState state2 = this.f_19853_.m_8055_(pos);
                        if (state2.m_60734_() != Blocks.f_50683_) continue;
                        this.dbg("found fire place spot to chill");
                        this.setFirelacePos(pos);
                        return;
                    }
                }
            }
            List listEnts = this.f_19853_.m_45976_(EntityKoaBase.class, new AABB(this.m_20183_()).m_82377_(20.0, 20.0, 20.0));
            Collections.shuffle(listEnts);
            for (EntityKoaBase ent : listEnts) {
                BlockState state3;
                if (ent.posLastFireplaceFound == null || (state3 = this.f_19853_.m_8055_(ent.posLastFireplaceFound)).m_60734_() != Blocks.f_50683_) continue;
                this.posLastFireplaceFound = new BlockPos((Vec3i)ent.posLastFireplaceFound);
                this.dbg("found fire place spot to chill from entity");
                return;
            }
        }
    }

    public void syncBPM() {
        if ((this.f_19853_.m_46467_() + (long)this.m_19879_()) % 20L != 0L) {
            return;
        }
        List listEnts = this.f_19853_.m_45976_(EntityKoaBase.class, new AABB(this.m_20183_()).m_82377_(10.0, 5.0, 10.0));
        for (EntityKoaBase ent : listEnts) {
            if (this.hitDelay == ent.hitDelay) continue;
            this.hitDelay = ent.hitDelay;
            this.hitIndex = ent.hitIndex;
            this.hitIndex2 = ent.hitIndex2;
            this.hitIndex3 = ent.hitIndex3;
            return;
        }
    }

    public boolean isInstrument(BlockPos pos) {
        BlockState state = this.f_19853_.m_8055_(pos);
        return state.m_204336_(TropicraftTags.Blocks.BONGOS) || state.m_60713_(Blocks.f_50065_);
    }

    public void findAndSetDrums(boolean force) {
        if (!force && (this.f_19853_.m_46467_() + (long)this.m_19879_()) % 600L != 0L) {
            return;
        }
        Iterator<BlockPos> it = this.listPosDrums.iterator();
        while (it.hasNext()) {
            BlockPos pos = it.next();
            if (this.isInstrument(pos)) continue;
            it.remove();
        }
        if (this.listPosDrums.size() >= MAX_DRUMS) {
            return;
        }
        List listEnts = this.f_19853_.m_45976_(EntityKoaBase.class, new AABB(this.m_20183_()).m_82377_(20.0, 20.0, 20.0));
        Collections.shuffle(listEnts);
        for (EntityKoaBase ent : listEnts) {
            if (this.listPosDrums.size() >= MAX_DRUMS) {
                return;
            }
            for (BlockPos pos : ent.listPosDrums) {
                boolean match = false;
                for (BlockPos pos2 : this.listPosDrums) {
                    if (!pos.equals((Object)pos2)) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    this.listPosDrums.add(pos);
                }
                if (this.listPosDrums.size() < MAX_DRUMS) continue;
                return;
            }
        }
        int range = 20;
        for (int x = -range; x <= range; ++x) {
            for (int y = -range / 2; y <= range / 2; ++y) {
                for (int z = -range; z <= range; ++z) {
                    BlockPos pos = this.m_20183_().m_7918_(x, y, z);
                    if (!this.isInstrument(pos)) continue;
                    boolean match = false;
                    for (BlockPos pos2 : this.listPosDrums) {
                        if (!pos.equals((Object)pos2)) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        this.listPosDrums.add(pos);
                    }
                    if (this.listPosDrums.size() < MAX_DRUMS) continue;
                    return;
                }
            }
        }
    }

    public boolean tryDumpInventoryIntoHomeChest() {
        BlockEntity tile = this.f_19853_.m_7702_(this.m_21534_());
        if (tile instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                this.inventory.m_6836_(i, this.addItem(chest, itemstack));
            }
        }
        return true;
    }

    @Nullable
    public ItemStack addItem(ChestBlockEntity chest, ItemStack stack) {
        ItemStack itemstack = stack.m_41777_();
        for (int i = 0; i < chest.m_6643_(); ++i) {
            ItemStack itemstack1 = chest.m_8020_(i);
            if (itemstack1.m_41619_()) {
                chest.m_6836_(i, itemstack);
                chest.m_6596_();
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_41746_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            int j = Math.min(chest.m_6893_(), itemstack1.m_41741_());
            int k = Math.min(itemstack.m_41613_(), j - itemstack1.m_41613_());
            if (k <= 0) continue;
            itemstack1.m_41769_(k);
            itemstack.m_41774_(k);
            if (itemstack.m_41613_() > 0) continue;
            chest.m_6596_();
            return ItemStack.f_41583_;
        }
        if (itemstack.m_41613_() != stack.m_41613_()) {
            chest.m_6596_();
        }
        return itemstack;
    }

    public void setFirelacePos(BlockPos pos) {
        this.posLastFireplaceFound = pos;
    }

    public int m_20146_() {
        return super.m_20146_();
    }

    protected void m_8058_(MerchantOffer offer) {
        super.m_8058_(offer);
        if (this.m_35527_()) {
            this.updateMerchantTimer = 40;
            this.increaseProfessionLevelOnUpdate = true;
        }
        if (this.f_19796_.m_188503_(3) == 0) {
            this.m_35510_();
        }
    }

    private boolean m_35527_() {
        int level = this.m_7141_().m_35576_();
        return VillagerData.m_35582_((int)level) && this.m_7809_() >= VillagerData.m_35577_((int)level);
    }

    private void m_35528_() {
        this.m_34375_(this.m_7141_().m_35561_(this.m_7141_().m_35576_() + 1));
        this.m_7604_();
    }

    public void m_35510_() {
        for (MerchantOffer offer : this.m_6616_()) {
            offer.m_45372_();
        }
    }

    public void m_8107_() {
        if (this.finalizedSpawn) {
            this.finalizedSpawn = false;
            this.findAndSetHomeToCloseChest(true);
            this.findAndSetFireSource(true);
            this.findAndSetDrums(true);
        }
        this.m_21203_();
        super.m_8107_();
        if (this.wasInWater && !this.m_20069_() && this.f_19862_) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.jumpingOutOfWater = true;
        }
        if (this.jumpingOutOfWater && this.f_19861_) {
            this.jumpingOutOfWater = false;
            this.m_21573_().m_26573_();
        }
        if (this.m_20069_()) {
            if (this.m_6162_()) {
                if (this.m_20184_().f_82480_ < (double)-0.1f) {
                    this.m_20184_().m_82520_(0.0, 0.25, 0.0);
                }
            } else if (this.m_20184_().f_82480_ < (double)-0.2f) {
                this.m_20184_().m_82520_(0.0, (double)0.15f, 0.0);
            }
            this.m_21051_(Attributes.f_22279_).m_22100_(0.6);
            this.m_21441_(BlockPathTypes.WATER, 8.0f);
        } else {
            this.m_21051_(Attributes.f_22279_).m_22100_(0.28);
            this.m_21441_(BlockPathTypes.WATER, -1.0f);
        }
        this.wasInWater = this.m_20069_();
        if (!this.wasNightLastTick && !this.f_19853_.m_46461_()) {
            this.rollDiceParty();
        }
        boolean bl = this.wasNightLastTick = !this.f_19853_.m_46461_();
        if (!this.f_19853_.f_46443_ && this.druggedTime > 0) {
            --this.druggedTime;
        }
        if (this.f_19853_.f_46443_ && this.clientHealthLastTracked != this.m_21223_()) {
            if (this.m_21223_() > this.clientHealthLastTracked) {
                this.f_19853_.m_6493_((ParticleOptions)ParticleTypes.f_123750_, false, this.m_20185_(), this.m_20186_() + 2.2, this.m_20189_(), 0.0, 0.0, 0.0);
            }
            this.clientHealthLastTracked = this.m_21223_();
        }
    }

    public void m_5634_(float healAmount) {
        super.m_5634_(healAmount);
    }

    public void setMating(boolean mating) {
        this.isMating = mating;
    }

    public boolean isMating() {
        return this.isMating;
    }

    public boolean getIsWillingToMate(boolean updateFirst) {
        this.setIsWillingToMate(true);
        return true;
    }

    public void setIsWillingToMate(boolean b) {
    }

    public int getVillageID() {
        return this.villageID;
    }

    public void setVillageAndDimID(int villageID, ResourceKey<Level> villageDimID) {
        this.villageID = villageID;
        this.villageDimension = villageDimID;
    }

    public ResourceKey<Level> getVillageDimension() {
        return this.villageDimension;
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
    }

    public void hookUnloaded() {
        if (!this.f_19853_.f_46443_) {
            // empty if block
        }
    }

    public FishingBobberEntity getLure() {
        return this.lure;
    }

    public void setLure(FishingBobberEntity lure) {
        this.lure = lure;
        if (!this.f_19853_.f_46443_) {
            if (lure != null) {
                this.m_20088_().m_135381_(LURE_ID, (Object)this.lure.m_19879_());
            } else {
                this.m_20088_().m_135381_(LURE_ID, (Object)-1);
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (!(this.m_21223_() <= 0.0f) || source.m_7639_() instanceof LivingEntity) {
            // empty if block
        }
        return result;
    }

    public boolean isPartyNight() {
        long time = this.f_19853_.m_46468_();
        long day = time / 24000L;
        return day % 3L == 0L;
    }

    public void rollDiceParty() {
        int chance;
        if (this.isPartyNight() && (chance = 90) >= this.f_19853_.f_46441_.m_188503_(100)) {
            this.wantsToParty = true;
            return;
        }
        this.wantsToParty = false;
    }

    public boolean getWantsToParty() {
        return this.wantsToParty;
    }

    public Component m_5446_() {
        return Component.m_237115_((String)("entity.tropicraft.koa." + this.getGender().toString().toLowerCase(Locale.ROOT) + "." + this.getRole().toString().toLowerCase(Locale.ROOT) + ".name"));
    }

    public void m_8038_(ServerLevel world, LightningBolt lightning) {
    }

    public void zapMemory() {
        this.listPosDrums.clear();
        this.m_21446_(BlockPos.f_121853_, -1);
        this.setFirelacePos(null);
        this.villageDimension = null;
        this.villageID = -1;
    }

    public void dbg(String msg) {
        if (this.debug) {
            System.out.println(msg);
        }
    }

    public void m_5496_(SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.f_12509_ || soundIn == SoundEvents.f_12507_) {
            return;
        }
        super.m_5496_(soundIn, volume, pitch);
    }

    public void setPlaying(boolean playing) {
        this.isPlaying = playing;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.KOA_SPAWN_EGG.get());
    }

    public static enum Genders {
        MALE,
        FEMALE;

        private static final Map<Integer, Genders> lookup;

        public static Genders get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Genders>();
            for (Genders e : EnumSet.allOf(Genders.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    public static enum Roles {
        HUNTER,
        FISHERMAN;

        private static final Map<Integer, Roles> lookup;

        public static Roles get(int intValue) {
            return lookup.get(intValue);
        }

        static {
            lookup = new HashMap<Integer, Roles>();
            for (Roles e : EnumSet.allOf(Roles.class)) {
                lookup.put(e.ordinal(), e);
            }
        }
    }

    static class ItemToPearlTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int count;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public ItemToPearlTrade(ItemLike item, int count, int maxUses, int givenXP) {
            this.item = item.m_5456_();
            this.count = count;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
            return new MerchantOffer(stack, new ItemStack((ItemLike)TropicraftItems.WHITE_PEARL.get()), this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    static class PearlToItemTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int count;
        private final int sellCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public PearlToItemTrade(ItemLike item, int count, int sellCount, int maxUses, int givenXP) {
            this.item = item.m_5456_();
            this.count = count;
            this.sellCount = sellCount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack stack = new ItemStack((ItemLike)this.item, this.count);
            return new MerchantOffer(new ItemStack((ItemLike)TropicraftItems.WHITE_PEARL.get(), this.sellCount), stack, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }

    static class PearlToEnchantItemTrade
    implements VillagerTrades.ItemListing {
        private final Item item;
        private final int sellCount;
        private final int maxUses;
        private final int givenXP;
        private final float priceMultiplier;

        public PearlToEnchantItemTrade(ItemLike item, int sellCount, int maxUses, int givenXP) {
            this.item = item.m_5456_();
            this.sellCount = sellCount;
            this.maxUses = maxUses;
            this.givenXP = givenXP;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            int enchantLevel = random.m_188503_(10) + 5;
            int cost = Mth.m_14143_((float)((float)enchantLevel / 1.5f));
            ItemStack stack = new ItemStack((ItemLike)this.item, 1);
            stack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)stack, (int)enchantLevel, (boolean)false);
            return new MerchantOffer(new ItemStack((ItemLike)TropicraftItems.WHITE_PEARL.get(), this.sellCount + cost), stack, this.maxUses, this.givenXP, this.priceMultiplier);
        }
    }
}

