/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.passive.monkey;

import com.google.common.base.Suppliers;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.Easings;
import net.tropicraft.core.common.TropicraftTags;
import net.tropicraft.core.common.item.TropicraftItems;

public class SpiderMonkeyEntity
extends Animal {
    private static final Supplier<Ingredient> BREEDING_ITEMS = Suppliers.memoize(() -> Ingredient.m_204132_(TropicraftTags.Items.FRUITS));
    private static final int STAND_ANIMATION_LENGTH = 15;
    private static final EntityDataAccessor<Boolean> STANDING = SynchedEntityData.m_135353_(SpiderMonkeyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int standAnimation;

    public SpiderMonkeyEntity(EntityType<? extends SpiderMonkeyEntity> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, BREEDING_ITEMS.get(), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.2f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STANDING, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.tickStandingState();
        } else {
            this.tickStandingAnimation();
        }
    }

    private void tickStandingState() {
        if (this.m_21188_() != null) {
            this.setStanding(false);
            return;
        }
        if (this.f_19853_.f_46441_.m_188503_(200) == 0) {
            boolean standing = this.f_19853_.f_46441_.m_188503_(3) == 0;
            this.setStanding(standing);
        }
    }

    private void tickStandingAnimation() {
        if (this.isStanding()) {
            if (this.standAnimation < 15) {
                ++this.standAnimation;
            }
        } else if (this.standAnimation > 0) {
            --this.standAnimation;
        }
    }

    public void setStanding(boolean standing) {
        this.f_19804_.m_135381_(STANDING, (Object)standing);
        this.standAnimation = standing ? 15 : 0;
    }

    public boolean isStanding() {
        return (Boolean)this.f_19804_.m_135370_(STANDING);
    }

    public float getStandAnimation(float partialTicks) {
        float animation = ((float)this.standAnimation + (this.isStanding() ? partialTicks : -partialTicks)) / 15.0f;
        return Easings.inOutSine(Mth.m_14036_((float)animation, (float)0.0f, (float)1.0f));
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setStanding(nbt.m_128471_("standing"));
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("standing", this.isStanding());
    }

    public boolean m_6898_(ItemStack stack) {
        return false;
    }

    public SpiderMonkeyEntity getBreedOffspring(ServerLevel world, AgeableMob mate) {
        return null;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.SPIDER_MONKEY_SPAWN_EGG.get());
    }

    public int m_6056_() {
        return 5;
    }

    protected int m_5639_(float distance, float damageMultiplier) {
        return super.m_5639_(distance, damageMultiplier) / 2;
    }
}

