/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.tropicraft.core.common.item.TropicraftItems;

public class EagleRayEntity
extends AbstractFish {
    public static final int WING_JOINTS = 10;
    public static final int WING_CYCLE_TICKS = 60;
    public static final float PHASES = 0.33f;
    private float[] wingAmplitudes = new float[10];
    private float[] prevWingAmplitudes = new float[10];
    private int animationTicks;

    public EagleRayEntity(EntityType<? extends EagleRayEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder m_27495_() {
        return AbstractFish.m_27495_().m_22268_(Attributes.f_22276_, 10.0);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        return InteractionResult.PASS;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.animationTicks = this.animationTicks < 60 ? ++this.animationTicks : 0;
            this.updateWingAmplitudes();
        }
    }

    private void updateWingAmplitudes() {
        float[] temp = this.prevWingAmplitudes;
        this.prevWingAmplitudes = this.wingAmplitudes;
        this.wingAmplitudes = temp;
        for (int i = 1; i < 10; ++i) {
            this.wingAmplitudes[i] = this.amplitudeFunc(i);
        }
    }

    private float decayFunc(float n) {
        return n / 9.0f;
    }

    private float amplitudeFunc(float n) {
        double angle = Math.PI * 2 * (double)(-n) / 9.0;
        return this.decayFunc(n) * Mth.m_14031_((float)((float)((double)(this.getAnimationProgress() * 2.0f) * Math.PI + (double)0.33f * angle)));
    }

    private float getAnimationProgress() {
        return (float)this.animationTicks / 60.0f;
    }

    public float[] getWingAmplitudes() {
        return this.wingAmplitudes;
    }

    public float[] getPrevWingAmplitudes() {
        return this.prevWingAmplitudes;
    }

    public ItemStack m_28282_() {
        return ItemStack.f_41583_;
    }

    protected SoundEvent m_5699_() {
        return SoundEvents.f_12329_;
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)TropicraftItems.EAGLE_RAY_SPAWN_EGG.get());
    }
}

