/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.entity.underdasea;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.tropicraft.core.common.entity.egg.EggEntity;

public abstract class EchinodermEntity
extends WaterAnimal {
    public static final int GROWTH_TICKS = 12000;
    public static final int BREEDING_COOLDOWN = 12000;
    public static final int BREEDING_PROXIMITY = 4;
    public static final int MAX_NEIGHBORS = 6;
    public static final int NEIGHBORHOOD_SIZE = 8;
    public static final int MATE_SCAN_INTERVAL = 100;
    private int prevGrowingAge;
    private int mateScanCooldown;
    private static final EntityDataAccessor<Integer> GROWING_AGE = SynchedEntityData.m_135353_(EchinodermEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private double yOffset = -1.0;

    public EchinodermEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.setEchinodermSize();
    }

    public void setBaby() {
        this.setGrowingAge(-12000);
        this.setEchinodermSize();
    }

    public abstract EggEntity createEgg();

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GROWING_AGE, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setGrowingAge(compound.m_128451_("Age"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Age", this.getGrowingAge());
    }

    public void m_147240_(double strength, double ratioX, double ratioZ) {
    }

    public boolean m_6162_() {
        return this.getGrowingAge() < 0;
    }

    public boolean isHorny() {
        return this.getGrowingAge() == 0;
    }

    private EchinodermEntity findMate() {
        int neighbors = 0;
        EchinodermEntity closestMate = null;
        double closestSqDist = -1.0;
        AABB aabb = this.m_20191_().m_82377_(8.0, 8.0, 8.0);
        for (Object obj : this.f_19853_.m_45976_(((Object)((Object)this)).getClass(), aabb)) {
            double sqDist;
            if (obj == this) continue;
            ++neighbors;
            EchinodermEntity other = (EchinodermEntity)((Object)obj);
            if (!this.isPotentialMate(other) || !((sqDist = this.m_20280_((Entity)other)) < 4.0) || closestSqDist != -1.0 && !(sqDist < closestSqDist)) continue;
            closestMate = other;
            closestSqDist = sqDist;
        }
        if (neighbors > 6) {
            return null;
        }
        return closestMate;
    }

    public boolean isPotentialMate(EchinodermEntity other) {
        return !other.m_6162_() && other.isHorny();
    }

    public int getGrowingAge() {
        return (Integer)this.f_19804_.m_135370_(GROWING_AGE);
    }

    public void setGrowingAge(int age) {
        this.f_19804_.m_135381_(GROWING_AGE, (Object)age);
    }

    public float getGrowthProgress() {
        int growingAge = this.getGrowingAge();
        return growingAge < 0 ? 1.0f + (float)growingAge / 12000.0f : 1.0f;
    }

    private void setEchinodermSize() {
        float growthProgress = this.getGrowthProgress();
        float width = this.getBabyWidth() + growthProgress * (this.getAdultWidth() - this.getBabyWidth());
        float height = this.getBabyHeight() + growthProgress * (this.getAdultHeight() - this.getBabyHeight());
        float yO = this.getBabyYOffset() + growthProgress * (this.getAdultYOffset() - this.getBabyYOffset());
        this.m_6210_();
        this.yOffset = yO;
    }

    public double m_6049_() {
        if (this.yOffset < 0.0) {
            return super.m_6049_();
        }
        return this.yOffset;
    }

    public abstract float getBabyWidth();

    public abstract float getAdultWidth();

    public abstract float getBabyHeight();

    public abstract float getAdultHeight();

    public abstract float getBabyYOffset();

    public abstract float getAdultYOffset();
}

