/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.tropicraft.core.client.TropicraftRenderLayers;
import net.tropicraft.core.client.TropicraftRenderUtils;
import net.tropicraft.core.client.entity.model.PlayerHeadpieceModel;
import net.tropicraft.core.common.entity.placeable.WallItemEntity;
import net.tropicraft.core.common.item.AshenMasks;

public class AshenMaskItem
extends ArmorItem {
    private final AshenMasks maskType;

    public AshenMaskItem(ArmorMaterial armorMaterial, AshenMasks maskType, Item.Properties properties) {
        super(armorMaterial, EquipmentSlot.HEAD, properties);
        this.maskType = maskType;
    }

    public AshenMasks getMaskType() {
        return this.maskType;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockPos offsetPos = pos.m_121945_(direction);
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        if (player != null && !this.canPlace(player, direction, itemStack, offsetPos)) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        WallItemEntity wallItem = new WallItemEntity(world, offsetPos, direction);
        wallItem.m_31805_(itemStack);
        if (wallItem.m_7088_()) {
            if (!world.f_46443_) {
                wallItem.m_7084_();
                world.m_7967_((Entity)wallItem);
            }
            itemStack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean canPlace(Player player, Direction direction, ItemStack heldStack, BlockPos pos) {
        return player.m_36204_(pos, direction, heldStack);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                return AshenMaskItem.this.f_40377_ == EquipmentSlot.HEAD ? PlayerHeadpieceModel.createModel(TropicraftRenderLayers.ASHEN_MASK_LAYERS.get(AshenMaskItem.this.maskType.ordinal()), null, AshenMaskItem.this.maskType.ordinal(), AshenMaskItem.this.maskType.getXOffset(), AshenMaskItem.this.maskType.getYOffset()) : null;
            }
        });
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return TropicraftRenderUtils.getTextureEntity("ashen/mask").toString();
    }
}

