/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.Collection;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BlowGunItem
extends ProjectileWeaponItem {
    public BlowGunItem(Item.Properties properties) {
        super(properties);
    }

    public Predicate<ItemStack> m_6437_() {
        return itemStack -> {
            if (itemStack.m_41720_() == Items.f_42738_) {
                for (MobEffectInstance effectInstance : PotionUtils.m_43547_((ItemStack)itemStack)) {
                    if (effectInstance.m_19544_() != MobEffects.f_19597_) continue;
                    return true;
                }
            }
            return false;
        };
    }

    public int m_6615_() {
        return 8;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        ItemStack ammo = BlowGunItem.getAmmo((LivingEntity)player, heldStack);
        if (!ammo.m_41619_()) {
            BlowGunItem.fireProjectile(world, (LivingEntity)player, hand, heldStack, ammo, 1.0f, player.m_150110_().f_35937_, 10.0f, 0.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)heldStack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)heldStack);
    }

    private static ItemStack getAmmo(LivingEntity entityIn, ItemStack stack) {
        boolean isCreativeMode = entityIn instanceof Player && ((Player)entityIn).m_150110_().f_35937_;
        ItemStack ammo = entityIn.m_6298_(stack);
        if (isCreativeMode) {
            return BlowGunItem.getProjectile();
        }
        if (!ammo.m_41619_()) {
            return ammo;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getProjectile() {
        ItemStack itemStack = new ItemStack((ItemLike)Items.f_42738_);
        itemStack = PotionUtils.m_43552_((ItemStack)itemStack, (Collection)ImmutableList.of((Object)new MobEffectInstance(MobEffects.f_19597_, 60, 20)));
        return itemStack;
    }

    public static void fireProjectile(Level world, LivingEntity shooter, InteractionHand hand, ItemStack heldItem, ItemStack projectile, float soundPitch, boolean isCreativeMode, float dmg, float pitch) {
        if (!world.f_46443_) {
            Arrow arrowEntity = BlowGunItem.createArrow(world, shooter, projectile);
            if (isCreativeMode) {
                arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            Vec3 lookVec = shooter.m_20154_();
            Quaternion quaternion = new Quaternion(new Vector3f(lookVec), 0.0f, true);
            Vec3 look = shooter.m_20252_(1.0f);
            Vector3f look3f = new Vector3f(look);
            look3f.m_122251_(quaternion);
            arrowEntity.m_6686_((double)look3f.m_122239_(), (double)look3f.m_122260_(), (double)look3f.m_122269_(), dmg, pitch);
            heldItem.m_41622_(1, shooter, i -> i.m_21190_(hand));
            projectile.m_41620_(1);
            if (projectile.m_41619_() && shooter instanceof Player) {
                ((Player)shooter).m_150109_().m_36057_(projectile);
            }
            world.m_7967_((Entity)arrowEntity);
            world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }

    public static Arrow createArrow(Level world, LivingEntity shooter, ItemStack projectile) {
        ArrowItem arrowItem = (ArrowItem)(projectile.m_41720_() instanceof ArrowItem ? projectile.m_41720_() : Items.f_42412_);
        Arrow arrowEntity = (Arrow)arrowItem.m_6394_(world, projectile, shooter);
        arrowEntity.m_36781_(0.0);
        arrowEntity.m_36740_(SoundEvents.f_11840_);
        arrowEntity.m_36762_(false);
        arrowEntity.m_36878_(BlowGunItem.getProjectile());
        return arrowEntity;
    }
}

