/*
 * Decompiled with CFR 0.152.
 */
package net.tropicraft.core.common.item;

import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.tropicraft.core.common.item.ArmorMaterials;
import net.tropicraft.core.common.item.TropicraftArmorItem;
import net.tropicraft.core.common.item.TropicraftItems;

public class FireArmorItem
extends TropicraftArmorItem {
    public FireArmorItem(EquipmentSlot slotType, Item.Properties properties) {
        super(ArmorMaterials.FIRE_ARMOR, slotType, properties);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        if (world.f_46443_) {
            this.clientTick(player);
        } else {
            if (player.m_6060_()) {
                player.m_20095_();
            }
            int factor = (int)(40.0 / (0.001 + (double)world.m_220417_(player.m_20183_())));
            if (world.m_46467_() % (long)factor == 0L && world.m_46861_(new BlockPos(Mth.m_14107_((double)player.m_20185_()), Mth.m_14107_((double)(player.m_20186_() + 1.0)), Mth.m_14107_((double)player.m_20189_())))) {
                stack.m_41622_(-1, (LivingEntity)player, e -> e.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(Player player) {
        ParticleStatus particles;
        if (player.m_20069_()) {
            return;
        }
        float range = 0.2f;
        float speed = 0.08f;
        RandomSource rand = RandomSource.m_216327_();
        int extraRand = 0;
        Vec3 motion = player.m_20184_();
        double plSpeed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
        if (plSpeed < (double)0.1f) {
            extraRand = 7;
        }
        if ((particles = (ParticleStatus)Minecraft.m_91087_().f_91066_.m_231929_().m_231551_()) == ParticleStatus.MINIMAL) {
            return;
        }
        if (this == TropicraftItems.FIRE_BOOTS.get()) {
            BlockState block2;
            BlockState state;
            boolean onLava = false;
            boolean inLava = false;
            boolean x = false;
            boolean z = false;
            if (motion.f_82480_ < 0.0 && (state = player.f_19853_.m_8055_(new BlockPos(Mth.m_14107_((double)(player.m_20185_() + (double)x)), Mth.m_14107_((double)(player.m_20186_() - 2.0)), Mth.m_14107_((double)(player.m_20189_() + (double)z))))).m_60767_() == Material.f_76307_) {
                onLava = true;
            }
            if ((block2 = player.f_19853_.m_8055_(new BlockPos(Mth.m_14107_((double)(player.m_20185_() + (double)x)), Mth.m_14107_((double)(player.m_20186_() - 1.0)), Mth.m_14107_((double)(player.m_20189_() + (double)z))))).m_60767_() == Material.f_76307_) {
                inLava = true;
            }
            if (onLava && !inLava) {
                player.m_20256_(motion.m_82542_(1.0, 0.0, 1.0));
                player.m_6853_(true);
            }
            if (inLava && plSpeed < 0.4) {
                player.m_20256_(motion.m_82542_(1.5, 1.5, 1.5));
            }
            float look = player.f_19853_.m_46467_() * (long)(10 + (onLava ? 10 : 0));
            double dist = 1.0;
            double gatherX = player.m_20185_();
            double gatherY = player.m_20191_().f_82289_;
            double gatherZ = player.m_20189_();
            double motionX = rand.m_188501_() * speed - speed / 2.0f;
            double motionZ = rand.m_188501_() * speed - speed / 2.0f;
            int numFeetParticles = particles == ParticleStatus.DECREASED ? 2 : 11;
            for (int i = 0; i < numFeetParticles + (onLava ? 5 : 0); ++i) {
                motionX = -Math.sin(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.m_188500_());
                motionZ = Math.cos(look / 180.0f * (float)Math.PI) * Math.cos(0.0) * ((double)speed + 0.1 * rand.m_188500_());
                SimpleParticleType particle = ParticleTypes.f_123744_;
                if (rand.m_188503_(22) == 0) {
                    particle = ParticleTypes.f_123755_;
                }
                if (!onLava && rand.m_188503_(1 + extraRand) != 0) continue;
                Vec3 motion1 = player.m_20184_();
                player.f_19853_.m_7106_((ParticleOptions)particle, gatherX + (double)(rand.m_188501_() * range - range / 2.0f), gatherY + (double)(rand.m_188501_() * range - range / 2.0f), gatherZ + (double)(rand.m_188501_() * range - range / 2.0f), motion1.f_82479_ + motionX, (double)0.01f, motion1.f_82481_ + motionZ);
                player.f_19853_.m_7106_((ParticleOptions)particle, gatherX + (double)(rand.m_188501_() * range - range / 2.0f), gatherY + (double)(rand.m_188501_() * range - range / 2.0f), gatherZ + (double)(rand.m_188501_() * range - range / 2.0f), motion1.f_82479_ - motionX, (double)0.01f, motion1.f_82481_ - motionZ);
            }
        } else if (this == TropicraftItems.FIRE_LEGGINGS.get()) {
            SimpleParticleType particle = ParticleTypes.f_123744_;
            if (rand.m_188503_(2) == 0) {
                particle = ParticleTypes.f_123755_;
            }
            if (rand.m_188503_(3 + extraRand) == 0) {
                player.f_19853_.m_7106_((ParticleOptions)particle, player.m_20185_() + (double)(rand.m_188501_() * range - range / 2.0f), player.m_20186_() - (double)0.8f + (double)(rand.m_188501_() * range - range / 2.0f), player.m_20189_() + (double)(rand.m_188501_() * range - range / 2.0f), (double)(rand.m_188501_() * speed - speed / 2.0f), (double)-0.05f, (double)(rand.m_188501_() * speed - speed / 2.0f));
            }
        } else if (this == TropicraftItems.FIRE_CHESTPLATE.get()) {
            float look = -180.0f;
            double dist = 0.5;
            double gatherX = player.m_20185_() + -Math.sin((player.m_146908_() + look) / 180.0f * (float)Math.PI) * Math.cos(player.m_146909_() / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.m_20189_() + Math.cos((player.m_146908_() + look) / 180.0f * (float)Math.PI) * Math.cos(player.m_146909_() / 180.0f * (float)Math.PI) * dist;
            SimpleParticleType particle = ParticleTypes.f_123744_;
            if (rand.m_188503_(2) == 0) {
                particle = ParticleTypes.f_123755_;
            }
            if (rand.m_188503_(1 + extraRand) == 0) {
                player.f_19853_.m_7106_((ParticleOptions)particle, gatherX + (double)(rand.m_188501_() * range - range / 2.0f), player.m_20186_() - (double)0.4f + (double)(rand.m_188501_() * range - range / 2.0f), gatherZ + (double)(rand.m_188501_() * range - range / 2.0f), (double)(rand.m_188501_() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.m_188501_() * speed - speed / 2.0f));
            }
        } else if (this == TropicraftItems.FIRE_HELMET.get()) {
            float look = -180.0f;
            double dist = 0.5;
            range = 2.0f;
            double gatherX = player.m_20185_() + -Math.sin((player.m_146908_() + look) / 180.0f * (float)Math.PI) * Math.cos(player.m_146909_() / 180.0f * (float)Math.PI) * dist;
            double gatherZ = player.m_20189_() + Math.cos((player.m_146908_() + look) / 180.0f * (float)Math.PI) * Math.cos(player.m_146909_() / 180.0f * (float)Math.PI) * dist;
            SimpleParticleType particle = ParticleTypes.f_123744_;
            if (rand.m_188503_(2) == 0) {
                particle = ParticleTypes.f_123755_;
            }
            if (rand.m_188503_(2) == 0) {
                player.f_19853_.m_7106_((ParticleOptions)particle, gatherX + (double)(rand.m_188501_() * range - range / 2.0f), player.m_20186_() + (double)0.7f, gatherZ + (double)(rand.m_188501_() * range - range / 2.0f), (double)(rand.m_188501_() * speed - speed / 2.0f), (double)-0.01f, (double)(rand.m_188501_() * speed - speed / 2.0f));
            }
        }
    }
}

